<?php

namespace App\Http\Controllers\api\driver;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Vendors;
use App\Models\Driver;
use App\Models\Vehicle;
use App\Models\AccountDeleteRequest;
use Illuminate\Database\QueryException;
use Throwable;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use App\Models\BookingHistory;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Http;
use App\Models\Fare;
use App\Models\Zone;
use App\Models\SearchHistory;
use App\Models\VehicleCategory;
use App\Models\BrandVehicle;
use App\Models\Settings;
use App\Models\Review;
use Carbon\Carbon;
use App\Models\TripLifeCycle;
use Illuminate\Support\Facades\DB;
use App\Models\Notifications;

class DriverController extends Controller
{
  public function updateProfile(Request $request)
  {
    try {
      $res = Driver::where('id', auth()->user()->id)
        ->update([
          'name' => $request->name,
          'phone' => $request->phone,
          'email' => $request->email,
          'address' => $request->address,
          'aadhar_no' => $request->aadhar_no,
          'licence_number' => $request->licence_number,
          'licence_validity' => $request->licence_validity,
          'zone' => $request->zone_id,
        ]);
      if ($request->photo) {
        $data = Driver::where('id', auth()->user()->id)->first();
       
        if ((file_exists(public_path('uploads/driver/' . $data->image))) && ($data->image != NULL)) {
          unlink("uploads/driver/" . $data->image);
        }
      
        $rand = rand(100, 999);
        $image = time() . '.' . $request->photo->extension();
        $imageOriginalName = $request->photo->getClientOriginalName();
        $request->photo->move(public_path('uploads/driver/'), $image);


        $res = Driver::where('id', auth()->user()->id)
          ->update(['image' => $image]);
      }

      if ($request->licence) {

        $data = Driver::where('id', auth()->user()->id)->first();
        if ((file_exists(public_path('uploads/driver/licence/', $data->licence))) && ($data->licence != NULL)) {
          unlink("uploads/driver/licence/" . $data->licence);
        }
        $rand = rand(100, 999);
        $licence_image = time() . '.' . $request->licence->extension();
        $imageOriginalName = $request->licence->getClientOriginalName();
        $request->licence->move(public_path('uploads/driver/licence/'), $licence_image);
        $res =  Driver::where('id', auth()->user()->id)
          ->update([
            'licence' => $licence_image,
          ]);
      }
      if ($res == 1) {
         $user = Driver::where('id', auth()->user()->id)->first();
      if ($user->image == NULL) {
        $user->image = asset('assets/images/user.jpg');
      } else {
        $user->image = asset('uploads/driver/' . $user->image);
      }

      if ($user->licence == NULL) {
        $user->licence = asset('assets/images/user.jpg');
      } else {
        $user->licence = asset('uploads/driver/licence/' . $user->licence);
      }
        return response()->json([
          'status' => true,
          'message' => 'Profile updated successfully',
          'user' => $user
        ]);
      }
    } catch (QueryException $e) {
      return response()->json(['error' => 'Database error ' . $e], 500);
    } catch (Throwable $e) {
      return response()->json(['error' => 'Something went wrong ' . $e], 500);
    }
  }


  public function profile(Request $request)
  {
    try {
      $user = auth()->user();
      if ($user->image == NULL) {
        $user->image = asset('assets/images/user.jpg');
      } else {
        $user->image = asset('uploads/driver/' . $user->image);
      }

      if ($user->licence == NULL) {
        $user->licence = asset('assets/images/user.jpg');
      } else {
        $user->licence = asset('uploads/driver/licence/' . $user->licence);
      }

      $user->makeHidden(['created_at', 'updated_at']);
      return response()->json([
        'status' => true,
        'profile' => $user,
        // 'total_drivers' => count(Driver::where('id', auth()->user()->id)->get()),
        'total_vehicles' => count(Vehicle::where('driver_id', auth()->user()->id)->get()),
        'total_rides' => count(BookingHistory::where('driver_id', auth()->user()->id)->get()),
        'total_active_ride' => count(BookingHistory::where('driver_id', auth()->user()->id)->where('booking_status', 'Running')->get()),
        'total_pending_ride' => count(BookingHistory::where('driver_id', auth()->user()->id)->where('booking_status', 'Upcoming')->get()),
      ]);
    } catch (QueryException $e) {
      return response()->json(['error' => 'Database error ' . $e], 500);
    } catch (Throwable $e) {
      return response()->json(['error' => 'Something went wrong ' . $e], 500);
    }
  }

  // otp verification

  public function sendOtp(Request $request)
  {

    $request->validate(['phone' => 'required']);

    $phone = $request->input('phone');
    $phone = preg_replace('/\s+/', '', $phone);
    // $otp = '12345';
    // Cache::put('otp_' . $phone, $otp, now()->addMinutes(10));
    // return response()->json([
    //   'status' => true,
    //   'message' => 'SUCCESS',
    //   'status_code' => 1000,

    // ]);

    if ($phone == '9188360241' || $phone == '+919188360241' || $phone == '919188360241' || $phone == '+917559091954') {
      $otp = '12345';
      Cache::put('otp_' . $phone, $otp, now()->addMinutes(10));
      return response()->json([
        'status' => true,
        'message' => 'SUCCESS',
        'status_code' => 1000,

      ]);
    } else {
      $otp = rand(10000, 99999);
    }

    // Store OTP temporarily (e.g. 5 minutes)
    Cache::put('otp_' . $phone, $otp, now()->addMinutes(10));
    //    Cache::put('otp_' . $request->phone, $otp, 600);

    // Send OTP using SMS provider (Twilio, etc.)
    // e.g. SmsService::send($request->phone, "Your OTP is $otp");
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => 'https://api.connectpanels.com/whatsapp-api/v1.0/customer/120180/bot/0d094a19d57e4eaa/template',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS => '{"payload":{"name":"otp","components":[{"type":"body","parameters":[{"type":"text","text":"' . $otp . '"}]},{"type":"button","sub_type":"url","index":0,"parameters":[{"type":"text","text":"' . $otp . '"}]}],"language":{"code":"en_US","policy":"deterministic"},"namespace":"66cbcb46_a232_4519_a6e7_b69fd50991bf"},"phoneNumber":"' . $phone . '"}',
      CURLOPT_HTTPHEADER => array(
        'Authorization: Basic c4d8e3eb-4e7c-4f9d-a05c-5ff0bf583d29-Ic1uEZu',
        'Content-Type: application/json'
      ),
    ));

    $response = curl_exec($curl);



    // Convert to array
    $responseData = json_decode($response, true);

    // Use the data
    $messageId = $responseData['responseObject']['message_id'];
    $statusCode = $responseData['status']['code'];
    $statusDesc = $responseData['status']['desc'];
    curl_close($curl);
    return response()->json([
      'status' => true,
      'message' => $statusDesc,
      'status_code' => $statusCode,
      // 'message_id' => $messageId,
      // 'status_code' => $statusCode,
      // 'status_desc' => $statusDesc,
    ]);
  }

  public function verifyOtp(Request $request)
  {


    $request->validate([
      'phone' => 'required',
      'otp' => 'required'
    ]);
    $phone = $request->input('phone');
    $phone = preg_replace('/\s+/', '', $phone);

    //  $phone=$request->phone;
    $storedOtp = Cache::get('otp_' . $phone);

    if ($storedOtp && $storedOtp == $request->otp) {
      // OTP is valid
      // Authenticate or register user logic here

      $user = Driver::where('phone', $phone)->first();

      $user_account = 'exist-user';

      if ($user == null) {
        return response()->json([
          'message' => 'User does not exist.'
        ], 422);
        // Register new user
        // $user = Driver::create([
        //   'phone' => $phone,
        // ]);
        // $user_account = 'new-user';
        // $user = Driver::where('phone', $phone)->first();
      }

      // Check BLOCKED status
      if ($user->status == 'REQUESTED' || $user->status == 'BLOCKED') {
        if (!empty($user->name) && !empty($user->zone)) {
          return response()->json([
            'message' => 'Your account is blocked. Please contact support.'
          ], 403);
        }
      }
      //   Auth::guard('driver')->login($user);

      $token = $user->createToken('driver_auth_token', ['role:driver'])->plainTextToken;
      //  $token = $user->createToken('auth_token')->plainTextToken;
      $user->makeHidden(['created_at', 'updated_at']);
      Cache::forget('otp_' . $phone);
      return response()->json([
        'status' => true,
        'message' => 'OTP verified',
        'user-type' => $user_account,
        'token' => $token,
        'user' => $user,

      ]);
    }

    return response()->json(['message' => 'Invalid OTP'], 422);
  }
  public function logout(Request $request)
  {
    // Delete current access token
    $request->user()->currentAccessToken()->delete();

    return response()->json([
      'status' => true,
      'message' => 'Logged out successfully.'
    ]);
  }

  public function getBookings(Request $request)
  {
    try {

      $bookings = BookingHistory::select('id', 'booking_id', 'departure_date', 'return_date', 'departure_time', 'return_time', 'pick_up', 'drop_off', 'stay_locations', 'booking_status', 'total_fare', 'paid_amount')
        ->where('driver_id', auth()->user()->id)
        ->orderBy('departure_date', 'DESC');
      if ($request->filled('status')) {
        $bookings = $bookings->where('booking_status', $request->status);
      }
      $bookings = $bookings->get();
      foreach ($bookings as $item) {
        $raw = $item->stay_locations; // The double-encoded JSON string

        $firstDecode = json_decode($raw, true);              // returns a JSON string
        $locationsArray = json_decode($firstDecode, true);   // returns the actual PHP array

        $locationString = is_array($locationsArray) ? implode(', ', $locationsArray) : '';

        $item->stay_locations = $locationString;
        //  $item->stay_locations_count = is_array($locationsArray) ? count($locationsArray) : 0;

        $departure = Carbon::parse($item->departure_date);
        $return = Carbon::parse($item->return_date);

        // Total days (inclusive)
        $totalDays = $departure->diffInDays($return) + 1; // +1 to include both start and end dates
        $nightCount = $totalDays - 1;

        // Final title
        $tripTitle = "{$nightCount}NIGHTS {$totalDays}DAYS";
        $item->title = $tripTitle;
      }

      return response()->json([
        'status' => true,
        'data' => $bookings,
      ]);
    } catch (QueryException $e) {
      return response()->json(['error' => 'Database error ' . $e], 500);
    } catch (Throwable $e) {
      return response()->json(['error' => 'Something went wrong ' . $e], 500);
    }
  }

  public function getBookingDetails(Request $request)
  {
    try {

      // $booking= BookingHistory::select('id','vehicle_id','driver_id','booking_id','total_km','departure_date','return_date','departure_time','return_time','pick_up','drop_off','stay_date','stay_locations','adults','children','client_name','client_mobile_number','client_email','booking_status','total_fare','paid_amount')
      // ->where('id',$request->booking_id)
      // ->first();
      $booking =  BookingHistory::select('id', 'booking_id', 'total_km', 'departure_date', 'return_date', 'departure_time', 'return_time', 'pick_up', 'drop_off', 'booking_status', 'stay_date', 'stay_locations', 'adults', 'children', 'client_name', 'client_mobile_number', 'client_email', 'paid_amount', 'total_km_driven', 'extra_km_charge', 'balance_amount')
        ->where('id', $request->booking_id)
        ->where('driver_id', auth()->user()->id)
        ->first();
      if ($booking == null) {
        return response()->json([
          'status' => true,
          'data' => $booking,
        ]);
      }
      $booking->makeHidden(['created_at', 'updated_at']);
      $booking->total_extra_charges = (int) TripLifeCycle::where('booking_id', $booking->id)->sum('additional_charge_collected');
      $booking->total_collected_amount = (int) TripLifeCycle::where('booking_id', $booking->id)->sum('amount_collected');


      // ********** stay location  *********
      $raw = $booking->stay_locations; // The double-encoded JSON string
      $firstDecode = json_decode($raw, true);              // returns a JSON string
      $locationsArray = json_decode($firstDecode, true);   // returns the actual PHP array
      $booking->stay_locations = $locationsArray;
      // ********** stay date end  *********

      // ********** find titile  *********
      $departure = Carbon::parse($booking->departure_date);
      $return = Carbon::parse($booking->return_date);

      // Total days (inclusive)
      $totalDays = $departure->diffInDays($return) + 1; // +1 to include both start and end dates
      $nightCount = $totalDays - 1;

      // Final title
      $tripTitle = "{$nightCount}NIGHTS {$totalDays}DAYS";
      $booking->title = $tripTitle;
      // ********** find titile end  *********

      // ********** stay date  *********
      $raw = $booking->stay_date; // The double-encoded JSON string

      $firstDecode = json_decode($raw, true);              // returns a JSON string
      $locationsArray = json_decode($firstDecode, true);   // returns the actual PHP array

      $booking->stay_date = $locationsArray;
      $trip_life_cycle = TripLifeCycle::select('id as trip_life_cycle_id', 'booking_id', 'day', 'date as stay_date', 'actual_km', 'starting_meter_reading', 'ending_meter_reading', 'km_driven', 'additional_charge_collected', 'amount_collected', 'note', 'remaining_km')
        ->where('booking_id', $booking->id)->get();
      // ********** stay date end *********
      foreach ($trip_life_cycle as $trip) {
        $trip->stay_date = Carbon::parse($trip->date)->format('d F Y');
      }
      $booking->trip_life_cycle = $trip_life_cycle;
      return response()->json([
        'status' => true,
        'data' => $booking,
      ]);
    } catch (QueryException $e) {
      return response()->json(['error' => 'Database error ' . $e], 500);
    } catch (Throwable $e) {
      return response()->json(['error' => 'Something went wrong ' . $e], 500);
    }
  }
  // public function startTripDay(Request $request)
  // {
  //   $request->validate([
  //     'trip_life_cycle_id' => 'required|integer',
  //     'starting_meter_reading' => 'required',
  //   ]);

  //   $trip = TripLifeCycle::findOrFail($request->trip_life_cycle_id);
  //   $trip->starting_meter_reading = $request->starting_meter_reading;
  //   $trip->save();

  //   // ✅ Update booking status to 'Running' if this is the first trip day
  //   $firstDay = TripLifeCycle::where('booking_id', $trip->booking_id)
  //     ->orderBy('date', 'asc')
  //     ->first();

  //   if ($firstDay && $firstDay->id == $trip->id) {
  //     $booking = BookingHistory::find($trip->booking_id);
  //     if ($booking && $booking->booking_status != 'Running') {
  //       $booking->booking_status = 'Running';
  //       $booking->save();
  //     }
  //   }

  //   $trip->makeHidden(['created_at', 'updated_at']);
  //   return response()->json([
  //     'message' => 'Starting meter reading saved',
  //     'trip' => $trip
  //   ]);
  // }

  // public function updateTripDay(Request $request)
  // {
  //   $request->validate([
  //     'trip_life_cycle_id' => 'required|integer',
  //     'ending_meter_reading' => 'nullable|numeric',
  //     'additional_charge_collected' => 'nullable|numeric',
  //     'note' => 'nullable|string',
  //   ]);

  //   $trip = TripLifeCycle::findOrFail($request->trip_life_cycle_id);
  //   $trip->ending_meter_reading = $request->ending_meter_reading;

  //   if ($trip->starting_meter_reading !== null && $request->ending_meter_reading !== null) {
  //     $trip->km_driven = $trip->ending_meter_reading - $trip->starting_meter_reading;
  //   }

  //   $trip->additional_charge_collected = $request->additional_charge_collected;
  //   $trip->note = $request->note;
  //   $trip->save();

  //   // 🔁 Recalculate remaining_km
  //   $booking = BookingHistory::find($trip->booking_id);
  //   if (!$booking) {
  //     return response()->json(['error' => 'Booking not found.'], 404);
  //   }

  //   $totalKm = $booking->total_km;
  //   $tripLifeCycles = TripLifeCycle::where('booking_id', $trip->booking_id)->orderBy('date')->get();

  //   $cumulativeKm = 0;
  //   foreach ($tripLifeCycles as $day) {
  //     $cumulativeKm += $day->km_driven ?? 0;
  //     $day->remaining_km = $totalKm - $cumulativeKm;
  //     $day->save();
  //   }

  //   // ✅ If this is the last day and ending meter is given, mark booking as Completed
  //   $lastDay = $tripLifeCycles->last();
  //   if ($lastDay && $lastDay->id == $trip->id && $trip->ending_meter_reading !== null) {
  //     if ($booking->booking_status != 'Completed') {
  //       $booking->booking_status = 'Completed';
  //       $booking->save();
  //     }
  //   }

  //   $trip = TripLifeCycle::findOrFail($request->trip_life_cycle_id);
  //   $trip->makeHidden(['created_at', 'updated_at']);

  //   return response()->json([
  //     'message' => 'Trip day updated successfully',
  //     'trip' => $trip
  //   ]);
  // }

  // public function updateTripDay(Request $request)
  // {

  //   $request->validate([
  //     'trip_life_cycle_id' => 'required|integer',
  //     'starting_meter_reading' => 'nullable|numeric',
  //     'ending_meter_reading' => 'nullable|numeric',
  //     'additional_charge_collected' => 'nullable|numeric',
  //     'note' => 'nullable|string',
  //   ]);

  //   $trip = TripLifeCycle::findOrFail($request->trip_life_cycle_id);
  //   if ($trip->starting_meter_reading != null && $trip->ending_meter_reading != null) {
  //     return response()->json([
  //       'message' => 'Your already add data for this day',
  //     ], 422);
  //   }
  //   // ✅ Update starting meter reading (Start trip logic)
  //   if ($request->filled('starting_meter_reading')) {
  //     $trip->starting_meter_reading = $request->starting_meter_reading;

  //     // If this is the first trip day → set booking status to Running
  //     $firstDay = TripLifeCycle::where('booking_id', $trip->booking_id)
  //       ->orderBy('date', 'asc')
  //       ->first();

  //     if ($firstDay && $firstDay->id == $trip->id) {
  //       $booking = BookingHistory::find($trip->booking_id);
  //       if ($booking && $booking->booking_status != 'Running') {
  //         $booking->booking_status = 'Running';
  //         $booking->save();
  //       }
  //     }
  //   }

  //   // ✅ Update ending meter reading (End trip logic)
  //   if ($request->filled('ending_meter_reading')) {
  //     $trip->ending_meter_reading = $request->ending_meter_reading;

  //     // Calculate km driven if both start & end meters exist
  //     if ($trip->starting_meter_reading !== null) {
  //       $trip->km_driven = $trip->ending_meter_reading - $trip->starting_meter_reading;
  //     }

  //     // 🔁 Recalculate remaining_km for all trip days
  //     $booking = BookingHistory::find($trip->booking_id);
  //     if ($booking) {
  //       $totalKm = $booking->total_km;
  //       $tripLifeCycles = TripLifeCycle::where('booking_id', $trip->booking_id)->orderBy('date')->get();

  //       $cumulativeKm = 0;
  //       foreach ($tripLifeCycles as $day) {
  //         $cumulativeKm += $day->km_driven ?? 0;
  //         $day->remaining_km = $totalKm - $cumulativeKm;
  //         $day->save();
  //       }

  //       // ✅ If this is the last day → set booking status to Completed
  //       $lastDay = $tripLifeCycles->last();
  //       if ($lastDay && $lastDay->id == $trip->id) {
  //         if ($booking->booking_status != 'Completed') {
  //           $booking->booking_status = 'Completed';
  //           $booking->save();

  //           $total_km_driven = TripLifeCycle::where('booking_id', $trip->booking_id)->sum('km_driven');
  //           $additional_charge_collected = TripLifeCycle::where('booking_id', $trip->booking_id)->sum('additional_charge_collected');
  //           $amount_collected = TripLifeCycle::where('booking_id', $trip->booking_id)->sum('amount_collected');
  //           $extra_km = $total_km_driven - $booking->total_km;

  //           if ($extra_km > 0) {
  //             $extra_km_rate = $extra_km * $booking->additional_km_rate;
  //             $balance_amount = ($booking->total_fare - $booking->paid_amount - $amount_collected) + $extra_km_rate + $additional_charge_collected;

  //              BookingHistory::where('booking_id', $trip->booking_id)
  //             ->update([
  //               'total_km_driven' => $total_km_driven,
  //               'extra_km_charge' => $extra_km_rate,
  //               'balance_amount' => $balance_amount,
  //             ]);
  //           }

  //         }
  //       }
  //     }
  //   }

  //   // ✅ Additional fields
  //   if ($request->filled('additional_charge_collected')) {
  //     $trip->additional_charge_collected = $request->additional_charge_collected;
  //   }
  //   if ($request->filled('note')) {
  //     $trip->note = $request->note;
  //   }
  //   if ($request->filled('amount_collected')) {
  //     $trip->amount_collected = $request->amount_collected;
  //   }
  //   $trip->save();

  //   $trip->makeHidden(['created_at', 'updated_at']);

  //   return response()->json([
  //     'message' => 'Trip day saved successfully',
  //     // 'trip' => $trip
  //   ]);
  // }

  public function updateTripDay(Request $request)
  {

    $trip = TripLifeCycle::findOrFail($request->trip_life_cycle_id);
    $bookingId = $trip->booking_id;

    $startReadings = $request->input('starting_meter_reading');
    $endReadings = $request->input('ending_meter_reading');
    $additionalCharges = $request->input('additional_charge_collected');
    $amount_collected = $request->input('amount_collected');
    $notes = $request->input('note');

    // 1️⃣ Insert or update all provided days
    if ($startReadings !== null && $startReadings !== '') {

      $start = $startReadings;
      $end = !empty($endReadings) ? $endReadings : null;
      $kmDriven = ($end !== null) ? ($end - $start) : 0;
      $end = !empty($endReadings) ? $endReadings : 0;

      $res =      TripLifeCycle::where('id', $request->trip_life_cycle_id)
        ->update(
          [
            'starting_meter_reading' => $start,
            'ending_meter_reading' => $end,
            'km_driven' => $kmDriven,
            'additional_charge_collected' => $additionalCharges ?? 0,
            'amount_collected' => $amount_collected ?? 0,
            'note' => $notes ?? null,
          ]
        );
    }

    // 2️⃣ Recalculate remaining_km for ALL trip days for this booking
    $booking = BookingHistory::find($bookingId);
    if (!$booking) {
      return redirect()->back()->with('error', 'Booking not found.');
    }

    $totalKm = $booking->total_km;

    $tripLifeCycles = TripLifeCycle::where('booking_id', $bookingId)
      ->orderBy('date')
      ->get();

    $cumulativeKm = 0;

    foreach ($tripLifeCycles as $trip) {
      $cumulativeKm += $trip->km_driven ?? 0;
      $remainingKm = $totalKm - $cumulativeKm;

      $trip->remaining_km = $remainingKm;
      $trip->save();
    }


    // ✅ If last day → auto complete booking
    $lastDay = $tripLifeCycles->last();
    if ($lastDay && $lastDay->id == $request->trip_life_cycle_id && $end !=0) {
      if ($booking->booking_status != 'Completed') {

        // --- Auto completion logic ---
        $total_km_driven = TripLifeCycle::where('booking_id', $trip->booking_id)->sum('km_driven');
        $additional_charge_collected = TripLifeCycle::where('booking_id', $trip->booking_id)->sum('additional_charge_collected');
        $amount_collected = TripLifeCycle::where('booking_id', $trip->booking_id)->sum('amount_collected');

        $extra_km = $total_km_driven - $booking->total_km;
        $vehicle_type = Vehicle::where('id', $booking->vehicle_id)->pluck('vehicle_type')->first();

        $originCoords = $this->getCoordinatesFromAddress($booking->pick_up);

        // Step 2: Find the zone for origin
        $zones = Zone::all();
        $originZone = null;
        foreach ($zones as $zone) {
          $polygon = json_decode($zone->coordinates, true); // ← fix here
          if ($this->isPointInPolygon($originCoords, $polygon)) {
            $originZone = $zone;
            break;
          }
        }

        $fare = Fare::where('vehicle_type_id', $vehicle_type)
          ->whereRaw('json_contains(city_id, \'["' . $originZone->id . '"]\')')
          ->first();
        if ($fare != null)
          $additional_km_rate = $fare->additional_km_rate;
        else
          $additional_km_rate = 0;

        if ($extra_km > 0) {
          $extra_km_rate = ($extra_km * $additional_km_rate);
        } else {
          $extra_km_rate = 0;
        }

        $balance_amount = ($booking->total_fare - $booking->paid_amount - $amount_collected)
          + $extra_km_rate + $additional_charge_collected;

        BookingHistory::where('id', $trip->booking_id)->update([
          'booking_status'    => 'Completed',
          'total_km_driven'   => $total_km_driven,
          'extra_km_charge'   => $extra_km_rate,
          'balance_amount'    => $balance_amount,
        ]);
      }
    }
    return response()->json([
      'message' => 'Trip day saved successfully',
    ]);


    //  echo    $total_km_driven = TripLifeCycle::where('booking_id', 2)->sum('km_driven');die();
    // $request->validate([
    //   'trip_life_cycle_id' => 'required|integer',
    //   'starting_meter_reading' => 'nullable|numeric',
    //   'ending_meter_reading' => 'nullable|numeric',
    //   'additional_charge_collected' => 'nullable|numeric',
    //   'note' => 'nullable|string',
    //   'amount_collected' => 'nullable|numeric',
    // ]);

    // $trip = TripLifeCycle::findOrFail($request->trip_life_cycle_id);

    // // if ($trip->starting_meter_reading != null && $trip->ending_meter_reading != null) {
    // //     return response()->json([
    // //         'message' => 'You already added data for this day',
    // //     ], 422);
    // // }

    // // ✅ Start trip
    // if ($request->filled('starting_meter_reading')) {
    //   $trip->starting_meter_reading = $request->starting_meter_reading;

    //   // If this is the first day → mark booking as Running
    //   $firstDay = TripLifeCycle::where('booking_id', $trip->booking_id)
    //     ->orderBy('date', 'asc')
    //     ->first();

    //   if ($firstDay && $firstDay->id == $trip->id) {
    //     $booking = BookingHistory::find($trip->booking_id);
    //     if ($booking && $booking->booking_status != 'Running') {
    //       $booking->booking_status = 'Running';
    //       $booking->save();
    //     }
    //   }
    // }

    // // ✅ End trip
    // if ($request->filled('ending_meter_reading')) {
    //   $trip->ending_meter_reading = $request->ending_meter_reading;

    //   // calculate km driven
    //   if ($trip->starting_meter_reading !== null) {
    //     $trip->km_driven = $trip->ending_meter_reading - $trip->starting_meter_reading;
    //   }

    //   // 🔁 Recalculate remaining_km
    //   $booking = BookingHistory::find($trip->booking_id);
    //   if ($booking) {
    //     $totalKm = $booking->total_km;
    //     $tripLifeCycles = TripLifeCycle::where('booking_id', $trip->booking_id)
    //       ->orderBy('date')
    //       ->get();

    //     $cumulativeKm = 0;
    //     foreach ($tripLifeCycles as $day) {
    //       $cumulativeKm += $day->km_driven ?? 0;
    //       $day->remaining_km = $totalKm - $cumulativeKm;
    //       $day->save();
    //     }


    //     // ✅ Extra fields
    //     if ($request->filled('additional_charge_collected')) {
    //       $trip->additional_charge_collected = $request->additional_charge_collected;
    //     }
    //     if ($request->filled('note')) {
    //       $trip->note = $request->note;
    //     }
    //     if ($request->filled('amount_collected')) {
    //       $trip->amount_collected = $request->amount_collected;
    //     }

    //     $trip->save();

    //     // ✅ If last day → auto complete booking
    //     $lastDay = $tripLifeCycles->last();
    //     if ($lastDay && $lastDay->id == $trip->id) {
    //       if ($booking->booking_status != 'Completed') {

    //         // --- Auto completion logic ---
    //         $total_km_driven = TripLifeCycle::where('booking_id', $trip->booking_id)->sum('km_driven');
    //         $additional_charge_collected = TripLifeCycle::where('booking_id', $trip->booking_id)->sum('additional_charge_collected');
    //         $amount_collected = TripLifeCycle::where('booking_id', $trip->booking_id)->sum('amount_collected');

    //         $extra_km = $total_km_driven - $booking->total_km;
    //         $vehicle_type = Vehicle::where('id', $booking->vehicle_id)->pluck('vehicle_type')->first();

    //         $originCoords = $this->getCoordinatesFromAddress($booking->pick_up);

    //         // Step 2: Find the zone for origin
    //         $zones = Zone::all();
    //         $originZone = null;
    //         foreach ($zones as $zone) {
    //           $polygon = json_decode($zone->coordinates, true); // ← fix here
    //           if ($this->isPointInPolygon($originCoords, $polygon)) {
    //             $originZone = $zone;
    //             break;
    //           }
    //         }

    //         $fare = Fare::where('vehicle_type_id', $vehicle_type)
    //           ->whereRaw('json_contains(city_id, \'["' . $originZone->id . '"]\')')
    //           ->first();
    //         if ($fare != null)
    //           $additional_km_rate = $fare->additional_km_rate;
    //         else
    //           $additional_km_rate = 0;

    //         if ($extra_km > 0) {
    //           $extra_km_rate = ($extra_km * $additional_km_rate);
    //         } else {
    //           $extra_km_rate = 0;
    //         }

    //         $balance_amount = ($booking->total_fare - $booking->paid_amount - $amount_collected)
    //           + $extra_km_rate + $additional_charge_collected;

    //         BookingHistory::where('id', $trip->booking_id)->update([
    //             'booking_status'    => 'Completed',
    //           'total_km_driven'   => $total_km_driven,
    //           'extra_km_charge'   => $extra_km_rate,
    //           'balance_amount'    => $balance_amount,
    //         ]);
    //       }
    //     }
    //   }
    // }

    // $trip->makeHidden(['created_at', 'updated_at']);

    // return response()->json([
    //   'message' => 'Trip day saved successfully',
    // ]);
  }



  public function changeAvailabiltyStatus(Request $request)
  {
    try {

      $res = Driver::where('id', auth()->user()->id)
        ->update([
          'is_availabile_status' => $request->is_availabile_status,
        ]);



      if ($res == 1) {
        return response()->json([
          'status' => true,
          'message' => 'Status updated successfully',
        ]);
      }
    } catch (QueryException $e) {
      return response()->json(['error' => 'Database error ' . $e], 500);
    } catch (Throwable $e) {
      return response()->json(['error' => 'Something went wrong ' . $e], 500);
    }
  }

  public function getLatestTrip(Request $request)
  {
    try {

      $booking = BookingHistory::select('id', 'booking_id', 'departure_date', 'return_date', 'departure_time', 'return_time', 'pick_up', 'drop_off', 'stay_locations', 'booking_status', 'total_fare', 'paid_amount')
        ->where('driver_id', auth()->user()->id)
        ->orderBy('departure_date', 'ASC')
        ->where('departure_date', '>=', date('Y-m-d', strtotime(now())))
        ->whereNotIn('booking_status', ['Completed', 'Canceled'])
        ->first();
      if ($booking != null) {
        $raw = $booking->stay_locations; // The double-encoded JSON string

        $firstDecode = json_decode($raw, true);              // returns a JSON string
        $locationsArray = json_decode($firstDecode, true);   // returns the actual PHP array

        $locationString = is_array($locationsArray) ? implode(', ', $locationsArray) : '';

        $booking->stay_locations = $locationString;
        //  $booking->stay_locations_count = is_array($locationsArray) ? count($locationsArray) : 0;

        $departure = Carbon::parse($booking->departure_date);
        $return = Carbon::parse($booking->return_date);

        // Total days (inclusive)
        $totalDays = $departure->diffInDays($return) + 1; // +1 to include both start and end dates
        $nightCount = $totalDays - 1;

        // Final title
        $tripTitle = "{$nightCount}NIGHTS {$totalDays}DAYS";
        $booking->title = $tripTitle;
      }
      return response()->json([
        'status' => true,
        'data' => $booking,
      ]);
    } catch (QueryException $e) {
      return response()->json(['error' => 'Database error ' . $e], 500);
    } catch (Throwable $e) {
      return response()->json(['error' => 'Something went wrong ' . $e], 500);
    }
  }


  public function notifications(Request $request)
  {
    try {
      $data = Notifications::select('id', 'notification', 'notification_title', 'created_at')
        ->where('driver_id', auth()->user()->id)
        ->get();

      return response()->json([
        'status' => true,
        'data' => $data,
      ]);
    } catch (QueryException $e) {
      return response()->json(['error' => 'Database error ' . $e], 500);
    } catch (Throwable $e) {
      return response()->json(['error' => 'Something went wrong ' . $e], 500);
    }
  }

  public function getCoordinatesFromAddress($address)
  {
    try {
      $apiKey = Settings::pluck('google_map_api_key')->first();
      $response = Http::get("https://maps.googleapis.com/maps/api/geocode/json", [
        'address' => $address,
        'key' => $apiKey,
      ]);

      $data = $response->json();
      if ($data['status'] === 'OK') {
        $location = $data['results'][0]['geometry']['location'];
        return ['lat' => $location['lat'], 'lng' => $location['lng']];
      }

      throw new \Exception("Invalid address or failed to fetch coordinates.");
    } catch (QueryException $e) {
      return response()->json(['error' => 'Database error ' . $e], 500);
    } catch (Throwable $e) {
      return response()->json(['error' => 'Something went wrong ' . $e], 500);
    }
  }


  public function isPointInPolygon($point, $polygon)
  {
    try {
      $lat = $point['lat'];
      $lng = $point['lng'];
      $inside = false;
      $j = count($polygon) - 1;

      for ($i = 0; $i < count($polygon); $i++) {
        $xi = $polygon[$i]['lat'];
        $yi = $polygon[$i]['lng'];
        $xj = $polygon[$j]['lat'];
        $yj = $polygon[$j]['lng'];

        $intersect = (($yi > $lng) != ($yj > $lng))
          && ($lat < ($xj - $xi) * ($lng - $yi) / ($yj - $yi) + $xi);
        if ($intersect) $inside = !$inside;
        $j = $i;
      }

      return $inside;
    } catch (QueryException $e) {
      return response()->json(['error' => 'Database error ' . $e], 500);
    } catch (Throwable $e) {
      return response()->json(['error' => 'Something went wrong ' . $e], 500);
    }
  }

  
     public function accountDeleteRequest(Request $request)
    {
        try {
            //  echo auth()->user()->id;

            $res = AccountDeleteRequest::insert([
                    'user_id' => auth()->user()->id,
                    'role' => 'Driver',
                    'reason' => $request->reason,
                    'other_reason' => $request->other_reason,
                ]);
           
          
            if ($res == 1) {
                return response()->json([
                    'status' => true,
                    'message' => 'Your Request has been submitted successfully',
                ]);
            }
        } catch (QueryException $e) {
            return response()->json(['error' => 'Database error ' . $e], 500);
        } catch (Throwable $e) {
            return response()->json(['error' => 'Something went wrong ' . $e], 500);
        }
    }
}
