<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Zone;
use App\Models\Vendors;
use App\Models\Driver;
use App\Models\Vehicle;
use App\Models\VehicleCategory;
use App\Models\BrandVehicle;
use App\Models\Review;
use App\Models\BookingHistory;
use App\Models\Partner;
use Illuminate\Database\QueryException;
use Throwable;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use App\Models\TripLifeCycle;
use Illuminate\Support\Facades\Cache;

class WebVendorController extends Controller
{


    public function sendOtp(Request $request)
    {
        $request->validate(['phone' => 'required']);
        $phone = $request->input('phone');
        $phone = preg_replace('/\s+/', '', $phone);
        //die();
        $otp = rand(10000, 99999);
        //  $otp = '12345';
        // Store OTP temporarily (e.g. 5 minutes)
        Cache::put('otp_' . $phone, $otp, now()->addMinutes(10));
        //    Cache::put('otp_' . $request->phone, $otp, 600);
        //   return redirect()->route('vendor.verify-phone', ['phone' => $phone])->with('success', 'Otp send to ' . $phone);
        // Send OTP using SMS provider (Twilio, etc.)
        // e.g. SmsService::send($request->phone, "Your OTP is $otp");

       $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.connectpanels.com/whatsapp-api/v1.0/customer/120180/bot/0d094a19d57e4eaa/template',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => '{"payload":{"name":"otp","components":[{"type":"body","parameters":[{"type":"text","text":"' . $otp . '"}]},{"type":"button","sub_type":"url","index":0,"parameters":[{"type":"text","text":"' . $otp . '"}]}],"language":{"code":"en_US","policy":"deterministic"},"namespace":"66cbcb46_a232_4519_a6e7_b69fd50991bf"},"phoneNumber":"' . $phone . '"}',
            CURLOPT_HTTPHEADER => array(
                'Authorization: Basic c4d8e3eb-4e7c-4f9d-a05c-5ff0bf583d29-Ic1uEZu',
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);
        //print_r($response);die();
        // Convert to array
        $responseData = json_decode($response, true);

        // Use the data
        // $messageId = $responseData['responseObject']['message_id'];
        // $statusCode = $responseData['status']['code'];
        $statusDesc = $responseData['status']['desc'];
        curl_close($curl);
        if ($statusDesc == 'SUCCESS') {
            return redirect()->route('vendor.verify-phone', ['phone' => $phone])->with('success', 'Otp send to ' . $phone);
            //  return view('web.vendors.otp',['phone'=>$request->phone]);
        }
    }


    public function verifyPhone(Request $request)
    {
        return view('web.vendors.otp', ['phone' => $request->phone]);
    }
    public function verifyOtp(Request $request)
    {
        $request->validate([
            'phone' => 'required',
            'otp' => 'required|digits:5',
        ]);
        $phone = $request->input('phone');
        $phone = preg_replace('/\s+/', '', $phone);
        $storedOtp = Cache::get('otp_' . $phone);

        if ($storedOtp && $storedOtp == $request->otp) {
            // OTP is valid
            // Authenticate or register user logic here

            $user = Vendors::where('phone', $phone)->first();

            $user_account = 'exist-user';

            if ($user == null) {
                // Register new user
                $user = Vendors::create([
                    'phone' => $phone,
                ]);
                $user_account = 'new-user';
                $user = Vendors::where('phone', $phone)->first();
            }

            if ($user->status == 'REQUESTED') {
                if (!empty($user->name) && !empty($user->zone)) {
                    // echo "hi";die();
                    return redirect()->route('vendor.not-active');
                } else {
                    Cache::forget('otp_' . $phone);
                    Auth::guard('vendor-web')->login($user);
                    return redirect()->route('vendor.add-profile', ['phone' => $phone])->with('success', 'OTP verified Successfully ');
                }
            }
            Cache::forget('otp_' . $phone);
            Auth::guard('vendor-web')->login($user);
            if ($user_account == 'new-user') {
                return redirect()->route('vendor.add-profile', ['phone' => $phone])->with('success', 'OTP verified Successfully ');
            }
            return redirect()->route('vendor.profile')->with('success', 'OTP verified Successfully. Your are logged in successfully. ');
        }
        return redirect()->back()->with('error', 'Invalid OTP');
    }


    public function addProfile(Request $request)
    {
        $data = Vendors::where('phone', $request->phone)->first();
        return view('web.vendors.add-profile', ['data' => $data]);
    }

    public function updatenewendor(Request $request)
    {

        $exist = $res = Vendors::where('email', $request->email)->first();
        if ($exist != null) {
            return redirect()->back()->with('error', $request->email . 'This email ID already exist');
        }
        $res = Vendors::where('id', $request->id)
            ->update([

                'name' => $request->name,
                'email' => $request->email,
                'address' => $request->address,
                'district' => $request->district,
                'state' => $request->state,
                'country' => $request->country,
                'postal_code' => $request->postal_code,
                'zone' => $request->zone_id,
            ]);
        if ($request->photo) {
            $rand = rand(100, 999);
            $image = time() . '.' . $request->photo->extension();
            $imageOriginalName = $request->photo->getClientOriginalName();
            $request->photo->move(public_path('uploads/vendor/'), $image);
            Vendors::where('id', $request->id)->update(['vendor_image' => $image]);
        }
        if ($res == 1)
            return redirect()->route('vendor.success');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function signout(Request $request)
    {

        Auth::guard('vendor-web')->logout();
        // $request->session()->invalidate();
        $request->session()->forget('key'); // optional
        $request->session()->regenerateToken();

        return redirect()->route('index');
    }
    public function profile(Request $request)
    {
        return view('web.vendors.profile', ['data' => Auth::guard('vendor-web')->user()]);
    }

    public function updateProfile(Request $request)
    {
        try {
            $updateData = [
                'name' => $request->name,
                'email' => $request->email,
                'address' => $request->address,
                'district' => $request->district,
                'state' => $request->state,
                'country' => $request->country,
                'postal_code' => $request->postal_code,
                'zone' => $request->zone_id,
            ];

            if ($request->photo) {
                $image = time() . '.' . $request->photo->extension();
                $request->photo->move(public_path('uploads/vendor/'), $image);
                $updateData['vendor_image'] = $image;
            }

            $res = Vendors::where('id', $request->id)->update($updateData);

            if ($res == 1 || $request->photo) {
                return redirect()->back()->with('success', 'Vendor updated successfully');
            } else {
                return redirect()->back()->with('error', 'Nothing was changed');
            }
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', 'Error: ' . $e->getMessage());
        }
    }


    public function getBookings(Request $request)
    {
        if ($request->ajax()) {
            $data = BookingHistory::where('vendor_id', Auth::guard('vendor-web')->user()->id)->orderBy('id', 'DESC');
            if ($request->filled('start_date') && $request->filled('end_date')) {
                $data = $data->whereBetween('created_at', [date('Y-m-d 00:00:00', strtotime($request->start_date)), date('Y-m-d 23:59:59', strtotime($request->end_date))]);
            } elseif ($request->filled('start_date')) {
                $data = $data->where('created_at', '>=', date('Y-m-d 00:00:00', strtotime($request->start_date)));
            } elseif ($request->filled('end_date')) {
                $data = $data->where('created_at', '<=', date('Y-m-d 23:59:59', strtotime($request->end_date)));
            }
            if ($request->filled('status')) {
                $data = $data->where('booking_status', $request->status);
            }
            if ($request->filled('vendor_id')) {
                $data = $data->where('vendor_id', $request->vendor_id);
            }
            if ($request->filled('driver_id')) {
                $data = $data->where('driver_id', $request->driver_id);
            }
            if ($request->filled('vehicle_id')) {
                $data = $data->where('vehicle_id', $request->vehicle_id);
            }
            if ($request->filled('booked_user_id')) {
                $data = $data->where('booked_user_id', $request->booked_user_id);
            }
            $data = $data->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('booking_id', function ($data) {
                    if ($data->booking_status == 'Upcoming') {
                        $class = "success";
                        return         $html = '<a href="' . route('vendor.get-booking-details', ['id' => $data->booking_id]) . '" class="position-relative bg-light-' . $class . ' px-2 py-1 b-r-10">
                                    ' . $data->booking_id . '
                                    <span class="position-absolute top-0 start-100 translate-middle p-1 bg-' . $class . ' rounded-circle animate__animated animate__fadeIn animate__infinite animate__fast"></span>
                                </a>';
                    }
                    return  '<a href="' . route('vendor.get-booking-details', ['id' => $data->booking_id]) . '" style="color:blue;">' . $data->booking_id . '</a>';
                })
                ->addColumn('location', function ($data) {
                    return  '<p class="text-info f-s-16 mb-0">' . $data->pick_up . '</p> <i class="ph-bold  ph-arrow-down"></i> <p class="text-danger f-s-16 mb-0">' . $data->drop_off . '</p>';
                })
                ->addColumn('date', function ($data) {
                    return  '<p class="text-info f-s-16 mb-0">' . $data->departure_date . ' ' . $data->departure_time . '</p><br> <i class="ph-bold  ph-arrow-down"></i> <br><p class="text-danger f-s-16 mb-0">' . $data->return_date . ' ' . $data->return_time . '</p>';
                })
                ->addColumn('driver', function ($data) {
                    if ($data->driver_id != NULL) {
                        return '<a href="' . route('vendor.view-driver', ['id' => $data->driver_id]) . '" class="text-primary">' . Driver::where('id', $data->driver_id)->pluck('name')->first() . '</a>';
                    } else {
                        return '<span class="badge text-light-dark">Not Assigned</span>';
                    }
                })
                ->addColumn('vehicle', function ($data) {
                    $vehicle = Vehicle::where('id', $data->vehicle_id)->pluck('model')->first();
                    return   BrandVehicle::where('id', $vehicle)->pluck('model_name')->first();
                })
                ->addColumn('payment_status', function ($data) {
                    if ($data->payment_status == 'Unpaid')
                        return '<span class="badge text-light-danger"> ' . $data->payment_status . '</span>';
                    elseif ($data->payment_status == 'Paid')
                        return  '<span class="badge text-light-success">' . $data->payment_status . '</span>';
                })
                ->addColumn('booked_by', function ($data) {
                    if ($data->role == 'Partner') {
                        $class = "success";
                    } else {
                        $class = "danger";
                    }
                    return   Partner::where('id', $data->booked_user_id)->pluck('name')->first() . '<br><p class="text-' . $class . '">(' . $data->role . ')</p>';
                })
                ->addColumn('booking_status', function ($data) {
                    if ($data->booking_status == 'Upcoming') {
                        $class = "warning";
                    } elseif ($data->booking_status == 'Confirmed') {
                        $class = "info";
                    } elseif ($data->booking_status == 'Running') {
                        $class = "primary";
                    } elseif ($data->booking_status == 'Completed') {
                        $class = "success";
                    } elseif ($data->booking_status == 'Canceled') {
                        $class = "danger";
                    }

                    if ($data->booking_status == 'Upcoming') {
                        $html = '<a href="#" class="position-relative text-bg-' . $class . ' px-2 py-1 b-r-10">
                                    ' . $data->booking_status . '
                                    <span class="position-absolute top-0 start-100 translate-middle p-1 bg-' . $class . ' rounded-circle animate__animated animate__fadeIn animate__infinite animate__fast"></span>
                                </a>';
                    } else {

                        $html = '<a href="#" class="position-relative text-bg-' . $class . ' px-2 py-1 b-r-10">
                                    ' . $data->booking_status . '</a>';
                    }
                    return $html;
                })
                ->addColumn('total_km', function ($data) {
                    return  $data->total_km;
                })
                ->addColumn('total_fare', function ($data) {
                    return  $data->total_fare;
                })


                ->escapeColumns([])

                ->make(true);
        }
    }

    public function getBookingDetails(Request $request)
    {
        $booking = BookingHistory::select(
            'booking_histories.*',
            'reviews.driver_rating',
            'reviews.car_rating',
            'reviews.comment'
        )
            ->leftJoin('reviews', 'booking_histories.id', '=', 'reviews.booking_id')
            ->where('booking_histories.booking_id', $request->id)
            ->first();
        $booking->makeHidden(['created_at', 'updated_at']);
        // ********** stay location  *********
        $raw = $booking->stay_locations; // The double-encoded JSON string
        $firstDecode = json_decode($raw, true);              // returns a JSON string
        $locationsArray = json_decode($firstDecode, true);   // returns the actual PHP array
        $booking->stay_locations = $locationsArray;
        // ********** stay date end  *********

        // ********** find titile  *********
        $departure = Carbon::parse($booking->departure_date);
        $return = Carbon::parse($booking->return_date);

        // Total days (inclusive)
        $totalDays = $departure->diffInDays($return) + 1; // +1 to include both start and end dates
        $nightCount = $totalDays - 1;

        // Final title
        $tripTitle = "{$nightCount}NIGHTS {$totalDays}DAYS";
        $booking->title = $tripTitle;
        // ********** find titile end  *********

        // ********** stay date  *********
        $raw = $booking->stay_date; // The double-encoded JSON string

        $firstDecode = json_decode($raw, true);              // returns a JSON string
        $locationsArray = json_decode($firstDecode, true);   // returns the actual PHP array

        $booking->stay_date = $locationsArray;
        // ********** stay date end *********
        $vehicle = Vehicle::join('drivers', 'vehicles.driver_id', '=', 'drivers.id')
            ->join('vendors', 'vehicles.vendor_id', '=', 'vendors.id')
            ->leftJoin('reviews', 'vehicles.id', '=', 'reviews.vehicle_id')
            ->leftJoin('booking_histories', 'vehicles.id', '=', 'booking_histories.vehicle_id')
            ->select(
                'vehicles.id',
                'vehicles.seats',
                'vehicles.fuel_type',
                'vehicles.model',
                'vehicles.vehicle_make',
                'vehicles.image',
                'vendors.name as vendor_name',
                'vendors.vendor_image',
                DB::raw('AVG(reviews.overall_rating) as avg_rating'),
                DB::raw('COUNT(booking_histories.id) as total_trips')
            )
            ->where('vehicles.id', $booking->vehicle_id)
            ->groupBy(
                'vehicles.id',
                'vehicles.seats',
                'vehicles.fuel_type',
                'vehicles.model',
                'vehicles.vehicle_make',
                'vehicles.image',
                'vendors.name',
                'vendors.vendor_image'
            )
            ->first();
        // $vehicle =  Vehicle::join('vendors', 'vehicles.vendor_id', '=', 'vendors.id')
        //                ->join('drivers', 'drivers.vendor_id', '=', 'vendors.id')
        //                 ->select('vehicles.id','vehicles.seats','vehicles.fuel_type','vehicles.model','vehicles.vehicle_make','vehicles.image', 'vendors.name as vendor_name','vendors.vendor_image') // select vendor fields as needed
        //                 ->where('vehicles.id',$booking->vehicle_id)
        //                 ->first();

        $vehicle->model = BrandVehicle::where('id', $vehicle->model)->pluck('model_name')->first();
        foreach (json_decode($vehicle->image) as $i => $img) {
            if ($i == 3) {
                break; // Stop looping once 3 images collected
            }
            $gallery_images[$i] = asset('uploads/vehicle/' . $img); // or Storage::url($img) if using storage
        }

        if ($vehicle->vendor_image == NULL) {
            $vehicle->vendor_image = asset('assets/images/user.jpg');
        } else {
            $vehicle->vendor_image = asset('uploads/vendor/' . $vehicle->vendor_image);
        }
        $vehicle->image = $gallery_images;
        $vehicle->review_rate = 5;

        $booking->cab_agency_details = $vehicle;
        $driver = Driver::select('name', 'image')->where('id', $booking->driver_id)->first();
        if ($driver != null) {
            if ($driver->image == NULL) {
                $driver->image = asset('assets/images/user.jpg');
            } else {
                $driver->image = asset('uploads/driver/' . $driver->image);
            }
        }

        // trip life cycle
        $res = BookingHistory::where('booking_id', $request->id)->first();

        // Calculate remaining km
        $lastTrip = TripLifeCycle::where('booking_id', $res->id)->orderBy('id', 'DESC')->first();
        $remainingKM = $lastTrip ? $lastTrip->remaining_km : $res->total_km;
        $res->remainingKM = $remainingKM;

        // Fetch all existing trip life cycles for this booking, keyed by date
        $existingLifeCycles = TripLifeCycle::where('booking_id', $res->id)
            ->get()
            ->keyBy(function ($item) {
                return Carbon::parse($item->date)->format('Y-m-d');
            });

        // Pass BOTH variables to the view

 $departureDate = date("Y-m-d", strtotime($booking->departure_date));
      $returnDate = date("Y-m-d", strtotime($booking->return_date));
      $origin = $booking->pick_up;
      // Step 1: Get coordinates of origin
      $originCoords = $this->getCoordinatesFromAddress($origin);

      // Step 2: Find the zone for origin
      $zones = Zone::all();
      $originZone = null;
      foreach ($zones as $zone) {
        $polygon = json_decode($zone->coordinates, true); // ← fix here
        if ($this->isPointInPolygon($originCoords, $polygon)) {
          $originZone = $zone;
          break;
        }
      }
      // echo $originZone->id;
      $availableDrivers = DB::table('drivers as d')
        ->where('d.vendor_id', $booking->vendor_id)
        ->where('d.status', 'ACTIVE')
        //  ->where('d.is_availabile_status', 'False')
        ->where('d.is_availabile_status', 'True')
        ->where('d.zone', $originZone->id)
        ->whereNotExists(function ($query) use ($departureDate, $returnDate) {
          $query->select(DB::raw(1))
            ->from('booking_histories as bh')
            ->whereRaw('bh.driver_id = d.id')
            ->where(function ($q) use ($departureDate, $returnDate) {
              $q->where('bh.departure_date', '<=', $returnDate)
                ->where('bh.return_date', '>=', $departureDate);
            });
        })
       // ->select('d.id', 'd.name', 'd.phone', 'd.image')
           ->select('d.id', 'd.name')
        ->get();

    
        return view('web.vendors.booking-details', [
            'data' => $booking,
            'driver' => $driver,
            'lifecycle' => $res,
            'existingLifeCycles' => $existingLifeCycles,
             'availableDrivers'=>$availableDrivers
        ]);
    }


    //*********************************** driver  section start *****************************/

    public function adddriver(Request $request)
    {
        $image = '';
        $licence_image = '';
        if ($request->photo) {
            $rand = rand(100, 999);
            $image = time() . '.' . $request->photo->extension();
            $imageOriginalName = $request->photo->getClientOriginalName();
            $request->photo->move(public_path('uploads/driver/'), $image);
        }
        if ($request->licence) {
            $rand = rand(100, 999);
            $licence_image = time() . '.' . $request->licence->extension();
            $imageOriginalName = $request->licence->getClientOriginalName();
            $request->licence->move(public_path('uploads/driver/licence'), $licence_image);
        }
        //    print_r($request->all());
        // if($request->vendor_id=="NULL"){

        //             $vendor = new Vendors();
        //             $vendor->name=$request->name;
        //             $vendor->email=$request->email ;
        //             $vendor->phone=$request->phone ;
        //             $vendor->address=$request->address ;
        //             $vendor->district=$request->district ;
        //             $vendor->state=$request->state ;
        //             $vendor->country=$request->country ;
        //             $vendor->postal_code=$request->postal_code;
        //             $vendor->save();
        //             $vendorid= $vendor->id;
        // }else{
        $vendorid = $request->vendor_id;
        //    }

        $res = Driver::insert([
            'vendor_id' => $vendorid,
            'name' => $request->name,
            'phone' => $request->phone,
            'address' => $request->address,
            'aadhar_no' => $request->aadhar_no,
            'image' => $image,
            'licence_number' => $request->licence_number,
            'licence_validity' => $request->licence_validity,
            'licence' => $licence_image,
            'zone' => $request->zone_id
        ]);


        if ($res == 1)
            return redirect()->back()->with('success', 'Driver added successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function getdriver(Request $request)
    {
        if ($request->ajax()) {
            $data = Driver::where('vendor_id', Auth::guard('vendor-web')->user()->id)->orderBy('id', 'DESC');
            if ($request->filled('vendor_id')) {
                $data = $data->where('vendor_id', $request->vendor_id);
            }
            $data = $data->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('name', function ($data) {
                    if ($data->image == NULL) {
                        $img = asset("assets/images/no-image.png");
                    } else {
                        $img = asset("uploads/driver/" . $data->image);
                    }
                    return  '<a href="' . route('vendor.view-driver', ['id' => $data->id]) . '" class="text-primary">
                   <div class="d-flex align-items-center">
                                            <div class="h-35 w-35 d-flex-center b-r-10 overflow-hidden me-2">
                                                <img src=' . $img . ' alt="" class="img-fluid">
                                            </div>
                                            <div class="d-flex">
                                                <span class="fw-medium">' . $data->name . '</span>
                                            </div>
                                        </div>
                                        </a>';
                })

                ->addColumn('phone', function ($data) {
                    return   $data->phone;
                })
                ->addColumn('address', function ($data) {
                    return   $data->address;
                })
                ->addColumn('License Validity', function ($data) {
                    return    $data->licence_validity;
                })
                ->addColumn('status', function ($data) {
                    if ($data->status == 'BLOCKED')
                        return '<span class="badge text-light-danger"> ' . $data->status . '</span>';
                    else
                        return  '<span class="badge text-light-success">' . $data->status . '</span>';
                })

                ->addColumn('action', function ($data) {
                    return   '  <a href="' . route('vendor.view-driver', ['id' => $data->id]) . '" class="btn btn-light-primary icon-btn b-r-4" ><i class="ti ti-eye text-primary"></i></a>
                             <a href="' . route('vendor.edit-driver', ['id' => $data->id]) . '" class="btn btn-light-success icon-btn b-r-4" ><i class="ti ti-edit text-success"></i></a>
                                                                <a href="#" class="btn btn-light-danger icon-btn b-r-4 delete-btn" data-bs-toggle="modal" data-bs-target="#delete_discount' . $data->id . '"><i class="ti ti-trash"></i></a>
                        <div class="modal custom-modal fade" id="delete_discount' . $data->id . '" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content">
                <div class="modal-header border-0 justify-content-center pb-0">
                    <div class="form-header modal-header-title text-center mb-0">
                        <h4 class="mb-2">Delete zone</h4>
                        <p>Are you sure want to delete?</p>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="modal-btn delete-action">
                        <div class="row text-center">
                            <div class="col-12">
                                <a href="' . route('vendor.delete-driver', ['id' => $data->id]) . '" 
                                    class="btn btn-primary paid-continue-btn">Delete</a>
                                      <a href="#" data-bs-dismiss="modal"
                                    class="btn btn-primary paid-cancel-btn">Cancel</a>
                            </div>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>                                            
    ';
                })

                ->escapeColumns([])

                ->make(true);
        }
    }
    public function editdriver(Request $request)
    {
        $res = Driver::where('id', $request->id)->first();
        return view('web.vendors..driver.edit', ['data' => $res]);
    }
    public function updatedriver(Request $request)
    {
        $res = Driver::where('id', $request->id)
            ->update([

                'vendor_id' => $request->vendor_id,
                'name' => $request->name,
                'phone' => $request->phone,
                'address' => $request->address,
                'aadhar_no' => $request->aadhar_no,
                'licence_number' => $request->licence_number,
                'licence_validity' => $request->licence_validity,
                'zone' => $request->zone_id,
                'status' => $request->status
            ]);
        if ($request->photo) {
            $data = Driver::where('id', $request->id)->first();

            if ((file_exists(public_path('uploads/driver/' . $data->image))) && ($data->image != NULL)) {
                unlink("uploads/driver/" . $data->image);
            }
            $rand = rand(100, 999);
            $image = time() . '.' . $request->photo->extension();
            $imageOriginalName = $request->photo->getClientOriginalName();
            $request->photo->move(public_path('uploads/driver/'), $image);


            $res = Driver::where('id', $request->id)
                ->update(['image' => $image]);
        }

        if ($request->licence) {

            $data = Driver::where('id', $request->id)->first();
            if ((file_exists(public_path('uploads/driver/licence/', $data->licence))) && ($data->licence != NULL)) {
                unlink("uploads/driver/licence/" . $data->licence);
            }
            $rand = rand(100, 999);
            $licence_image = time() . '.' . $request->licence->extension();
            $imageOriginalName = $request->licence->getClientOriginalName();
            $request->licence->move(public_path('uploads/driver/licence/'), $licence_image);
            $res =  Driver::where('id', $request->id)
                ->update([
                    'licence' => $licence_image,
                ]);
        }
        if ($res == 1)
            return redirect()->back()->with('success', 'driver  updated successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function deletedriver(Request $request)
    {
        $data = Driver::where('id', $request->id)->first();
        if ((file_exists(public_path('uploads/driver/' . $data->image))) && ($data->image != NULL)) {
            unlink("uploads/driver/" . $data->image);
        }

        $res = Driver::where('id', $request->id)->delete();
        if ($res == 1)
            return redirect()->back()->with('success', 'Driver  deleted successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }
    //*********************************** driver  section end *****************************/


    //*********************************** vehicle  section start *****************************/

    public function savevehicle(Request $request)
    {
        // print_r($request->all());
        // die();
        if (Vehicle::where('plate_number', $request->plate_number)->first() != NULL) {
            return redirect()->back()->with('error', 'Vehicle Plate number already Exist');
        }
        $image = '';
        $licence_image = '';
        //  if($request->photo){
        //             $rand = rand(100, 999);
        //             $image = time() . '.' . $request->photo->extension();
        //             $imageOriginalName = $request->photo->getClientOriginalName();
        //             $request->photo->move(public_path('uploads/vehicle/'), $image);

        //         }

        $imagePaths = [];

        if ($request->hasFile('images')) {
            foreach ($request->file('images') as $file) {
                $filename = Str::random(20) . '.' . $file->getClientOriginalExtension();
                $destinationPath = public_path('uploads/vehicle');

                // Create the folder if it doesn't exist
                if (!file_exists($destinationPath)) {
                    mkdir($destinationPath, 0755, true);
                }

                $file->move($destinationPath, $filename);
                $imagePaths[] =  $filename; // Relative public path
            }
        }

        $res = Vehicle::insert([
            'vendor_id' => Driver::where('id', $request->driver_id)->pluck('vendor_id')->first(),
            'driver_id' => $request->driver_id,
            'model' => $request->brand,
            'vehicle_make' => $request->vehicle_make,
            'year_of_registration' => $request->year_of_registration,
            'seats' => $request->seats,
            'color' => $request->color,
            'fuel_type' => $request->fuel_type,
            'plate_number' => $request->plate_number,
            'reg_validity' => $request->reg_validity,
            'insurance_validity' => $request->insurance_validity,
            'tax_validity' => $request->tax_validity,
            'image' => json_encode($imagePaths),
            'vehicle_type' => BrandVehicle::where('id', $request->brand)->pluck('vehicle_type')->first(),

        ]);
        if ($res == 1)
            return redirect()->back()->with('success', 'Vehicle added successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function getvehicle(Request $request)
    {
        if ($request->ajax()) {
            $data = Vehicle::where('vendor_id', Auth::guard('vendor-web')->user()->id)->orderBy('id', 'DESC');
            if ($request->filled('vendor_id')) {
                $data = $data->where('vendor_id', $request->vendor_id);
            }
            $data = $data->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('name', function ($data) {
                    $bv = BrandVehicle::where('id', $data->model)->first();


                    if ($data->image == NULL) {
                        $img = asset("assets/images/no-image");
                    } else {
                        foreach (json_decode($data->image) as $i => $img) {
                            if ($i == 1) {
                                $img = asset("uploads/vehicle/" . $img);
                                break; // Stop looping once 3 images collected
                            }
                        }
                    }
                    return  ' <div class="d-flex align-items-center">
                                            <div class="h-35 w-35 d-flex-center b-r-10 overflow-hidden me-2">
                                               <a href="' . route('vendor.view-vehicle', ['id' => $data->id]) . '"> <img src=' . $img . ' alt="" class="img-fluid"></a>
                                            </div>
                                            <div class="d-flex">
                                              <a href="' . route('vendor.view-vehicle', ['id' => $data->id]) . '">   <span class="fw-medium">' . $bv->model_name . '</span></a>
                                            </div>
                                        </div>';
                })
                ->addColumn('type', function ($data) {
                    return  VehicleCategory::where('id', $data->vehicle_type)->pluck('name')->first();
                })

                ->addColumn('driver', function ($data) {
                    return  Driver::where('id', $data->driver_id)->pluck('name')->first();
                })
                ->addColumn('seats', function ($data) {
                    return   $data->seats;
                })
                ->addColumn('astatus', function ($data) {
                    if ($data->is_available == 'Booked')
                        return '<span class="btn btn-danger"> ' . $data->is_available . '</span>';
                    elseif ($data->is_available == 'Available')
                        return  '<span class="btn btn-success">' . $data->is_available . '</span>';
                    elseif ($data->is_available == 'Maintenance')
                        return  '<span class="btn btn-warning">' . $data->is_available . '</span>';
                })
                ->addColumn('plate_number', function ($data) {
                    return    $data->plate_number;
                })
                ->addColumn('status', function ($data) {
                    if ($data->status == 'BLOCKED')
                        return '<span class="badge text-light-danger"> ' . $data->status . '</span>';
                    else
                        return  '<span class="badge text-light-success">' . $data->status . '</span>';
                })

                ->addColumn('action', function ($data) {
                    return   '  <a href="' . route('vendor.view-vehicle', ['id' => $data->id]) . '" class="btn btn-light-primary icon-btn b-r-4" ><i class="ti ti-eye text-primary"></i></a>
                              <a href="' . route('vendor.edit-vehicle', ['id' => $data->id]) . '" class="btn btn-light-success icon-btn b-r-4" ><i class="ti ti-edit text-success"></i></a>
                                                                <a href="#" class="btn btn-light-danger icon-btn b-r-4 delete-btn" data-bs-toggle="modal" data-bs-target="#delete_discount' . $data->id . '"><i class="ti ti-trash"></i></a>
                        <div class="modal custom-modal fade" id="delete_discount' . $data->id . '" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content">
                <div class="modal-header border-0 justify-content-center pb-0">
                    <div class="form-header modal-header-title text-center mb-0">
                        <h4 class="mb-2">Delete zone</h4>
                        <p>Are you sure want to delete?</p>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="modal-btn delete-action">
                        <div class="row text-center">
                            <div class="col-12">
                                <a href="' . route('vendor.delete-vehicle', ['id' => $data->id]) . '" 
                                    class="btn btn-primary paid-continue-btn">Delete</a>
                                      <a href="#" data-bs-dismiss="modal"
                                    class="btn btn-primary paid-cancel-btn">Cancel</a>
                            </div>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>                                            
    ';
                })

                ->escapeColumns([])

                ->make(true);
        }
    }
    public function editvehicle(Request $request)
    {
        $res = Vehicle::where('id', $request->id)->first();
        return view('web.vendors.vehicle.edit', ['data' => $res]);
    }
    public function updatevehicle(Request $request)
    {
        $image = '';
        $licence_image = '';


        $res = Vehicle::where('id', $request->id)
            ->update([
                'vendor_id' => Driver::where('id', $request->driver_id)->pluck('vendor_id')->first(),
                'driver_id' => $request->driver_id,
                'model' => $request->brand,
                'vehicle_make' => $request->vehicle_make,
                'year_of_registration' => $request->year_of_registration,
                'seats' => $request->seats,
                'color' => $request->color,
                'fuel_type' => $request->fuel_type,
                'plate_number' => $request->plate_number,
                'reg_validity' => $request->reg_validity,
                'insurance_validity' => $request->insurance_validity,
                'tax_validity' => $request->tax_validity,
                'is_available' => $request->is_available,
                'status' => $request->status,
                'vehicle_type' => BrandVehicle::where('id', $request->brand)->pluck('vehicle_type')->first(),

            ]);

        $imagePaths = [];

        if ($request->hasFile('images')) {
            foreach ($request->file('images') as $file) {
                $filename = Str::random(20) . '.' . $file->getClientOriginalExtension();
                $destinationPath = public_path('uploads/vehicle');

                // Create the folder if it doesn't exist
                if (!file_exists($destinationPath)) {
                    mkdir($destinationPath, 0755, true);
                }

                $file->move($destinationPath, $filename);
                $imagePaths[] =  $filename; // Relative public path
            }
            $vehicle = Vehicle::findOrFail($request->id);

            // Decode old image from DB
            $oldimage = json_decode($vehicle->image, true) ?? [];

            $allimage = array_merge($oldimage, $imagePaths);


            $res =  Vehicle::where('id', $request->id)
                ->update([
                    'image' => json_encode($allimage),
                ]);
        }



        if ($res == 1)
            return redirect()->back()->with('success', 'Vehicle  updated successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function deletevehicle(Request $request)
    {
        //  $data= Vehicle::where('id',$request->id)->first();
        //   if ((file_exists(public_path('uploads/vehicle/' . $data->image))) && ($data->image != NULL)) {
        //         unlink("uploads/vehicle/" . $data->image);
        //     }
        // if ((file_exists(public_path('uploads/driver/licence/', $data->licence))) && ($data->licence != NULL)) {
        //         unlink("uploads/driver/licence/" . $data->licence);
        //     }
        $res = Vehicle::where('id', $request->id)->delete();
        if ($res == 1)
            return redirect()->back()->with('success', 'Vehicle  deleted successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function deletevehicleImage(Request $request)
    {
        $vehicle = Vehicle::where('id', $request->id)->first();
        $updatedImages = [];
        $images = json_decode($vehicle->image); // this is already an array if casted

        $k = 0;
        foreach ($images as $i) {
            if ($i != $request->image) {
                $updatedImages[$k] = $i;
                $k++;
            }
        }

        // Optionally delete the file from public folder
        $imagePath = public_path('uploads/vehicle/' . $request->image);
        if (File::exists($imagePath)) {
            File::delete($imagePath);
        }

        $res =  Vehicle::where('id', $request->id)
            ->update([
                'image' => json_encode($updatedImages),
            ]);

        if ($res == 1)
            return redirect()->back()->with('success', 'Vehicle  deleted successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }
    //*********************************** vehicle  section end *****************************/

    public function assignDriver(Request $request)
    {
        try {

            $res = BookingHistory::where('id', $request->booking_id)
                ->update(['driver_id' => $request->driver_id, 'booking_status' => 'Confirmed']);
            if ($res == 1) {
                $user_phone = Partner::select()->where('id', BookingHistory::where('id', $request->booking_id)->pluck('booked_user_id')->first())->first();
                $bid = BookingHistory::where('id', $request->booking_id)->first();
                $driver = Driver::select('name', 'phone')->where('id', $request->driver_id)->first();
                $vehicle = Vehicle::select('model', 'plate_number')->where('id', $bid->vehicle_id)->first();
                $model = BrandVehicle::where('id', $vehicle->model)->pluck('model_name')->first();
                //                     $message="💛 You’re All Set!<br>
                // 🚖 Ride with RIDO – Your Trusted Travel Partner!
                // <br><br>
                // 📌 Booking ID: RIDO-".$bid."<br>
                // 👨‍✈️ Driver: ".ucfirst($driver->name)."<br>
                // 📞 Contact: ".$driver->phone."<br>
                // 🚗 Vehicle: ".$vehicle->plate_number." | ".$model."
                // <br><br>
                // ✨ Safe travels & happy moments await! ✨;";
                //    sendWhatsappNotification($bid->booking_id,$bid->client_name,$bid->client_mobile_number);
                //                             sendWhatsappNotification(
                //     "9188360241",                     // WhatsApp phone number
                //     "RIDO-BK000005",                  // Booking ID
                //     "Jayan",                          // Driver name
                //     "7888360240",                     // Contact number
                //     "KL-07-AB-4567 | Ertiga"          // Vehicle details
                // );
                return redirect()->back()->with('success', 'Driver Assigned & booking confimed Successfully');
            }
        } catch (QueryException $e) {
            return redirect()->back()->with('error', 'Database error ' . $e);
        } catch (Throwable $e) {
            return redirect()->back()->with('error', 'Something went wrong ' . $e);
        }
    }

    public function viewDriver(Request $request)
    {
        $res = Driver::where('id', $request->id)->first();
        return view('web.vendors.driver.view', ['data' => $res]);
    }
    public function viewvehicle(Request $request)
    {
        $vehicle =  Vehicle::join('vendors', 'vehicles.vendor_id', '=', 'vendors.id')
            ->join('drivers', 'drivers.vendor_id', '=', 'vendors.id')
            ->select(
                'vehicles.*',
                'vehicles.model',
                'vehicles.vehicle_make',
                'vehicles.year_of_registration',
                'vehicles.seats',
                'vehicles.color',
                'vehicles.fuel_type',
                'vehicles.plate_number',
                'vehicles.reg_validity',
                'vehicles.insurance_validity',
                'vehicles.tax_validity',
                'vehicles.image',
                'vehicles.vehicle_type',
                'vendors.name as vendor_name',
                'drivers.name as drivers_name',
                'vendors.vendor_image'
            ) // select vendor fields as needed
            ->where('vehicles.id', $request->id)
            ->first();
        // print_r($vehicle);die();
        $vehicle->model = BrandVehicle::where('id', $vehicle->model)->pluck('model_name')->first();
        foreach (json_decode($vehicle->image) as $i => $img) {
            if ($i == 3) {
                break; // Stop looping once 3 images collected
            }
            $gallery_images[$i] = asset('uploads/vehicle/' . $img); // or Storage::url($img) if using storage
        }

        if ($vehicle->vendor_image == NULL) {
            $vehicle->vendor_image = asset('assets/images/user.jpg');
        } else {
            $vehicle->vendor_image = asset('uploads/vendor/' . $vehicle->vendor_image);
        }
        $vehicle->image = $gallery_images;
        //  $vehicle->reviews=Review::where('vehicle_id',$request->vehicle_id)->get(); 
        $vehicle->reviews =  Review::select('reviews.id as reviewid', 'partners.name as user_name', 'partners.image as user_image', 'reviews.overall_rating', 'reviews.driver_rating', 'reviews.car_rating', 'reviews.comment', 'reviews.created_at')
            ->join('partners', 'partners.id', '=', 'reviews.user_id')
            ->where('reviews.vehicle_id', $request->vehicle_id)
            ->orderBy('reviews.id', 'desc')
            ->get();
        foreach ($vehicle->reviews as $item) {

            if ($item->image == NULL) {
                $item->image = asset('assets/images/user.jpg');
            } else {
                $item->image = asset('uploads/partner/' . $item->image);
            }
        }
        $vehicle->vehicle_type = VehicleCategory::where('id', $vehicle->vehicle_type)->pluck('name')->first();

        //** rating **** */

        $perStarAverage = Review::select(
            'car_rating',
            DB::raw('ROUND(AVG(car_rating), 1) as average'),
            DB::raw('COUNT(*) as count')
        )
            ->whereIn('car_rating', [1, 2, 3, 4, 5])
            ->where('vehicle_id', $request->id)
            ->groupBy('car_rating')
            ->orderBy('car_rating', 'desc')
            ->get();

        // print_r($perStarAverage);die();
        $vehicle->total_review_rate = $perStarAverage;

        // Initialize all ratings from 0 to 5 with default values
        $ratings = [];
        for ($i = 5; $i >= 0; $i--) {
            $ratings[$i] = [
                'rate' => $i,
                'average' => 0.0,
                'count' => 0,
            ];
        }

        // Overwrite with actual data from DB
        foreach ($perStarAverage as $row) {
            // Convert to percentage (assuming max rating is 5)
            $percentage = ($row->car_rating / 5) * 100;

            // Optional: round to 1 decimal place
            $percentage = round($percentage, 1);

            $ratings[$row->car_rating] = [
                'rate' => $row->car_rating,
                'average' => $percentage,
                'count' => (int) $row->count,
            ];
        }

        //  $perStarAverage->review_details=$ratings;
        $vehicle->review_star_rate = $ratings;

        // print_r($vehicle);die();
        return view('web.vendors.vehicle.view', ['data' => $vehicle]);
    }

    public function addtriplifecycle(Request $request)
    {
        $res = BookingHistory::where('booking_id', $request->id)->first();

        // Calculate remaining km
        $lastTrip = TripLifeCycle::where('booking_id', $res->id)->orderBy('id', 'DESC')->first();
        $remainingKM = $lastTrip ? $lastTrip->remaining_km : $res->total_km;
        $res->remainingKM = $remainingKM;

        // Fetch all existing trip life cycles for this booking, keyed by date
        $existingLifeCycles = TripLifeCycle::where('booking_id', $res->id)
            ->get()
            ->keyBy(function ($item) {
                return Carbon::parse($item->date)->format('Y-m-d');
            });

        // Pass BOTH variables to the view
        return view('web.vendors.add-lifecycle', [
            'data' => $res,
            'existingLifeCycles' => $existingLifeCycles
        ]);
    }

     public function getCoordinatesFromAddress($address)
    {
        try {
            $apiKey = Settings::pluck('google_map_api_key')->first();
            $response = Http::get("https://maps.googleapis.com/maps/api/geocode/json", [
                'address' => $address,
                'key' => $apiKey,
            ]);

            $data = $response->json();
            if ($data['status'] === 'OK') {
                $location = $data['results'][0]['geometry']['location'];
                return ['lat' => $location['lat'], 'lng' => $location['lng']];
            }

            throw new \Exception("Invalid address or failed to fetch coordinates.");
        } catch (QueryException $e) {
            return response()->json(['error' => 'Database error ' . $e], 500);
        } catch (Throwable $e) {
            return response()->json(['error' => 'Something went wrong ' . $e], 500);
        }
    }

     public function isPointInPolygon($point, $polygon)
    {
        try {
            $lat = $point['lat'];
            $lng = $point['lng'];
            $inside = false;
            $j = count($polygon) - 1;

            for ($i = 0; $i < count($polygon); $i++) {
                $xi = $polygon[$i]['lat'];
                $yi = $polygon[$i]['lng'];
                $xj = $polygon[$j]['lat'];
                $yj = $polygon[$j]['lng'];

                $intersect = (($yi > $lng) != ($yj > $lng))
                    && ($lat < ($xj - $xi) * ($lng - $yi) / ($yj - $yi) + $xi);
                if ($intersect) $inside = !$inside;
                $j = $i;
            }

            return $inside;
        } catch (QueryException $e) {
            return response()->json(['error' => 'Database error ' . $e], 500);
        } catch (Throwable $e) {
            return response()->json(['error' => 'Something went wrong ' . $e], 500);
        }
    }
}
