@extends('layouts.template')

@section('content')
<style>
    #map {
        height: 800px;
        width: 100%;
    }
</style>
<!-- Main Section start -->
<main>

    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12 ">
                <h4 class="main-title">Zones</h4>
                 @can('add-zone')
                <div style="float:right;margin-top: -51px;">
                    <a href="{{route('add-zone')}}" class="btn btn-primary btn-lg w-100 "><i class="ti ti-plus"></i> Add Zone</a>
                </div>
                @endcan
            </div>
        </div>
        <!-- Breadcrumb end -->

        <!-- Product List start -->
        <div class="row">

            <div class="col-12">
                <div class="card">
                    <div class="card-body px-0">
                        <div class=" table-responsive app-scroll app-datatable-default product-list-table">
                            <table id="product-Listtable" class="table table-sm display align-middle">
                                <thead>
                                    <tr>
                                        <th>
                                            #
                                        </th>
                                        <th>Zone name</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>

                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Product List end -->
    </div>
</main>

<script type="text/javascript">
    $(function() {

        $('.table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('get-zone') }}",
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                },
                {
                    data: 'name',
                    name: 'name'
                },

                {
                    data: 'status',
                    name: 'status'
                },

                {
                    data: 'action',
                    name: 'action'
                },

            ],
            "select": {
                'style': 'multi',
                'selector': 'td:first-child' //only checkbox can select row 
            },
        });
    });
</script>


<script async defer
    src="https://maps.googleapis.com/maps/api/js?key=AIzaSyABfBAX-v_a_99NqGylrBuo1mKPnZHx_Go&libraries=drawing&callback=initMap">
</script>
<script>
    let map, drawingManager, polygonCoords = [];

    function initMap() {
        map = new google.maps.Map(document.getElementById("map"), {
            center: {
                lat: 10.0,
                lng: 76.0
            },
            zoom: 7,
        });

        drawingManager = new google.maps.drawing.DrawingManager({
            drawingMode: google.maps.drawing.OverlayType.POLYGON,
            drawingControl: true,
            drawingControlOptions: {
                position: google.maps.ControlPosition.TOP_CENTER,
                drawingModes: ['polygon']
            }
        });

        drawingManager.setMap(map);

        google.maps.event.addListener(drawingManager, 'overlaycomplete', function(event) {
            const path = event.overlay.getPath();
            polygonCoords = [];
            for (let i = 0; i < path.length; i++) {
                polygonCoords.push({
                    lat: path.getAt(i).lat(),
                    lng: path.getAt(i).lng()
                });
            }
            document.getElementById("coordinates").value = JSON.stringify(polygonCoords);
        });
    }

    window.onload = initMap;
</script>

@endsection