@extends('layouts.vendor-template')

@section('content')

<!-- Main Section start -->
<main>

    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12 ">
                <h4 class="main-title">Vehicle details</h4>

                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="{{route('vendor.profile')}}" class="f-s-14 f-w-500">
                            <span>
                                <i class="ph-duotone  ph-stack f-s-16"></i> Home
                            </span>
                        </a>
                    </li>
                    <li>
                        <a href="{{route('vendor.vehicles')}}" class="f-s-14 f-w-500">Vehicle</a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Vehicle Details</a>
                    </li>
                </ul>

                <div style="float:right;    margin-top: -51px;">
                    <a href="{{route('vendor.edit-vehicle',['id'=>$data->id])}}" class="btn btn-primary btn-lg w-100 "><i class="ti ti-plus"></i> Edit vehicle</a>
                </div>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <!-- Product List start -->
        <div class="row">
            @php
            $rate=App\Models\Review::where('vehicle_id', $data->id)
            ->avg('car_rating');
            if($rate==''){
            $rate=0;
            }
            $rate=round($rate,1);

            @endphp


            <div class="col-12">
                <div class="row ">
                    <div class="col-lg-3 col-xxl-3 col-box-3 order-lg--1">
                        <div class="card">
                            <div class="card-body">
                                <div class="profile-container">
                                    <div class="image-details">
                                        <div class="profile-image" style="background-image:url({{asset('assets/images/team/1.jpg')}});"></div>
                                        <div class="profile-pic">
                                            <div class="avatar-upload">

                                                <div class="avatar-preview">
                                                    <div id="imgPreview" style="background-image:url({{$data->vendor_image}});">

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="person-details">
                                        <h5 class="f-w-600">{{$data->vendor_name}}
                                            <img src="{{asset('assets/images/profile-app/01.png')}}" class="w-20 h-20" alt="{{$data->vendor_image}}">
                                        </h5>
                                        <p>Vendor</p>
                                        <div class="rating ">
                                            @for($i=1;$i<=$rate;$i++)
                                                <input type="radio" id="star15" name="ratings2" value="15" checked="" disabled="">
                                                <label class="star" for="star15"><span class="ti ti-star-filled f-s-20 text-warning"></span></label>
                                                @endfor
                                                @for($i=1;$i<=5-$rate;$i++)
                                                    <input type="radio" id="star14" name="ratings2" value="14" disabled="">
                                                    <label class="star" for="star14"><span class="ti ti-star f-s-20 text-warning"></span></label>
                                                    @endfor

                                        </div>
                                        <div class="details">
                                            <div>
                                                <h4 class="text-primary"> {{count(App\Models\BookingHistory::where('vehicle_id',$data->id)->get())}}</h4>
                                                <p class="text-secondary">Total Rides</p>
                                            </div>

                                            <div>
                                                <h4 class="text-primary">{{$rate}}</h4>
                                                <p class="text-secondary">Total Review Rate</p>
                                            </div>
                                        </div>
                                        <button type="button" class="btn btn-{{ $data->is_availabile_status == 'True' ? 'success' : 'secondary' }} b-r-22" id="followButton"> <i class="ti ti-user"></i>
                                            Avaliable For ride </button>


                                        <button type="button" class="btn btn-{{ $data->add_vehicle_permission == 'ON' ? 'warning' : 'secondary' }} b-r-22" id="followButton"> <i class="ti ti-user"></i>
                                            {{ucfirst($data->status)}}</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-xxl-4 col-box-4 order-lg--1">
                        <div class="card">
                            <div class="card-header">
                                <h5>About Me</h5>
                            </div>
                            <div class="card-body">

                                <div class="about-list">
                                    <div>
                                        <span class="fw-semibold"><i class="ti ti-brand-github"></i>Driver Name</span>
                                        <span class="float-end f-s-13 text-secondary">{{$data->drivers_name}}</span>
                                    </div>
                                    <div>
                                        <span class="fw-semibold"><i class="ti ti-brand-github"></i>Vehicle Type</span>
                                        <span class="float-end f-s-13 text-secondary">{{$data->vehicle_type}}</span>
                                    </div>
                                    <div>
                                        <span class="fw-medium"><i class="ti ti-briefcase"></i> Model</span>
                                        <span class="float-end f-s-13 text-secondary">{{$data->model}}</span>
                                    </div>
                                    <div>
                                        <span class="fw-medium"><i class="ti ti-mail"></i>Vehicle Make</span>
                                        <span class="float-end f-s-13 text-secondary">{{$data->vehicle_make}}</span>
                                    </div>
                                    <div>
                                        <span class="fw-medium"><i class="ti ti-phone"></i>Year of registration</span>
                                        <span class="float-end f-s-13 text-secondary">{{$data->year_of_registration}}</span>
                                    </div>
                                    <div>
                                        <span class="fw-medium"><i class="ti ti-cake"></i>Seats</span>
                                        <span class="float-end f-s-13 text-secondary">{{$data->seats}}</span>
                                    </div>
                                    <div>
                                        <span class="fw-semibold"><i class="ti ti-map-pin"></i>Color</span>
                                        <span class="float-end f-s-13 text-secondary">{{$data->color}}</span>
                                    </div>
                                    <div>
                                        <span class="fw-semibold"><i class="ti ti-device-laptop"></i>Fuel Type</span>
                                        <span class="float-end f-s-13 text-secondary">{{$data->fuel_type}}</span>
                                    </div>
                                    <div>
                                        <span class="fw-semibold"><i class="ti ti-brand-github"></i>Plate Number</span>
                                        <span class="float-end f-s-13 text-secondary">{{$data->plate_number}}</span>
                                    </div>
                                    <div>

                                        <span class="fw-semibold"><i class="ti ti-brand-github"></i> Registry Validity</span>
                                        <span class="float-end f-s-13 text-secondary">{{date("d M Y",strtotime($data->reg_validity))}}</span>
                                    </div>

                                    <div>

                                        <span class="fw-semibold"><i class="ti ti-brand-github"></i> Tax Validity</span>
                                        <span class="float-end f-s-13 text-secondary">{{date("d M Y",strtotime($data->tax_validity))}}</span>
                                    </div>
                                    <div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-5 col-xxl-5 col-box-5 order-lg--1 ">
                        <div class="row ">
                            <div class="col-sm-12">
                                <div class="card ">
                                    <div class="card-body ">
                                        <div class="mt-4">
                                            <div class="d-flex gap-2 align-items-center">
                                                <div class="me-2 ">
                                                    <i class="ti ti-star-filled f-s-30 text-warning"></i>
                                                </div>
                                                <div class="">
                                                    <h5 class="m-0">{{$rate}} out of 5</h5>
                                                    <p class="mb-0 text-secondary f-s-13">Based on ({{count(App\Models\Review::where('vehicle_id', $data->id)->get())}}) ratings</p>
                                                </div>
                                            </div>
                                            <div class="mt-3">
                                                @for($i=5;$i>=0;$i--)
                                                <div class="d-flex align-items-center">
                                                    <h6 class="mb-0">{{$data->review_star_rate[$i]['rate']}} </h6>
                                                    <i class="ti ti-star-filled text-warning f-s-9"></i>
                                                    <div class="progress w-100 ms-2 me-2" role="progressbar" aria-valuenow="0" aria-valuemin="0"
                                                        aria-valuemax="100">
                                                        <div class="progress-bar bg-primary progress-bar-striped" style="width: {{$data->review_star_rate[$i]['average']}}%"></div>
                                                    </div>
                                                    <h6>({{$data->review_star_rate[$i]['count']}})</h6>
                                                </div>
                                                @endfor

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="profile-content">
                                        <div class="row app-slick-sliders">
                                            <!-- Multiple Items start  -->
                                            <div class="col-lg-12">
                                                <div class="card ">
                                                    <div class="card-body">
                                                        <div class="multiple-items app-arrow">
                                                            @foreach($data->image as $k=>$img)
                                                            <div class="items"><img src="{{$img}}" alt="image" class="img-fluid rounded">
                                                            </div>
                                                            @endforeach

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Multiple Items end  -->
                                </div>
                            </div>


                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <div class="row">
        <div class="col-12">
            <div class="tab-wrapper">
                <ul class="tabs">
                    <li class="tab-link active" data-tab="1"><i class="ph-duotone  ph-pen-nib f-s-18 me-2"></i>Bookings</li>
                    <li class="tab-link" data-tab="2"><i class="ph-duotone  ph-car-simple f-s-18 me-2"></i>Review</li>
                </ul>
            </div>
            <div class="content-wrapper mt-3">
                <div id="tab-1" class="tabs-content active">
                    <div class="card">
                        <div class="card-header">
                            <h4>Bookings</h4>
                        </div>
                        <div class="card-header">
                            <h5>Filter Data</h5>
                            <div class="row  mt-3">
                                <div class="col-md-3">
                                    <div class="mb-3">
                                        <label class="form-label">Start Date</label>
                                        <div class="input-group dates">
                                            <input class="form-control basic-date" type="text" name="start_date" id="start_date">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="mb-3">
                                        <label class="form-label">End Date </label>
                                        <div class="input-group dates">
                                            <input class="form-control basic-date" type="text" name="end_date" id="end_date">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="mb-3">
                                        <label class="form-label">Status </label>
                                        <select class="form-control " name="status" id="status">
                                            <option value="">All</option>
                                            <option value="Upcoming">Upcoming</option>
                                            <option value="Confirmed">Confirmed</option>
                                            <option value="Running">Running</option>
                                            <option value="Completed">Completed</option>
                                            <option value="Canceled">Canceled</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-3 mt-3">
                                    <div class="mt-2">
                                        <button type="submit" class="btn btn btn-primary filter">Filter </button>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="card-body px-0">
                            <div class=" table-responsive app-scroll app-datatable-default product-list-table">
                                <table id="product-Listtable" class="table table-sm display align-middle bookings">
                                    <thead>
                                        <tr>
                                            <th>
                                                #
                                            </th>
                                            <th> BOOKING ID</th>
                                           
                                            <th>DRIVER</th>
                                            <th>VEHICLE</th>
                                            <th>BOOKED BY</th>
                                            <th>BOOKING STATUS</th>
                                            <th>TOTAL KM</th>
                                            <th>TOTAL FARE</th>
                                            <th>PAYMENT STATUS</th>
                                         
                                        </tr>
                                    </thead>

                                    <tbody>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <div id="tab-2" class="tabs-content">
                    <div class="card">
                        <div class="card-header">
                            <h4>Reviews</h4>

                        </div>
                        <div class="card-header">
                            <h5>Filter Data using review post date</h5>
                            <div class="row mt-3">
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Start Date</label>
                                        <div class="input-group dates">
                                            <input class="form-control basic-date" type="text" name="review_start_date" id="review_start_date">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">End Date </label>
                                        <div class="input-group dates">
                                            <input class="form-control basic-date" type="text" name="review_end_date" id="review_end_date">
                                        </div>
                                    </div>
                                </div>


                                <div class="col-4 mt-3">
                                    <div class="mt-2">
                                        <button type="submit" class="btn btn btn-primary filterreview">Filter </button>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="card-body px-0">
                            <div class=" table-responsive app-scroll app-datatable-default product-list-table">
                                <table id="product-Listtable" class="table table-sm display align-middle reviews" style="width:100%;">
                                    <thead>
                                        <tr class="text-center">
                                            <th>
                                                #
                                            </th>
                                            <th>Booking ID</th>
                                            <th>User</th>
                                            <th>Rate</th>
                                            <th>Comment</th>
                                            <th>Posted On</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>

                                    <tbody>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


    </div>


    </div>
    </div>
    <!-- Product List end -->
    </div>
</main>

<script type="text/javascript">
    $(function() {

        var table = $('.bookings').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('vendor.get-bookings') }}",
                data: function(d) {
                    d.start_date = $('#start_date').val();
                    d.end_date = $('#end_date').val();
                    d.status = $('#status').val();
                    d.vehicle_id = <?php echo $data->id; ?>;
                }
            },

            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                },
                {
                    data: 'booking_id',
                    name: 'booking_id'
                },
              
                {
                    data: 'driver',
                    name: 'driver'
                },
                {
                    data: 'vehicle',
                    name: 'vehicle'
                },
                {
                    data: 'booked_by',
                    name: 'booked_by'
                },
                {
                    data: 'booking_status',
                    name: 'booking_status'
                },
                {
                    data: 'total_km',
                    name: 'total_km'
                },
                {
                    data: 'total_fare',
                    name: 'total_fare'
                },
                {
                    data: 'payment_status',
                    name: 'payment_status'
                },
                

            ],
            "select": {
                'style': 'multi',
                'selector': 'td:first-child' //only checkbox can select row 
            },
        });

        $(".filter").click(function() {
            table.draw();
        });


        var tablereview = $('.reviews').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('get-reviews') }}",
                data: function(d) {
                    d.start_date = $('#review_start_date').val();
                    d.end_date = $('#review_end_date').val();
                    d.vehicle_id = <?php echo $data->id; ?>;
                }
            },

            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                },
                {
                    data: 'booking_id',
                    name: 'booking_id'
                },

                {
                    data: 'user',
                    name: 'user'
                },
                {
                    data: 'rate',
                    name: 'rate'
                },
                {
                    data: 'comment',
                    name: 'comment'
                },
                {
                    data: 'postedon',
                    name: 'postedon'
                },
                {
                    data: 'action',
                    name: 'action'
                },

            ],
            "select": {
                'style': 'multi',
                'selector': 'td:first-child' //only checkbox can select row 
            },
        });

        $(".filterreview").click(function() {
            tablereview.draw();
        });
    });
</script>
@endsection