@extends('layouts.vendor-template')

@section('content')

<!-- Main Section start -->
<main>

    <div class="container-fluid">

        <!-- Product List start -->
        <div class="row">

            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Edit Profile</h4>
                    </div>
                    <div class="card-body px-5">
                        <form action="{{route('vendor.update-profile')}}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="row">

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Name</label>
                                        <input type="text" class="form-control" value="{{$data->name}}" name="name" required>
                                    </div>
                                </div>


                                <div class="col-6">
                                    <div class="mb-3">
                                        <label class="form-label">Email address</label>
                                        <input type="email" name="email" value="{{$data->email}}" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label"> Zone</label>
                                        <select class="form-control" name="zone_id" required>
                                            <option value="">---Select Zone---</option>
                                            @foreach(App\Models\Zone::where('status', 'ACTIVE')->get() as $item)
                                              <option value="{{$item->id}}" {{ $data->zone == $item->id ? 'selected' : '' }}>{{$item->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Dispaly Image</label>
                                        <input type="file" class="form-control" name="photo">
                                    </div>
                                </div>

                                <div class="col-12">
                                    <div class="mb-3">
                                        <label class="form-label">Address</label>
                                        <input type="text" name="address" value="{{$data->address}}" required class="form-control">

                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">District</label>
                                        <input type="text" name="district" value="{{$data->district}}" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">State</label>
                                        <div class="input-group">
                                            <input class="form-control" value="{{$data->state}}" type="text" name="state">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Country</label>
                                        <input type="text" class="form-control" value="{{$data->country}}" name="country">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3 floating-select">
                                        <input type="hidden" value="{{$data->id}}" name="id">
                                        <label class="form-label">Postal Code</label>
                                        <input type="text" class="form-control" value="{{$data->postal_code}}" name="postal_code">
                                    </div>
                                </div>


                                <div class="col-12 mt-3">
                                    <div class="text-end">
                                        <button type="submit" class="btn btn btn-primary">UPDATE VENDOR</button>
                                    </div>
                                </div>
                            </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- Product List end -->
    </div>
</main>

<script type="text/javascript">

</script>
@endsection