@extends('layouts.template')

@section('content')

<!-- Main Section start -->
<main>

    <div class="container-fluid">

        <!-- Product List start -->
        <div class="row">

            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Edit vendor details</h4>
                    </div>
                    <div class="card-body px-5">
                        <form action="{{route('update-vendor')}}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="row">

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Name</label>
                                        <input type="text" class="form-control" value="{{$data->name}}" name="name" required>
                                    </div>
                                </div>
                                <div class="col-md-6">

                                    <div class="mb-3">
                                        <label class="form-label">Phone </label>
                                        <input type="text" name="phone" class="form-control" value="{{$data->phone}}" required   maxlength="13">
                                    </div>
                                </div>

                                <div class="col-6">
                                    <div class="mb-3">
                                        <label class="form-label">Email address</label>
                                        <input type="email" name="email" value="{{$data->email}}" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Vendor Zone</label>
                                        <select class="form-control" name="zone_id" required>
                                            <option value="">---Select Zone---</option>
                                            @foreach(App\Models\Zone::where('status','ACTIVE')->get() as $item)
                                            <option value="{{$item->id}}" {{ $data->zone == $item->id ? 'selected' : '' }}>{{$item->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-6">
                                    <div class="mb-3">
                                        <label class="form-label">Address</label>
                                        <input type="text" name="address" value="{{$data->address}}" required class="form-control">

                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">District<span class="form-text">(Optional)</span></label>
                                        <input type="text" name="district" value="{{$data->district}}" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">State<span class="form-text">(Optional)</span></label>
                                        <div class="input-group">
                                            <input class="form-control" value="{{$data->state}}" type="text" name="state">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Country<span class="form-text">(Optional)</span></label>
                                        <input type="text" class="form-control" value="{{$data->country}}" name="country">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3 floating-select">
                                        <input type="hidden" value="{{$data->id}}" name="id">
                                        <label class="form-label">Postal Code<span class="form-text">(Optional)</span></label>
                                        <input type="text" class="form-control" value="{{$data->postal_code}}" name="postal_code">
                                    </div>
                                </div>


                                <div class="col-lg-4 col-md-4">
                                    <div class="input-block mb-3">
                                        <label>Driver Add Permission</label>
                                        <select class="form-control" name="add_driver_permission">
                                            <option value="ON" {{ $data->add_driver_permission == 'ON' ? 'selected' : '' }}>ON</option>
                                            <option value="OFF" {{ $data->add_driver_permission == 'OFF' ? 'selected' : '' }}>OFF</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4">
                                    <div class="input-block mb-3">
                                        <label>Set as Driver also</label>
                                        <select class="form-control" name="driver_also">
                                            <option value="YES" {{ $data->driver_also == 'YES' ? 'selected' : '' }}>YES</option>
                                            <option value="NO" {{ $data->driver_also == 'NO' ? 'selected' : '' }}>NO</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4">
                                    <div class="input-block mb-3">
                                        <label>STATUS</label>
                                        <select class="form-control" name="status">
                                            <option name="ACTIVE" {{ $data->status == 'REQUESTED' ? 'selected' : '' }}>REQUESTED</option>
                                            <option name="ACTIVE" {{ $data->status == 'ACTIVE' ? 'selected' : '' }}>ACTIVE</option>
                                            <option name="BLOCKED" {{ $data->status == 'BLOCKED' ? 'selected' : '' }}>BLOCKED</option>
                                        </select>
                                    </div>
                                </div>


                                <div class="col-12 mt-3">
                                    <div class="text-end">
                                        <button type="submit" class="btn btn btn-primary">UPDATE VENDOR</button>
                                    </div>
                                </div>
                            </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- Product List end -->
    </div>
</main>

<script type="text/javascript">

</script>
@endsection