@extends('layouts.template')

@section('content')
<style>
#driverDiv{
    display:none;
}
 </style>
        <!-- Main Section start -->
        <main>
            
     <div class="container-fluid">

        <!-- Product List start -->
        <div class="row">

            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                    <h4>Add Vendor</h4>
                </div>
                    <div class="card-body px-5">
                         <form action="{{route('add-vendor')}}" method="post" enctype="multipart/form-data">
                                @csrf
                       <div class="row">
                                               
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Name</label>
                                                            <input type="text" class="form-control" name="name" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        
                                                        <div class="mb-3">
                                                            <label class="form-label">Phone </label>
                                                            <input type="text" name="phone" class="form-control" required  maxlength="13">
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="col-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Email address<span class="form-text">(Optional)</span></label>
                                                            <input type="email" name="email" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Driver Zone</label>
                                                            <select class="form-control" name="zone_id" required>
                                                                <option value="NULL">---Select Zone---</option>
                                                                @foreach(App\Models\Zone::where('status','ACTIVE')->get() as $item)
                                                                    <option value="{{$item->id}}">{{$item->name}}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>
                                                     <div class="col-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Address</label>
                                                            <input type="text" name="address" required class="form-control" required>
                                                         
                                                        </div>
                                                    </div>
                                                 
                                                     <div class="col-lg-6 col-md-6">
                                                        <div class="input-block mb-3">
                                                            <label>Driver Add Permission</label>
                                                            <select class="form-control" name="add_driver_permission">
                                                            <option name="add_permission" >ON</option>
                                                            <option name="add_permission" >OFF</option>
                                                            </select>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-3">
                                                        <div class="mb-3">
                                                            <label class="form-label">District<span class="form-text">(Optional)</span></label>
                                                            <input type="text" name="district"  class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="mb-3">
                                                            <label class="form-label">State<span class="form-text">(Optional)</span></label>
                                                            <div class="input-group">
                                                                <input class="form-control" type="text" name="state">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="col-md-3">
                                                        <div class="mb-3">
                                                            <label class="form-label">Country<span class="form-text">(Optional)</span></label>
                                                            <input type="text" class="form-control"  name="country">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="mb-3 floating-select">
                                                            <label class="form-label">Postal Code<span class="form-text">(Optional)</span></label>
                                                            <input type="text" class="form-control"  name="postal_code">
                                                        </div>
                                                    </div>
                                                
                                                      <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <div class="card-body custom-selection address-content card-light-primary ">
                                                                <div class="position-relative">
                                                                    <label class="check-box">
                                                                        <input type="checkbox" name="isdriver" id="toggleCheckbox">
                                                                        <span class="checkmark outline-dark ms-2"></span>
                                                                        <span class="text-dark">Set as Driver</span>
                                                                    </label>
                                                                    <!-- <label class="check-box">
                                                                        <input type="radio" name="isdriver" onclick="toggleDivs()">
                                                                        <span class="radiomark outline-secondary position-absolute"></span>
                                                                        <span class="ms-4 fs-6">Set as Driver </span>
                                                                    </label> -->
                                                                </div>
                                                                <div>
                                                               
                                                                    <i class="ti ti-brand-appstore icon-bg"></i>
                                                                    <p class="text-muted">Check 'set as driver' for save this vendor also as a driver.</p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class ="row" id="driverDiv">
                                                     <div class="col-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">License Number </label>
                                                            <input type="text" name="licence_number"  class="form-control">
                                                         
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Zone</label>
                                                            <select class="form-control" name="zone_id">
                                                                <option value="NULL">---Select Zone---</option>
                                                                @foreach(App\Models\Zone::where('status','ACTIVE')->get() as $item)
                                                                    <option value="{{$item->id}}">{{$item->name}}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>


                                                     <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Image</label>
                                                            <input type="file" class="form-control" name="photo" >
                                                        </div>
                                                    </div>
                                                    
                                                      <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Licence</label>
                                                            <input type="file" accept="image/*" class="form-control" name="licence" >
                                                        </div>
                                                    </div>

                                                </div>

                                                    <div class="col-12 mt-3">
                                                        <div class="text-end">
                                                            <button type="submit" class="btn btn btn-primary">SAVE VENDOR</button>
                                                        </div>
                                                  </div>
                                                </div>
                         </div>
                     </form>
                </div>
            </div>
        </div>
        <!-- Product List end -->
    </div>
        </main>
      
   <script type="text/javascript">
//      function toggleDivs() {
//     const selectedValue = document.querySelector('input[name="isdriver"]:checked').value;
// alert(selectedValue);
//     // Hide both divs first
//     document.getElementById('driverDiv').style.display = 'none';

//     // Show the selected one
//     if (selectedValue === 'on') {
//       document.getElementById('driverDiv').style.display = 'flex';
//     } else if (selectedValue === 'off') {
//       document.getElementById('driverDiv').style.display = 'none';
//     }
//   }


  document.getElementById('toggleCheckbox').addEventListener('change', function() {
  var driverDiv = document.getElementById('driverDiv');
  if (this.checked) {
    driverDiv.style.display = 'flex';
  } else {
    driverDiv.style.display = 'none';
  }
});
    </script>
  @endsection
