@extends('layouts.template')

@section('content')

<!-- Main Section start -->
<main>

    <div class="container-fluid">

        <!-- Product List start -->
        <div class="row">

            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Edit vehicle</h4>
                    </div>
                    <div class="card-body px-5">
                        <form action="{{route('update-vehicle')}}" method="post" enctype="multipart/form-data">
                            @csrf


                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Driver</label>
                                        <select class="form-control" name="driver_id" required>
                                            <option value="">---Select Driver---</option>
                                            @foreach(App\Models\Driver::where('status','ACTIVE')->get() as $item)
                                            <option value="{{$item->id}}" {{ $data->driver_id == $item->id ? 'selected' : '' }}>{{$item->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Vehicle Modal</label>
                                        <select class="form-control" name="brand" required>
                                            <option value="">---Select brand---</option>
                                            @foreach(App\Models\BrandVehicle::get() as $item)
                                            <option value="{{$item->id}}" {{ $data->model == $item->id ? 'selected' : '' }}>{{App\Models\Brand::where('id',$item->brand)->pluck('name')->first()}} -{{$item->model_name}} </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="mb-3 floating-select">
                                        <input type="hidden" value="{{$data->id}}" name="id">
                                        <label class="form-label">Vehicle Make</label>
                                        <input type="text" class="form-control" value="{{$data->vehicle_make }}" required name="vehicle_make">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Year of registration</label>
                                        <input type="number" name="year_of_registration" value="{{$data->year_of_registration }}" required class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Number of Passengers seats</label>
                                        <input type="number" name="seats" required value="{{$data->seats }}" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Color</label>
                                        <div class="input-group">
                                            <input class="form-control" required value="{{$data->color }}" type="text" name="color">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Fuel Type</label>
                                        <select class="form-control" name="fuel_type" required>
                                            <option value="Petrol" {{ $data->fuel_type == 'Petrol' ? 'selected' : '' }}>Petrol</option>
                                            <option value="Diesel" {{ $data->fuel_type == 'Diesel' ? 'selected' : '' }}>Diesel</option>
                                            <option value="CNG" {{ $data->fuel_type == 'CNG' ? 'selected' : '' }}>CNG</option>
                                            <option value="Electric" {{ $data->fuel_type == 'Electric' ? 'selected' : '' }}>Electric</option>
                                        </select>
                                    </div>
                                </div>


                                <div class="col-md-4">
                                    <div class="mb-3 floating-select">
                                        <label class="form-label">Plate Number</label>
                                        <input type="text" class="form-control" value="{{$data->plate_number }}" required name="plate_number">
                                    </div>
                                </div>


                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Registration validity</label>
                                        <div class="input-group dates">
                                            <input class="form-control basic-date" value="{{$data->reg_validity }}" required type="text" name="reg_validity">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Insurance Validity</label>
                                        <div class="input-group dates">
                                            <input class="form-control basic-date" required value="{{$data->insurance_validity }}" type="text" name="insurance_validity">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Tax Validity</label>
                                        <div class="input-group dates">
                                            <input class="form-control basic-date" value="{{$data->tax_validity }}" required type="text" name="tax_validity">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label>Status</label>
                                        <select class="form-control" name="status" required>
                                            <option value="ACTIVE" {{ $data->status == 'ACTIVE' ? 'selected' : '' }}>ACTIVE</option>
                                            <option value="BLOCKED" {{ $data->status == 'BLOCKED' ? 'selected' : '' }}>BLOCKED</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label>Availability Status</label>
                                        <select class="form-control" name="is_available">
                                            <option value="Available" {{ $data->status == 'Available' ? 'selected' : '' }}>Available</option>
                                            <option value="Booked" {{ $data->status == 'Booked' ? 'selected' : '' }}>Booked</option>
                                            <option value="Maintenance" {{ $data->status == 'Maintenance' ? 'selected' : '' }}>Maintenance</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="mb-3 file-uploader-box">
                                        <label class="form-label">Image</label>
                                        <input type="file" class="form-control filepond|" name="images[]" multiple />
                                    </div>
                                </div>


                                <div class="col-md-12">
                                    <div class="app-timeline-info-text timeline-border-box me-2 ms-0 mt-3 p-3">
                                        <div class="row">
                                            @foreach(json_decode($data->image) as $item)
                                            <div class="col-sm-3 text-center">
                                                <div class="center-thing ">
                                                    <a href="{{asset('uploads/vehicle/' .$item)}}" class="glightbox " data-glightbox="type: image; zoomable: true;" target="_blank">
                                                        <img src="{{asset('uploads/vehicle/' .$item)}}" class="w-100 rounded" alt="" style="width:200px;height:200px;">
                                                    </a>
                                                </div>
                                                @can('delete-vehicle-image')
                                                <a href="{{route('delete-vehicle-image',['id'=>$data->id,'image'=>$item])}}" class="text-danger"><i class="ti ti-trash"></i> Delete </a>
                                                @endcan
                                            </div>
                                            @endforeach

                                        </div>
                                    </div>
                                </div>

                                <div class="col-12 mt-3">
                                    <div class="text-end">
                                        <button type="submit" class="btn btn btn-primary">SAVE</button>
                                    </div>
                                </div>
                            </div>
                    </div>





                    </form>
                </div>
            </div>
        </div>
        <!-- Product List end -->
    </div>
</main>

<script type="text/javascript">

</script>
@endsection