<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Trip Invoice</title>
    <style>
        body { font-family: sans-serif; font-size: 14px; }
        .header, .footer { text-align: center; }
        .section { margin-bottom: 20px; }
        table { width: 100%; border-collapse: collapse; }
        th, td { padding: 8px; border: 1px solid #ccc; text-align: left; }
        .total { font-weight: bold; background: #f0f0f0; }
    </style>
</head>
<body>

<div class="header">
    <h2>RideGo Cabs Pvt. Ltd.</h2>
    <p>MG Road, Kochi, Kerala 682016<br>
    Phone: +91-98765-43210 | Email: support@ridego.in<br>
    GSTIN: 32ABCDE1234F1Z5</p>
</div>

<hr>

<div class="section">
    <h4>Trip Summary</h4>
    <table>
        <tr><td>Booking ID</td><td>{{ $trip->booking_id }}</td></tr>
        <tr><td>Date & Time</td><td>{{ $trip->date }} at {{ $trip->time }}</td></tr>
        <tr><td>Driver</td><td>{{ $trip->driver_name }}</td></tr>
        <tr><td>Vehicle</td><td>{{ $trip->vehicle }} ({{ $trip->vehicle_number }})</td></tr>
    </table>
</div>

<div class="section">
    <h4>Customer Details</h4>
    <table>
        <tr><td>Name</td><td>{{ $trip->customer_name }}</td></tr>
        <tr><td>Phone</td><td>{{ $trip->customer_phone }}</td></tr>
        <tr><td>Pickup</td><td>{{ $trip->pickup_address }}</td></tr>
        <tr><td>Drop</td><td>{{ $trip->drop_address }}</td></tr>
    </table>
</div>

<div class="section">
    <h4>Fare Breakdown</h4>
    <table>
        <tr><td>Base Fare</td><td>₹{{ number_format($trip->base_fare, 2) }}</td></tr>
        <tr><td>Distance Fare</td><td>₹{{ number_format($trip->distance_fare, 2) }}</td></tr>
        <tr><td>Toll Charges</td><td>₹{{ number_format($trip->toll_charge, 2) }}</td></tr>
        <tr><td>GST (5%)</td><td>₹{{ number_format($trip->gst, 2) }}</td></tr>
        <tr class="total"><td>Total Fare</td><td>₹{{ number_format($trip->total_amount, 2) }}</td></tr>
    </table>
</div>

<div class="section">
    <h4>Trip Details</h4>
    <table>
        <tr><td>Pickup Time</td><td>{{ $trip->pickup_time }}</td></tr>
        <tr><td>Drop Time</td><td>{{ $trip->drop_time }}</td></tr>
        <tr><td>Distance</td><td>{{ $trip->distance }} km</td></tr>
        <tr><td>Duration</td><td>{{ $trip->duration }}</td></tr>
        <tr><td>Payment Mode</td><td>{{ $trip->payment_mode }}</td></tr>
        <tr><td>Status</td><td>{{ ucfirst($trip->status) }}</td></tr>
    </table>
</div>

<div class="footer">
    <p>Thank you for riding with us!<br>
    For support: support@ridego.in</p>
</div>

</body>
</html>
