<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Rido Trip Invoice</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 14px;
            margin: 0 40px;
        }
        h2, h4 {
            text-align: center;
            margin-bottom: 10px;
        }
        table {
            width: 100%;
            margin-top: 10px;
            border-collapse: collapse;
        }
        th, td {
            padding: 6px 10px;
            border: 1px solid #ccc;
        }
        .no-border td {
            border: none;
            padding: 5px 0;
        }
        .total {
            font-weight: bold;
            background-color: #f3f3f3;
        }
        .section-title {
            margin-top: 30px;
            font-weight: bold;
            font-size: 16px;
            border-bottom: 1px solid #ccc;
        }
    </style>
</head>
<body>

    <h2>Cab Trip Invoice</h2>
    <h4>Rido Travels</h4>

    <table class="no-border">
        <tr>
            <td><strong>Booking ID:</strong> {{ $invoice->booking_id }}</td>
            <td><strong>Date:</strong> {{ $invoice->trip_date }}</td>
        </tr>
         
        <tr>
            <td><strong>Driver:</strong> {{ $invoice->driver_name }}</td>
            <td><strong>Vehicle:</strong> {{ $invoice->vehicle }} ({{ $invoice->vehicle_no }})</td>
        </tr>
    </table>

    <p class="section-title">Customer Details</p>
    <table>
        <tr>
            <th>Name</th>
            <th>Contact</th>
            <th>Pickup Address</th>
            <th>Drop Address</th>
        </tr>
        <tr>
            <td>{{ $invoice->customer_name }}</td>
            <td>{{ $invoice->customer_contact }}</td>
            <td>{{ $invoice->pickup_address }}</td>
            <td>{{ $invoice->drop_address }}</td>
        </tr>
    </table>

    <p class="section-title">Fare Breakdown</p>
    <table>
        <tr>
            <th>Description</th>
            <th>Amount (₹)</th>
        </tr>
       <tr class="total">
            <td>Base Fare</td>
            <td>₹{{ number_format($invoice->base_fare, 2) }}</td>
        </tr>
        <tr>
            <td>tax ({{$invoice->tax_percentage}}%)</td>
            <td>{{ number_format($invoice->tax, 2) }}</td>
        </tr>
        <tr class="total">
            <td>Total Fare</td>
            <td>₹{{ number_format($invoice->total_fare, 2) }}</td>
        </tr>
     
         <tr>
            <td>Paid Amount</td>
            <td>{{ number_format($invoice->paid_amount, 2) }}</td>
        </tr>
    </table>

    <p class="section-title">Trip Summary</p>
    <table>
        <tr>
            <td><strong>Pickup Time:</strong> {{ $invoice->pickup_time }}</td>
            <td><strong>Drop Time:</strong> {{ $invoice->drop_time }}</td>
        </tr>
        <tr>
            <td><strong>Distance:</strong> {{ $invoice->total_km }} km</td>
            <td><strong>No: of Days:</strong> {{ $invoice->days }}</td>
        </tr>
        <tr>
            <td><strong>Payment Mode:</strong> {{ $invoice->payment_mode }}</td>
            <td><strong>Status:</strong> {{ $invoice->status }}</td>
        </tr>
    </table>

    <p style="margin-top: 30px;">Thank you for riding with RideTravels! For support, contact support@rido.travel</p>

</body>
</html>
