@extends('layouts.template')

@section('content')

        <!-- Main Section start -->
        <main>
            
                <div class="container-fluid">
        <div class="row">
            <div class="col-lg-8 col-xxl-8 eshop-cards-container">
                <div class="row">
                    <div class="col-6 col-md-6 col-lg-6">
                        <div class="card">
                            <span class="bg-primary h-50 w-50 d-flex-center rounded-circle m-auto eshop-icon-box">
                         <i class="ph-fill  ph-money" style="font-size: 22px;"></i>
                            </span>


                            <div class="card-body eshop-cards">
                                <span class="ripple-effect"></span>
                                <div class="overflow-hidden">
                                    <h3 class="text-primary mb-0">{{count(App\Models\BookingHistory::get())}}</h3>
                                    <p class="mg-b-35 f-w-600 text-dark-800 txt-ellipsis-1">Total Bookings</p>
                                    <a href="{{route('bookings')}}" class="badge bg-light-primary">View Bookings</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-6 col-md-3 col-lg-6">
                        <div class="card">
                              <span class="bg-danger h-50 w-50 d-flex-center rounded-circle m-auto eshop-icon-box">
                                         <i class="ph-fill  ph-handshake" style="font-size: 22px;"></i>
                              </span>
                            <div class="card-body eshop-cards">
                                <span class="ripple-effect"></span>
                                <h3 class="text-danger mb-0">{{count(App\Models\Partner::where('role','Partner')->get())}}</h3>
                                <p class="mg-b-35 f-w-600 text-dark-800 txt-ellipsis-1">Total Partners</p>
                                <a href="{{route('partners')}}" class="badge bg-light-danger">View Partners</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-6 col-md-3 col-lg-6">
                        <div class="card">
                            <span class="bg-warning h-50 w-50 d-flex-center rounded-circle m-auto eshop-icon-box">
                                <i class="ph-duotone  ph-certificate f-s-24"></i>
                            </span>
                            <div class="card-body eshop-cards">
                                <span class="ripple-effect"></span>
                                <h3 class="text-warning mb-0 txt-ellipsis-1"> {{count(App\Models\Partner::where('role','Customer')->get())}}</h3>
                                <p class="mg-b-35 f-w-600 text-dark-800 txt-ellipsis-1">Total Clients</p>
                                <a href="{{route('customers')}}" class="badge bg-light-dark">View Clients</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-6 col-md-3 col-lg-6">
                        <div class="card">
                             <span class="bg-success h-50 w-50 d-flex-center rounded-circle m-auto eshop-icon-box">
                                 <i class="ph-duotone  ph-user-circle-plus f-s-24"></i>
                             </span>
                            <div class="card-body eshop-cards">
                                <span class="ripple-effect"></span>
                                <h3 class="text-success mb-0">{{count(App\Models\Driver::get())}}</h3>
                                <p class="mg-b-35 f-w-600 text-dark-800 txt-ellipsis-1">Total Drivers</p>
                                <a  href="{{route('drivers')}}" class="badge bg-light-success">View Drivers</a>
                            </div>
                        </div>
                    </div>
                


                   <div class="col-6 col-md-6 col-lg-6">
                        <div class="card">
                            <span class="bg-primary h-50 w-50 d-flex-center rounded-circle m-auto eshop-icon-box">
                     <i class="ph-fill  ph-car"  style="font-size: 22px;"></i>
                            </span>


                            <div class="card-body eshop-cards">
                                <span class="ripple-effect"></span>
                                <div class="overflow-hidden">
                                    <h3 class="text-primary mb-0">{{count(App\Models\Vehicle::get())}}</h3>
                                    <p class="mg-b-35 f-w-600 text-dark-800 txt-ellipsis-1">Total Vehicles</p>
                                    <a href="{{route('vehicles')}}" class="badge bg-light-primary">View Vehicles</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-6 col-md-3 col-lg-6">
                        <div class="card">
                              <span class="bg-danger h-50 w-50 d-flex-center rounded-circle m-auto eshop-icon-box">
                                        <i class="ph-fill  ph-map-pin" style="font-size: 22px;"></i>
                              </span>
                            <div class="card-body eshop-cards">
                                <span class="ripple-effect"></span>
                                <h3 class="text-danger mb-0">{{count(App\Models\Zone::get())}}</h3>
                                <p class="mg-b-35 f-w-600 text-dark-800 txt-ellipsis-1">Total Zones</p>
                                <a href="{{route('zones')}}" class="badge bg-light-danger">View Zones</a>
                            </div>
                        </div>
                    </div>
</div>
            </div>

          

            <div class="col-sm-4 col-lg-4 col-xxl-4 ">
                  <div class="row">
                 
                    <div class="col-sm-6 col-lg-12">
                        <div class="card bg-primary profit-card-2">
                            <div class="card-body">
                                  <i class="ph-fill  ph-money  icon-bg" ></i>
                                <!-- <i class="ph-duotone  ph-calendar-check icon-bg"></i> -->
                                <span class="bg-white h-50 w-50 d-flex-center b-r-50">
                                      <i class="ph-fill  ph-money f-s-24"></i>
                          <!-- <i class="ph-duotone ph-calendar-check text-primary f-s-24"></i> -->
                        </span>
                                <div class="mt-3">
                                    <h4 class="text-white">{{App\Models\BookingHistory::where('payment_status','Paid')->sum('platform_fee')}}</h4>
                                    <p class="f-w-500 mb-0 txt-ellipsis-1">Total Earning</p>
                                </div>
                            </div>
                        </div>
                    </div>
                <ul class="notifications-list box-list mb-4 ">
                    <li class="d-flex align-items-center justify-content-between gap-3 b-s-4-primary">
                        <div>
                            
                            <h6 class="txt-ellipsis-1 mb-0"> Booking Notifications List</h6>
                           
                        </div>
                        <div class="h-45 w-45 d-flex-center rounded-circle flex-shrink-0 bg-light-primary position-relative">
                            <i class="ph ph-bell-ringing f-s-20"></i>
                            <span class="position-absolute translate-middle badge rounded-pill bg-danger badge-notification">  {{count(App\Models\BookingHistory::where('booking_status','Upcoming')->get())}}</span>
                        </div>
                    </li>
                @foreach(App\Models\BookingHistory::where('booking_status','Upcoming')->get() as $item)
                    <li class="d-flex align-items-center">
                        <div class="h-45 w-45 d-flex-center b-r-12 overflow-hidden flex-shrink-0 bg-success-400">
                            <img alt="order" class="img-fluid" src="{{asset('assets/images/avatar/2.png')}}">
                        </div>
                        <div class="ms-3">
                            <a href="{{route('get-booking-details', ['id' => $item->booking_id]) }}" class="mb-0 f-w-500 f-s-16 txt-ellipsis-1">Booking #{{$item->booking_id}} has been Booked</a>
                            <p class="mb-0 text-secondary">{{$item->created_at}}</p>
                        </div>
                    </li>
                    @endforeach
                    
                </ul>

                    
                </div>
            </div>


        </div>
    </div>

        </main>
      
@endsection
