@extends('layouts.template')

@section('content')

<!-- Main Section start -->
<main>

    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12 ">
                <h4 class="main-title">Fare Managment</h4>
                @can('fare')
                <div style="float:right;    margin-top: -51px;">
                    <a href="{{route('add-fare')}}" class="btn btn-primary btn-lg w-100 "><i class="ti ti-plus"></i> Add fare</a>
                </div>
                @endcan

            </div>
        </div>
        <!-- Breadcrumb end -->

        <!-- Product List start -->
        <div class="row">

            <div class="col-12">
                <div class="card">
                    <div class="card-body px-0">
                        <div class=" table-responsive app-scroll app-datatable-default product-list-table">
                            <table id="product-Listtable" class="table table-sm display align-middle">
                                <thead>
                                    <tr>
                                        <th>
                                            #
                                        </th>
                                        <th>Type</th>
                                        <th>Zones</th>
                                        <th>Base Fare</th>
                                        <th>Base km</th>
                                        <th>Additional KM Rate</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>

                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Product List end -->
    </div>
</main>

<script type="text/javascript">
    $(function() {

        $('.table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('get-fare') }}",
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                },
                {
                    data: 'type',
                    name: 'type'
                },
                {
                    data: 'zone',
                    name: 'zone'
                },
                {
                    data: 'base_fare',
                    name: 'base_fare'
                },
                {
                    data: 'base_km',
                    name: 'base_km'
                },
                {
                    data: 'additional_km',
                    name: 'additional_km'
                },

                {
                    data: 'action',
                    name: 'action'
                },

            ],
            "select": {
                'style': 'multi',
                'selector': 'td:first-child' //only checkbox can select row 
            },
        });
    });
</script>
@endsection