@extends('layouts.template')

@section('content')
  <style>
        #map { height: 500px; width: 100%; }
    </style>
    <script
  src="https://maps.googleapis.com/maps/api/js?key=AIzaSyABfBAX-v_a_99NqGylrBuo1mKPnZHx_Go&libraries=places,drawing,geometry&callback=initMap"
  async defer>
</script>
        <!-- Main Section start -->
        <main>
            
     <div class="container-fluid">

        <!-- Product List start -->
        <div class="row">

            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                    <h4>Edit {{$data->name}} Zone</h4>
                </div>
                    <div class="card-body px-5">
                        <div class="input-group flex-nowrap mb-3">
                              <span class="input-group-text b-r-left text-bg-danger" id="addon-wrapping1"><i class="ph-bold ph-map-pin"></i></span>
                                          <input id="searchInput" value="{{$data->name}}" class="form-control todo-inputs" type="text" placeholder="Search city or place" >
                                    </div>
                        <!-- <div class="mb-3">
                            
                        <input id="searchInput" class="form-control todo-inputs" type="text" placeholder="Search city or place" >
                        </div> -->
                        <div id="map"></div>
                         <form action="{{route('update-zone')}}" method="post" >
                                @csrf
                                <input type="hidden" name="id" value="{{$data->id}}">
                               <input type="hidden" name="name" id="place_name" value="{{$data->name}}">
                                <input type="hidden" name="coordinates" id="coordinates" value="{{$data->coordinates}}">
                                
                                                       <div class="col-lg-6 col-md-6 mt-3">
                                                        <div class="input-block mb-3">
                                                            <label>STATUS</label>
                                                            <select class="form-control" name="status">
                                                            <option name="ACTIVE" {{ $data->status == 'ACTIVE' ? 'selected' : '' }}>ACTIVE</option>
                                                            <option name="BLOCKED" {{ $data->status == 'BLOCKED' ? 'selected' : '' }}>BLOCKED</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                 <div class="mt-3">
                                <button type="submit" class="btn btn-primary">Save Zone</button>
                            </div>
                     </form>
                </div>
            </div>
        </div>
        <!-- Product List end -->
    </div>
        </main>
      
   
    <script>
        let map, autocomplete, marker, polygon;

        function initMap() {
            map = new google.maps.Map(document.getElementById('map'), {
                center: { lat: 10.0159, lng: 76.3419 },
                zoom: 10
            });

            autocomplete = new google.maps.places.Autocomplete(document.getElementById('searchInput'), {
                types: ['(cities)'] // Limit to cities
            });

            autocomplete.addListener('place_changed', function () {
                const place = autocomplete.getPlace();

                if (!place.geometry || !place.geometry.viewport) {
                    alert("No boundary data available for this place.");
                    return;
                }

                // Clear previous polygon
                if (polygon) polygon.setMap(null);

                // Use geometry.viewport as boundary
                const ne = place.geometry.viewport.getNorthEast();
                const sw = place.geometry.viewport.getSouthWest();

                const boundsCoords = [
                    { lat: ne.lat(), lng: sw.lng() },
                    { lat: ne.lat(), lng: ne.lng() },
                    { lat: sw.lat(), lng: ne.lng() },
                    { lat: sw.lat(), lng: sw.lng() }
                ];

                polygon = new google.maps.Polygon({
                    paths: boundsCoords,
                    strokeColor: "#FF0000",
                    strokeOpacity: 0.8,
                    strokeWeight: 2,
                    fillColor: "#FF0000",
                    fillOpacity: 0.35,
                    map: map,
                    editable: true
                });

                map.fitBounds(place.geometry.viewport);

                // Set hidden fields
                document.getElementById('place_name').value = place.formatted_address || place.name;
                document.getElementById('coordinates').value = JSON.stringify(boundsCoords);
            });
        }

        window.onload = initMap;
    </script>
  @endsection
