@extends('layouts.template')

@section('content')

<!-- Main Section start -->
<main>
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12 ">
                <h4 class="main-title">{{$data->title}} : Booking ID- {{$data->booking_id}}
                    <a href="{{route('trip.invoice.download',['id'=>$data->booking_id])}}" class="position-relative bg-light-primary px-2 py-1 b-r-10">
                        <i class="ph-fill  ph-download"></i> Invoice
                        <span class="position-absolute top-0 start-100 translate-middle p-1 bg-primary rounded-circle animate__animated animate__fadeIn animate__infinite animate__fast"></span>
                    </a>
                </h4>
                <div style="float:right;    margin-top: -30px;">
                    @can('change-booking-status')
                    <button type="button" class="btn btn-primary btn-xs " data-bs-toggle="modal"
                        data-bs-target="#changestatus"><i class="ti ti-plus"></i>Change Status</button>
                    @endcan
                    @can('add-trip-lifecycle')
                    <a href="{{route('add-trip-lifecycle',['id'=>$data->booking_id])}}" class="btn btn-danger btn-xs "><i class="ti ti-plus"></i> Add Trip LifeCycle</a>
                    @endcan
                    @can('assign-driver')
                    <button type="button" class="btn btn-success btn-xs " data-bs-toggle="modal"
                        data-bs-target="#brand"><i class="ti ti-plus"></i> Assign Driver</button>
                    @endcan
                </div>
                <div class="row mb-3">
                    <div class="col-md-4 mt-2 d-flex align-items-center gap-2">
                        <p class="f-w-600 mb-0">Overall Rating: </p>:
                        <div class="rating ">
                            @for($i=1;$i<=$data->overall_review_rate;$i++)
                                <input type="radio" id="star15" name="ratings2" value="15" checked="" disabled="">
                                <label class="star" for="star15"><span class="ti ti-star-filled f-s-20 text-warning"></span></label>
                                @endfor
                                @for($i=1;$i<=5-$data->overall_review_rate;$i++)
                                    <input type="radio" id="star14" name="ratings2" value="14" disabled="">
                                    <label class="star" for="star14"><span class="ti ti-star f-s-20 text-warning"></span></label>
                                    @endfor

                        </div>
                        <div>
                        </div>
                    </div>

                    <div class="col-md-4 mt-2 d-flex align-items-center gap-2">
                        <p class="f-w-600 mb-0">Driver Rating:: </p>:
                        <div class="rating ">
                            @for($i=1;$i<=$data->driver_rating;$i++)
                                <input type="radio" id="star15" name="ratings2" value="15" checked="" disabled="">
                                <label class="star" for="star15"><span class="ti ti-star-filled f-s-20 text-warning"></span></label>
                                @endfor
                                @for($i=1;$i<=5-$data->driver_rating;$i++)
                                    <input type="radio" id="star14" name="ratings2" value="14" disabled="">
                                    <label class="star" for="star14"><span class="ti ti-star f-s-20 text-warning"></span></label>
                                    @endfor

                        </div>
                        <div>
                        </div>
                    </div>

                    <div class="col-md-4 mt-2 d-flex align-items-center gap-2 text-end">
                        <p class="f-w-600 mb-0">Cab Rating:: </p>:
                        <div class="rating ">
                            @for($i=1;$i<=$data->car_rating;$i++)
                                <input type="radio" id="star15" name="ratings2" value="15" checked="" disabled="">
                                <label class="star" for="star15"><span class="ti ti-star-filled f-s-20 text-warning"></span></label>
                                @endfor
                                @for($i=1;$i<=5-$data->car_rating;$i++)
                                    <input type="radio" id="star14" name="ratings2" value="14" disabled="">
                                    <label class="star" for="star14"><span class="ti ti-star f-s-20 text-warning"></span></label>
                                    @endfor
                                    <div>
                                    </div>
                        </div>


                    </div>


                </div>
            </div>
            <!-- Breadcrumb end -->
            <!-- Project Details start -->
            <div class="row">
                <div class="col-md-6 col-xxl-4 order-md-2 order-xxl-1">
                    <!-- Project Details -->
                    <div class="card">
                        <div class="card-header">
                            <h5>User Details</h5>
                        </div>
                        <div class="card-body">
                            <table class=" project-details-table table table-borderless  align-middle mb-0">
                                <tbody>
                                    <tr>
                                        <td>
                                            <p class="f-w-600 mb-0">Booked By</p>
                                        </td>
                                        <td class="text-end">
                                            {{$data->role}}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p class="f-w-600 mb-0">Client Name:</p>
                                        </td>
                                        <td class="text-end">
                                            {{$data->client_name}}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p class="f-w-600 mb-0">Client Mobile Number: </p>
                                        </td>
                                        <td class="text-end"><span class="text-primary">{{$data->client_mobile_number}}</span>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>
                                            <p class="f-w-600 mb-0">Client Email</p>
                                        </td>
                                        <td class="text-end"><span class="text-danger">{{$data->client_email}}</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p class="f-w-600 mb-0">Adults:</p>
                                        </td>
                                        <td class="text-end">
                                            {{$data->adults}}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p class="f-w-600 mb-0">children: </p>
                                        </td>
                                        <td class="text-end"><span class="text-primary">{{$data->children}}</span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!--end  Project Details -->

                    <!-- Project Team -->

                    <div class="card ">
                        <div class="card-header">
                            <h5 class="header-title-text">Agency Details</h5>
                        </div>
                        <div class="card-body">
                            <table class=" project-details-table table table-borderless  align-middle mb-0">
                                <tbody>
                                    <tr>
                                        <td>
                                            <p class="f-w-600 mb-0">Vendor : </p>
                                        </td>
                                        <td class="text-end">
                                            <a href="{{route('view-vendor',['id'=>$data->vendor_id])}}">
                                                <img src=" {{$data->cab_agency_details->vendor_image}}" alt="" class="img-fluid h-35 w-35">
                                            </a>
                                        </td>
                                        <td class="text-end">
                                            <a href="{{route('view-vendor',['id'=>$data->vendor_id])}}">
                                                {{$data->cab_agency_details->vendor_name}}
                                            </a>
                                        </td>
                                    </tr>
                                    @if($driver!=null)
                                    <tr>
                                        <td>
                                            <p class="f-w-600 mb-0">Driver :</p>
                                        </td>
                                        <td class="text-end">

                                            <a href="{{route('view-driver',['id'=>$data->driver_id])}}">
                                                <img src=" {{$driver->image}}" alt="" class="img-fluid h-35 w-35">
                                            </a>
                                        </td>
                                        <td class="text-end">
                                            <a href="{{route('view-driver',['id'=>$data->driver_id])}}">
                                                {{$driver->name}}
                                            </a>
                                        </td>
                                    </tr>
                                    @endif
                                    <tr>
                                        <td>
                                            <p class="f-w-600 mb-0">Cab Model: </p>
                                        </td>

                                        <td class="text-end">

                                            <ul class="avatar-group justify-content-end">
                                                @for($i=0;$i<count($data->cab_agency_details->image);$i++)
                                                    <li class="text-bg-danger h-30 w-30 d-flex-center b-r-50">
                                                        <img src=" {{$data->cab_agency_details->image[$i]}}" alt="" class="img-fluid h-35 w-35">
                                                    </li>
                                                    @endfor

                                            </ul>
                                        </td>
                                        <td class="text-end"><span class="text-primary">
                                                {{$data->cab_agency_details->model}}</span>
                                            <br>
                                            {{$data->cab_agency_details->plate_number}}
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>
                                            <p class="f-w-600 mb-0">Review Comment:</p>
                                        </td>
                                        <td class="text-end">
                                            {{$data->comment}}
                                        </td>
                                    </tr>

                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!--end Project Team -->

                </div>
                <div class="col-xxl-5 order-xxl-2">
                    <!-- project activity -->
                    <div class="card">
                        <div class="card-header">
                            <h5> Trip Location Details</h5>
                        </div>
                        <div class="card-body">
                            <ul class="app-timeline-box">
                                <li class="timeline-section">
                                    <div class="timeline-icon">
                                        <span class="text-light-success h-35 w-35 d-flex-center b-r-50">
                                            <i class="ph-bold ph-map-pin"></i>
                                        </span>
                                    </div>
                                    <div class="timeline-content pt-0 ">
                                        <div class="d-flex f-s-16">
                                            <p class="text-success f-s-16 mb-0">{{$data->pick_up}}</p>
                                        </div>
                                        <p class="">
                                            {{$data->departure_date}} {{$data->departure_time}}
                                        </p>
                                    </div>
                                </li>
                                <li class="timeline-section">
                                    <div class="timeline-icon">
                                        <span class="text-light-danger h-35 w-35 d-flex-center b-r-50">
                                            <i class="ph-bold ph-map-pin"></i>
                                        </span>
                                    </div>
                                    <div class="timeline-content pt-0 ">
                                        <div class="d-flex f-s-16">
                                            <p class="text-danger f-s-16 mb-0">{{$data->drop_off}}</p>

                                        </div>
                                        <p class="">
                                            {{$data->return_date}} {{$data->return_time}}
                                        </p>
                                    </div>
                                </li>

                            </ul>

                            <div class="card-header">
                                <h5> Stay/Days Details</h5>
                            </div>
                            <ul class="app-timeline-box">
                                @for($i=0;$i< count($data->stay_date);$i++)

                                    <li class="timeline-section">
                                        <div class="timeline-icon">
                                            <span class="text-light-warning h-35 w-35 d-flex-center b-r-50">
                                                <i class="ph-bold ph-map-pin"></i>
                                            </span>
                                        </div>
                                        <div class="timeline-content pt-0 ">
                                            <div class="d-flex f-s-16">
                                                <p class="text-warning f-s-16 mb-0">Day {{$i+1}} : {{$data->stay_date[$i]}}</p>
                                            </div>
                                            <p class="">
                                                {{$data->stay_locations[$i]}}
                                            </p>
                                        </div>
                                    </li>
                                    @endfor

                            </ul>

                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header">
                            <h5>Payment Details</h5>
                        </div>
                        <div class="card-body">
                            <table class=" project-details-table table table-borderless  align-middle mb-0">
                                <tbody>
                                    <tr>
                                        <td class="pb-0">
                                            <p class="f-w-600 mb-0">Payment Status</p>
                                        </td>
                                        <td class="text-end pb-0">
                                            @if($data->booking_status=='authorized')
                                            <span class="badge text-bg-primary b-r-10">{{$data->booking_status }}</span>
                                            @elseif($data->booking_status=='captured')
                                            <span class="badge text-bg-success b-r-10">{{$data->booking_status }}</span>
                                            @else
                                            <span class="badge text-bg-danger b-r-10">{{$data->booking_status }}</span>
                                            @endif

                                        </td>
                                    </tr>

                                    <tr>
                                        <td>
                                            <p class="f-w-600 mb-0">Order Id</p>
                                        </td>
                                        <td class="text-end">
                                            <h6><span class="text-info"> {{$data->razorpay_order_id}}</span></h6>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p class="f-w-600 mb-0">Payment ID</p>
                                        </td>
                                        <td class="text-end">
                                            {{$data->payment_id}}
                                        </td>
                                    </tr>



                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- end project activity -->
                </div>


                <div class="col-md-6 col-xxl-3 order-md-1 order-xxl-3">
                    <!-- About project -->
                    <div class="card">
                        <div class="card-header">
                            <h5>Trip Details</h5>
                        </div>
                        <div class="card-body">
                            <table class=" project-details-table table table-borderless  align-middle mb-0">
                                <tbody>
                                    <tr>
                                        <td class="pb-0">
                                            <p class="f-w-600 mb-0">Booking Status</p>
                                        </td>
                                        <td class="text-end pb-0">
                                            @if($data->booking_status=='Upcoming')
                                            <span class="badge text-bg-warning b-r-10">{{$data->booking_status }}</span>
                                            @elseif($data->booking_status=='Confirmed')
                                            <span class="badge text-bg-info b-r-10">{{$data->booking_status }}</span>
                                            @elseif($data->booking_status=='Running')
                                            <span class="badge text-bg-primary b-r-10">{{$data->booking_status }}</span>
                                            @elseif($data->booking_status=='Completed')
                                            <span class="badge text-bg-success b-r-10">{{$data->booking_status }}</span>
                                            @elseif($data->booking_status=='Canceled')
                                            <span class="badge text-bg-danger b-r-10">{{$data->booking_status }}</span>
                                            @endif

                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pb-0">

                                            <p class="f-w-600 mb-0">Payment Status</p>
                                        </td>
                                        <td class="text-end pb-0">
                                            @if($data->payment_status=='Unpaid')
                                            <span class="badge text-bg-light">{{$data->payment_status }}</span>
                                            @else
                                            <span class="badge text-bg-success">{{$data->payment_status }}</span>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p class="f-w-600 mb-0">Total KM</p>
                                        </td>
                                        <td class="text-end">
                                            <h6><span class="text-info"> {{$data->total_km}}</span></h6>

                                        </td>
                                    </tr>

                                    @if($data->role=='Partner')
                                    <tr>
                                        <td>
                                            <p class="f-w-600 mb-0">commission Rate</p>
                                        </td>
                                        <td class="text-end">{{$data->commission_rate}}
                                        </td>
                                    </tr>
                                    @endif
                                    <tr>
                                        <td class="pb-0">
                                            <p class="f-w-600 mb-0">Tax</p>
                                        </td>
                                        <td class="text-end pb-0">
                                            <h6>{{$data->tax }}</h6>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pb-0">
                                            <p class="f-w-600 mb-0">total_fare</p>
                                        </td>
                                        <td class="text-end pb-0">
                                            <h6>{{$data->total_fare }}</h6>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pb-0">
                                            <p class="f-w-600 mb-0">Platform Fee</p>
                                        </td>
                                        <td class="text-end pb-0">
                                            <h6>{{$data->platform_fee }}</h6>
                                        </td>
                                    </tr>
                                    @if($data->booking_status!='Completed')
                                    <tr>
                                        <td class="pb-0">
                                            <p class="f-w-600 mb-0">Paid Amount</p>
                                        </td>
                                        <td class="text-end pb-0">
                                            <h6><span class="text-danger">{{$data->paid_amount }}</span></h6>
                                        </td>
                                    </tr>
                                    @endif
                                    @if($data->booking_status=='Completed')
                                    <tr style="border-top:2px solid #eee;">
                                        <td class="pb-0">
                                            <p class="f-w-600 mb-0">Total Km traveled</p>
                                        </td>
                                        <td class="text-end pb-0">
                                            <h6><span class="text-success">{{$data->total_km_driven }}</span></h6>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pb-0">
                                            <p class="f-w-600 mb-0">Extra KM charge</p>
                                        </td>
                                        <td class="text-end pb-0">
                                            <h6><span class="text-warning">{{$data->extra_km_charge }}</span></h6>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pb-0">
                                            <p class="f-w-600 mb-0">Total extra charges</p>
                                        </td>
                                        <td class="text-end pb-0">
                                            <h6><span> {{App\Models\TripLifeCycle::where('booking_id',$data->id)->sum('additional_charge_collected') }}</span></h6>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pb-0">
                                            <p class="f-w-600 mb-0">Total collected amount</p>
                                        </td>
                                        <td class="text-end pb-0">
                                            <h6><span class="text-danger">- {{App\Models\TripLifeCycle::where('booking_id',$data->id)->sum('amount_collected') }}</span></h6>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pb-0">
                                            <p class="f-w-600 mb-0">Paid Amount</p>
                                        </td>
                                        <td class="text-end pb-0">
                                            <h6><span class="text-danger">- {{$data->paid_amount }}</span></h6>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="pb-0">
                                            <p class="f-w-600 mb-0">Balance amount</p>
                                        </td>
                                        <td class="text-end pb-0">
                                            <h6><span class="text-warning">{{$data->balance_amount }}</span></h6>
                                        </td>
                                    </tr>


                                    @endif


                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- about project end  -->

                </div>
            </div>
            <!-- Project Details end -->
        </div>

        <!-- **** trip life cycle ************ -->

        <div class="row">

            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Trip Lifecycle</h4>

                    </div>
                    @php
                    $raw = $lifecycle->stay_date; // The double-encoded JSON string

                    $firstDecode = json_decode($raw, true); // returns a JSON string
                    $dates = json_decode($firstDecode, true); // returns the actual PHP array

                    $raw = $lifecycle->stay_locations; // The double-encoded JSON string
                    $firstDecode = json_decode($raw, true); // returns a JSON string
                    $locationsArray = json_decode($firstDecode, true); // returns the actual PHP array

                    $existing = $existingLifeCycles ?? collect();
                    @endphp
                    <div class="card-body px-5">

                        <div class="row">
                            <ul class="app-timeline-box">
                                @for($i = 0; $i < count($dates); $i++)
                                    @php
                                    $dateString=\Carbon\Carbon::parse($dates[$i])->format('Y-m-d');
                                    $lifecycle = $existing->get($dateString);
                                    @endphp

                                    <li class="timeline-section">
                                        <div class="timeline-icon">
                                            <span class="text-light-primary h-55 w-55 d-flex-center b-r-50">
                                                Day {{$i+1}}
                                            </span>
                                        </div>
                                        <div class="timeline-content pt-0">
                                            <div class="d-block f-s-16">
                                                <p class="text-info f-s-18 mb-0">{{$dates[$i]}}
                                                    <span class="badge text-outline-success f-s-16 mb-0">{{$locationsArray[$i]}}</span>
                                                    <span class="badge text-outline-danger f-s-16 mb-0">Actual KM : {{$lifecycle->actual_km}}</span>
                                                </p>
                                                <div class="row app-timeline-info-text timeline-border-box me-2 ms-0 mt-3 p-3">
                                                    <div class="col-md-4">
                                                        <div class="mb-3">

                                                            <label class="form-label">Starting meter Reading</label>
                                                            <input type="text" disabled class="form-control" value="{{ $lifecycle->starting_meter_reading ?? '' }}">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3">
                                                            <label class="form-label">Ending meter Reading</label>
                                                            <input type="text" disabled class="form-control" value="{{ $lifecycle->ending_meter_reading ?? '' }}">
                                                        </div>
                                                    </div>
                                                    <div class="col-4">
                                                        <div class="mb-3">
                                                            <label class="form-label">Additional Charge Collected</label>
                                                            <input type="text" disabled class="form-control" value="{{ $lifecycle->additional_charge_collected ?? '' }}">
                                                        </div>
                                                    </div>
                                                    <div class="col-12">
                                                        <div class="mb-3">
                                                            <label class="form-label">Note</label>
                                                            <textarea disabled class="form-control">{{ $lifecycle->note ?? '' }}</textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                    @endfor


                            </ul>


                        </div>


                    </div>

                </div>
            </div>
        </div>

</main>

<div class="modal fade" id="brand" tabindex="-1" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <form action="{{route('assign-driver')}}" method="post">
        @csrf
        <div class="modal-dialog modal-dialog-centered" id="staticBackdrop">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title f-w-500 fs-5" id="exampleModalLabel1">Assign Driver</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body app-form">

                    <div class="mb-3" id="newtask">
                        <label class="form-label">Select Driver</label>
                        <input type="hidden" value="{{$data->id}}" name="booking_id">
                        <select class="form-control todo-inputs" name="driver_id">

                            @foreach($availableDrivers as $item)
                            <option value="{{$item->id}}" {{ $data->driver_id == $item->id ? 'selected' : '' }}>{{$item->name}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="filebox mt-3" id="newtask">
                        <p class=" f-s-16 text-danger mb-0">Note: When a vendor is assigned, the booking status automatically changes to “Confirmed.” </p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-primary" type="submit" id="push"
                        data-bs-dismiss="modal">Save changes</button>
                </div>
            </div>
        </div>
    </form>
</div>


<div class="modal fade" id="changestatus" tabindex="-1" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <form action="{{route('change-booking-status')}}" method="post">
        @csrf
        <div class="modal-dialog modal-dialog-centered" id="staticBackdrop">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title f-w-500 fs-5" id="exampleModalLabel1">Change Booking Status</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body app-form">

                    <div class="mb-3" id="newtask">
                        <label class="form-label">Select Booking Status</label>
                        <input type="hidden" value="{{$data->id}}" name="booking_id">
                        <select class="form-control todo-inputs" name="booking_status">
                            <option value="Upcoming" {{ $data->booking_status == 'Upcoming' ? 'selected' : 'Upcoming' }}>Upcoming</option>
                            <option value="Confirmed" {{ $data->booking_status == 'Confirmed' ? 'selected' : 'Confirmed' }}>Confirmed</option>
                            <option value="Running" {{ $data->booking_status == 'Running' ? 'selected' : 'Running' }}>Running</option>
                            <option value="Completed" {{ $data->booking_status == 'Completed' ? 'selected' : 'Completed' }}>Completed</option>
                            <option value="Canceled" {{ $data->booking_status == 'Canceled' ? 'selected' : 'Canceled' }}>Canceled</option>
                        </select>
                    </div>


                </div>
                <div class="modal-footer">
                    <button class="btn btn-primary" type="submit" id="push"
                        data-bs-dismiss="modal">Save changes</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection