<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('booking_histories', function (Blueprint $table) {
                $table->id();
                $table->string('booking_id')->unique();
                $table->integer('vendor_id');
                $table->integer('vehicle_id');
                $table->integer('driver_id');
                $table->integer('booked_user_id');
                $table->string('role');
                $table->decimal('total_km', 10, 2);
                $table->date('departure_date');
                $table->date('return_date');     
                $table->string('departure_time');
                $table->string('return_time');
                $table->string('pick_up');       
                $table->string('drop_off');  
                $table->json('stay_date')->nullable();    
                $table->json('stay_locations')->nullable();        // after base distance
                $table->integer('adults');               
                $table->integer('children');  
                $table->string('client_name');
                $table->string('client_mobile_number');
                $table->string('client_email');  
                $table->decimal('commission_rate', 10, 2)->default('0');
                $table->decimal('tax', 10, 2)->default('0');
                $table->decimal('total_fare', 10, 2)->default('0');
                $table->decimal('platform_fee', 10, 2)->default('0');
                $table->decimal('paid_amount', 10, 2)->default('0');
                $table->string('booking_status')->default('Upcoming');  
                $table->string('payment_status')->default('Unpaid');  
                $table->string('payment_id')->nullable();   
                 $table->integer('overall_review_rate')->default('0');  
                $table->timestamp('created_at')->useCurrent();
                $table->timestamp('updated_at')->nullable()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('booking_histories');
    }
};
