<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\Vehicle;
/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Vehicle>
 */
class VehicleFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */

     protected $model = Vehicle::class;

    public function definition(): array
    {
        return [
        'vendor_id' => $this->faker->numberBetween(1, 10),
            'driver_id' => $this->faker->numberBetween(1, 10),
            'vehicle_id' => $this->faker->unique()->numberBetween(1000, 9999),
            'model' => $this->faker->numberBetween(1, 20),
            'vehicle_make' => $this->faker->company(),
            'year_of_registration' => $this->faker->year(),
            'seats' => $this->faker->numberBetween(2, 7),
            'color' => $this->faker->safeColorName(),
            'fuel_type' => $this->faker->randomElement(['Petrol', 'Diesel', 'CNG', 'Electric']),
            'plate_number' => strtoupper($this->faker->unique()->bothify('??## ??####')),
            'reg_validity' => $this->faker->dateTimeBetween('now', '+5 years')->format('Y-m-d'),
            'insurance_validity' => $this->faker->dateTimeBetween('now', '+5 years')->format('Y-m-d'),
            'tax_validity' => $this->faker->dateTimeBetween('now', '+5 years')->format('Y-m-d'),
            'is_available' => $this->faker->randomElement(['Available', 'Booked', 'Maintenance']),
            'image' => json_encode([$this->faker->imageUrl(), $this->faker->imageUrl()]),
            'status' => 'ACTIVE',
        ];
    }
}
