<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Zone;
use App\Models\Vendors;
use App\Models\Driver;
use Yajra\DataTables\Facades\DataTables;

class VendorController extends Controller
{
    //*********************************** vendor  section start *****************************/

    public function addvendor(Request $request)
    {
        //  print_r($request->all());die();
        $res = 1;
        $image = '';
        $licence_image = '';
        if ($request->photo) {
            $rand = rand(100, 999);
            $image = time() . '.' . $request->photo->extension();
            $imageOriginalName = $request->photo->getClientOriginalName();
            $request->photo->move(public_path('uploads/vendor/'), $image);
            if ($request->isdriver == 'on') {
                $request->photo->move(public_path('uploads/driver/'), $image);
            }
        }
        if ($request->licence) {
            $rand = rand(100, 999);
            $licence_image = time() . '.' . $request->licence->extension();
            $imageOriginalName = $request->licence->getClientOriginalName();
            $request->licence->move(public_path('uploads/driver/licence'), $licence_image);
        }


        $vendor = new Vendors();
        $vendor->name = $request->name;
        $vendor->email = $request->email;
        $vendor->phone = $request->phone;
        $vendor->address = $request->address;
        $vendor->district = $request->district;
        $vendor->state = $request->state;
        $vendor->country = $request->country;
        $vendor->postal_code = $request->postal_code;
        $vendor->vendor_image = $image;
        $vendor->zone = $request->zone_id;
        $vendor->add_driver_permission = $request->add_driver_permission;
        $vendor->save();

        if ($request->isdriver == 'on') {
            $vendorid = $vendor->id;
            Vendors::where('id', $vendorid)
                ->update([
                    'driver_also' => 'YES'
                ]);
            $res = Driver::insert([
                'vendor_id' => $vendorid,
                'name' => $request->name,
                'email' => $request->email,
                'phone' => $request->phone,
                'address' => $request->address,
                'district' => $request->district,
                'state' => $request->state,
                'country' => $request->country,
                'postal_code' => $request->postal_code,
                'licence_number' => $request->licence_number,
                'licence' => $licence_image,
                'image' => $image,
                'zone' => $request->zone_id
            ]);
        }

        if ($res == 1 || $vendor)
            return redirect()->back()->with('success', 'Vendor added successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function getvendor(Request $request)
    {
        if ($request->ajax()) {
            $data = Vendors::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('name', function ($data) {
                    return    '<a href="' . route('view-vendor', ['id' => $data->id]) . '" class="text-primary">' . $data->name . '</a>';
                })
                ->addColumn('phone', function ($data) {
                    return   $data->phone;
                })
                ->addColumn('address', function ($data) {
                    return   $data->address;
                })
                ->addColumn('zone', function ($data) {
                    return    Zone::where('id', $data->zone)->pluck('name')->first();
                })
                ->addColumn('status', function ($data) {
                    if ($data->status == 'BLOCKED')
                        return '<span class="badge text-light-danger"> ' . $data->status . '</span>';
                    else
                        return  '<span class="badge text-light-success">' . $data->status . '</span>';
                })

                ->addColumn('action', function ($data) {
                    $html = '';
                    if (auth()->user()->can('view-vendor')) {
                        $html .= '   <a href="' . route('view-vendor', ['id' => $data->id]) . '" class="btn btn-light-primary icon-btn b-r-4" ><i class="ti ti-eye text-primary"></i></a>';
                    }
                    if (auth()->user()->can('edit-vendor')) {
                        $html .= '    <a href="' . route('edit-vendor', ['id' => $data->id]) . '" class="btn btn-light-success icon-btn b-r-4" ><i class="ti ti-edit text-success"></i></a>';
                    }
                    if (auth()->user()->can('delete-vendor')) {
                        $html .= '        <a href="#" class="btn btn-light-danger icon-btn b-r-4 delete-btn" data-bs-toggle="modal" data-bs-target="#delete_discount' . $data->id . '"><i class="ti ti-trash"></i></a>
                        <div class="modal custom-modal fade" id="delete_discount' . $data->id . '" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content">
                <div class="modal-header border-0 justify-content-center pb-0">
                    <div class="form-header modal-header-title text-center mb-0">
                        <h4 class="mb-2">Delete Vendor</h4>
                        <p>Are you sure want to delete?</p>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="modal-btn delete-action">
                        <div class="row text-center">
                            <div class="col-12">
                                <a href="' . route('delete-vendor', ['id' => $data->id]) . '" 
                                    class="btn btn-primary paid-continue-btn">Delete</a>
                                      <a href="#" data-bs-dismiss="modal"
                                    class="btn btn-primary paid-cancel-btn">Cancel</a>
                            </div>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>                                            
    ';
                    }
                    return $html;
                })

                ->escapeColumns([])

                ->make(true);
        }
    }
    public function editvendor(Request $request)
    {
        $res = Vendors::where('id', $request->id)->first();
        return view('vendor.edit', ['data' => $res]);
    }
    public function viewVendor(Request $request)
    {
        $res = Vendors::where('id', $request->id)->first();
        return view('vendor.view', ['data' => $res]);
    }
    public function updatevendor(Request $request)
    {
        $res = Vendors::where('id', $request->id)
            ->update([

                'name' => $request->name,
                'email' => $request->email,
                'phone' => $request->phone,
                'address' => $request->address,
                'district' => $request->district,
                'state' => $request->state,
                'country' => $request->country,
                'postal_code' => $request->postal_code,
                'zone' => $request->zone_id,
                'status' => $request->status,
                'add_driver_permission' => $request->add_driver_permission,
                'driver_also' => $request->driver_also
            ]);
        $image = '';
        if ($request->photo) {
            $rand = rand(100, 999);
            $image = time() . '.' . $request->photo->extension();
            $imageOriginalName = $request->photo->getClientOriginalName();
            $request->photo->move(public_path('uploads/vendor/'), $image);
            Vendors::where('id', $request->id)->update(['vendor_image' => $image]);
        }
        if ($res == 1)
            return redirect()->back()->with('success', 'Vendor  updated successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function deletevendor(Request $request)
    {
        $res = Vendors::where('id', $request->id)->delete();
        if ($res == 1)
            return redirect()->back()->with('success', 'Vendor  deleted successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }
}
