<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Zone;
use App\Models\VehicleCategory;
use App\Models\Brand;
use App\Models\Settings;
use App\Models\Banners;
use App\Models\Driver;
use App\Models\Vendors;
use App\Models\Partner;
use App\Models\AccountDeleteRequest;
use App\Models\BrandVehicle;
use App\Models\FAQ;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Artisan;

class SettingsController extends Controller
{
    public function addZone(Request $request)
    {
        //    print_r($request->all());die();

        $res = Zone::insert([
            'name' => $request->name,
            'coordinates' => $request->coordinates
            // 'coordinates'=>json_decode($request->coordinates, true)
        ]);

        // return response()->json(['success' => true]);
        if ($res == 1)
            return redirect()->back()->with('success', 'Zone added successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }
    public function editZone(Request $request)
    {

        // Artisan::call('db:seed', [
        //     '--class' => 'PermissionTableSeeder',
        //      'guard_name' => 'web'
        // ]); die();
        $data = Zone::where('id', $request->id)->first();
        return view('edit-zone', ['data' => $data]);
    }

    public function updateZone(Request $request)
    {
        // print_r($request->all());die();
        $res = Zone::where('id', $request->id)
            ->update([
                'name' => $request->name,
                'coordinates' => $request->coordinates
                //  'status'=>$request->status,
            ]);
        if ($res == 1)
            return redirect()->back()->with('success', 'Zone updated successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function getZone(Request $request)
    {
        if ($request->ajax()) {
            $data = Zone::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('name', function ($data) {
                    return   $data->name;
                })

                ->addColumn('status', function ($data) {
                    if ($data->status == 'BLOCKED')
                        return '<span class="badge text-light-danger"> ' . $data->status . '</span>';
                    else
                        return  '<span class="badge text-light-success">' . $data->status . '</span>';
                })

                ->addColumn('action', function ($data) {
                    $html = '';
                    if (auth()->user()->can('edit-zone')) {
                        $html .= '           <a href="' . route('edit-zone', ['id' => $data->id]) . '" class="btn btn-light-success icon-btn b-r-4" ><i class="ti ti-edit text-success"></i></a>';
                    }
                    if (auth()->user()->can('delete-zone')) {
                        $html .= '   <a href="#" class="btn btn-light-danger icon-btn b-r-4 delete-btn" data-bs-toggle="modal" data-bs-target="#delete_discount"><i class="ti ti-trash"></i></a>
                                                                 
            <div class="modal custom-modal fade" id="delete_discount" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content">
                <div class="modal-header border-0 justify-content-center pb-0">
                    <div class="form-header modal-header-title text-center mb-0">
                        <h4 class="mb-2">Delete zone</h4>
                        <p>Are you sure want to delete?</p>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="modal-btn delete-action">
                        <div class="row text-center">
                            <div class="col-12">
                                <a href="' . route('delete-zone', ['id' => $data->id]) . '" 
                                    class="btn btn-primary paid-continue-btn">Delete</a>
                                      <a href="#" data-bs-dismiss="modal"
                                    class="btn btn-primary paid-cancel-btn">Cancel</a>
                            </div>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
                                                                ';
                    }
                    return $html;
                })

                ->escapeColumns([])

                ->make(true);
        }
    }


    public function deleteZone(Request $request)
    {

        $res = Zone::where('id', $request->id)->delete();
        if ($res == 1)
            return redirect()->back()->with('success', 'Zone deleted successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    //*********************************** vehicle category section start *****************************/

    public function addVehicleCategory(Request $request)
    {
        $image = '';

        if ($request->photo) {
            $rand = rand(100, 999);
            $image = time() . '.' . $request->photo->extension();
            $imageOriginalName = $request->photo->getClientOriginalName();
            $request->photo->move(public_path('uploads/category/'), $image);
        }
        $res = VehicleCategory::insert([
            'name' => $request->name,
            'image' => $image
        ]);
        if ($res == 1)
            return redirect()->back()->with('success', 'Vehicle Category added successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function getVehicleCategory(Request $request)
    {
        if ($request->ajax()) {
            $data = VehicleCategory::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('name', function ($data) {
                    return   $data->name;
                })
                ->addColumn('icon', function ($data) {
                    return   '<img src="' . asset("uploads/category/" . $data->image) . '" alt="" class="img-fluid" width="100px" height="100px">';
                })
                ->addColumn('status', function ($data) {
                    if ($data->status == 'BLOCKED')
                        return '<span class="badge text-light-danger"> ' . $data->status . '</span>';
                    else
                        return  '<span class="badge text-light-success">' . $data->status . '</span>';
                })

                ->addColumn('action', function ($data) {
                    $html = '';
                    if (auth()->user()->can('edit-vehicleCategory')) {
                        $html .= '           <a href="#" class="btn btn-light-success icon-btn b-r-4" data-bs-toggle="modal" data-bs-target="#add_discount' . $data->id . '"><i class="ti ti-edit text-success"></i></a>
                        <div class="modal fade" id="add_discount' . $data->id . '" tabindex="-1"
                 aria-hidden="true">
                <div class="modal-dialog app_modal_sm">
                    <div class="modal-content">
                        <div class="modal-header bg-primary-800">
                            <h1 class="modal-title fs-5 text-white" id="exampleModal2">EDIT ZONE</h1>
                            <button type="button" class="fs-5 border-0 bg-none  text-white" data-bs-dismiss="modal"
                                    aria-label="Close"><i class="fa-solid fa-xmark fs-3"></i></button>
                        </div>
                         <form action="' . route('edit-vehicleCategory') . '" method="post" enctype="multipart/form-data">
                        <div class="modal-body">
                              <div class="row">
                        <div class="col-lg-12 col-md-12">
                            <div class="input-block mb-3">
                              
                                <input type="hidden" class="form-control" name="_token" value="' . csrf_token() . '">
                                <input type="hidden" class="form-control" name="id" value="' . $data->id . '">
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12">
                            <div class="input-block mb-3">
                                <label>NAME</label>
                                <input type="text" class="form-control" name="name" value="' . $data->name . '" required>
                            </div>
                        </div>
                         <div class="col-lg-12 col-md-12">
                           <div class="mb-3" id="newtask">
                                                    <label class="form-label">Upload Icon</label>
                                                   <input type="file" class="form-control" name="photo" required>
                                                </div>
                        </div>
                          
                        <div class="col-lg-12 col-md-12">
                            <div class="input-block mb-3">
                                <label>STATUS</label>
                                <select class="form-control" name="status" required>
                                 <option name="' . $data->status . '">' . $data->status . '</option>
                                <option name="ACTIVE">ACTIVE</option>
                                <option name="BLOCKED">BLOCKED</option>
                                </select>
                            </div>
                        </div>
                    </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-light-secondary"
                                    data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-light-primary">Save changes</button>
                        </div>
                         </form>
                    </div>
                </div>
            </div>
';
                    }
                    if (auth()->user()->can('delete-vehicleCategory')) {
                        $html .= '   <a href="#" class="btn btn-light-danger icon-btn b-r-4 delete-btn" data-bs-toggle="modal" data-bs-target="#delete_discount"><i class="ti ti-trash"></i></a>
                                                                   <div class="modal custom-modal fade" id="delete_discount" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content">
                <div class="modal-header border-0 justify-content-center pb-0">
                    <div class="form-header modal-header-title text-center mb-0">
                        <h4 class="mb-2">Delete zone</h4>
                        <p>Are you sure want to delete?</p>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="modal-btn delete-action">
                        <div class="row text-center">
                            <div class="col-12">
                                <a href="' . route('delete-vehicleCategory', ['id' => $data->id]) . '" 
                                    class="btn btn-primary paid-continue-btn">Delete</a>
                                      <a href="#" data-bs-dismiss="modal"
                                    class="btn btn-primary paid-cancel-btn">Cancel</a>
                            </div>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div> ';
                    }

                    return $html;
                })

                ->escapeColumns([])

                ->make(true);
        }
    }

    public function editVehicleCategory(Request $request)
    {
        $res = VehicleCategory::where('id', $request->id)
            ->update([
                'name' => $request->name,
                'status' => $request->status,
            ]);
        if ($request->photo) {
            $data = VehicleCategory::where('id', $request->id)->first();
            if ((file_exists(public_path('uploads/category/' . $data->image))) && ($data->image != NULL)) {
                unlink("uploads/category/" . $data->image);
            }
            $rand = rand(100, 999);
            $image = time() . '.' . $request->photo->extension();
            $imageOriginalName = $request->photo->getClientOriginalName();
            $request->photo->move(public_path('uploads/category/'), $image);


            $res = VehicleCategory::where('id', $request->id)
                ->update(['image' => $image]);
        }
        if ($res == 1)
            return redirect()->back()->with('success', 'Vehicle Category updated successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function deleteVehicleCategory(Request $request)
    {
        $data = VehicleCategory::where('id', $request->id)->first();
        if ((file_exists(public_path('uploads/category/' . $data->image))) && ($data->image != NULL)) {
            unlink("uploads/category/" . $data->image);
        }
        $res = VehicleCategory::where('id', $request->id)->delete();
        if ($res == 1)
            return redirect()->back()->with('success', 'Vehicle Category deleted successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    //*********************************** vehicle category section end*****************************/


    //*********************************** brand section start *****************************/

    public function addbrand(Request $request)
    {
        $res = Brand::insert(['name' => $request->name]);
        if ($res == 1)
            return redirect()->back()->with('success', 'Brand added successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function addbrandmodel(Request $request)
    {

        $res = BrandVehicle::insert([
            'vehicle_type' => $request->vehicle_type,
            'brand' => $request->brand,
            'model_name' => $request->model_name,
            'min_passengers' => $request->min_passengers,
            'max_passengers' => $request->max_passengers,
            //  'base_fare'=>$request->base_fare,
            // 'fare_per_km'=>$request->fare_per_km ,
        ]);
        if ($res == 1)
            return redirect()->back()->with('success', 'Model added successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function getbrandmodel(Request $request)
    {
        if ($request->ajax()) {
            $data = BrandVehicle::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('name', function ($data) {
                    return   $data->model_name;
                })
                ->addColumn('brand', function ($data) {
                    return  Brand::where('id', $data->brand)->pluck('name')->first();
                })
                ->addColumn('type', function ($data) {
                    return  VehicleCategory::where('id', $data->vehicle_type)->pluck('name')->first();
                })
                ->addColumn('min', function ($data) {
                    return   $data->min_passengers;
                })
                ->addColumn('max', function ($data) {
                    return   $data->max_passengers;
                })
                //      ->addColumn('base_fare', function ($data) {
                //     return   $data->base_fare	;
                // })
                //     ->addColumn('per_km', function ($data) {
                //     return   $data->fare_per_km;
                // })
                ->addColumn('action', function ($data) {
                    $html = '';
                    if (auth()->user()->can('edit-brandmodel')) {
                        $html .= '<a href="#" class="btn btn-light-success icon-btn b-r-4" data-bs-toggle="modal" data-bs-target="#add_discount' . $data->id . '"><i class="ti ti-edit text-success"></i></a>
                    <div class="modal fade" id="add_discount' . $data->id . '" tabindex="-1"
                 aria-hidden="true">
                <div class="modal-dialog app_modal_sm">
                    <div class="modal-content">
                        <div class="modal-header bg-primary-800">
                            <h1 class="modal-title fs-5 text-white" id="exampleModal2">EDIT ZONE</h1>
                            <button type="button" class="fs-5 border-0 bg-none  text-white" data-bs-dismiss="modal"
                                    aria-label="Close"><i class="fa-solid fa-xmark fs-3"></i></button>
                        </div>
                         <form action="' . route('edit-brandmodel') . '" method="post" enctype="multipart/form-data">
                          <div class="modal-body app-form">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                         <input type="hidden" class="form-control" name="_token" value="' . csrf_token() . '">
                                                        <input type="hidden" class="form-control" name="id" value="' . $data->id . '">
                                                            <label class="form-label">Vehicle Type</label>
                                                            <select class="form-control" name="vehicle_type" required>
                                                                <option value="' . VehicleCategory::where('id', $data->vehicle_type)->pluck('id')->first() . '">' . VehicleCategory::where('id', $data->vehicle_type)->pluck('name')->first() . '</option>';
                        foreach (VehicleCategory::where('status', 'ACTIVE')->get() as $item) {
                            $html .= '<option value="' . $item->id . '">' . $item->name . '</option>';
                        }
                        $html .= '                               </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Brand </label>
                                                          <select class="form-control" name="brand" required>
                                                                <option value="' . Brand::where('id', $data->brand)->pluck('id')->first() . '">' . Brand::where('id', $data->brand)->pluck('name')->first() . '</option>';
                        foreach (Brand::get() as $item) {
                            $html .= ' <option value="' . $item->id . '">' . $item->name . '</option>';
                        }
                        $html .= '   </select>
                                                        </div>
                                                    </div>
                                                     </div>
                                                     
                                                    <div class="col-md-12">
                                                        
                                                        <div class="mb-3">
                                                            <label class="form-label">Model Name </label>
                                                          <input type="text" class="form-control" name="model_name" value="' . $data->model_name . '" required>
                                                        </div>
                                                    </div>
                                                    
                                                      <div class="row">
                                                    <div class="col-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Minimum Passengers</label>
                                                            <input type="number" name="min_passengers" class="form-control" value="' . $data->min_passengers . '" required>
                                                        </div>
                                                    </div>

                                                     <div class="col-6">
                                                        <div class="mb-3">
                                                            <label class="form-label">Maximum Passengers</label>
                                                            <input type="number" name="max_passengers" required class="form-control" value="' . $data->max_passengers . '" required>
                                                         
                                                        </div>
                                                    </div>
                                                    </div>
                             
                    </div>
                       
                        <div class="modal-footer">
                            <button type="button" class="btn btn-light-secondary"
                                    data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-light-primary">Save changes</button>
                        </div>
                         </form>
                    </div>
                </div>
            </div>';
                    }
                    if (auth()->user()->can('delete-brandmodel')) {
                        $html .= ' <a href="#" class="btn btn-light-danger icon-btn b-r-4 delete-btn" data-bs-toggle="modal" data-bs-target="#delete_discount"><i class="ti ti-trash"></i></a>
                                                                 
       <div class="modal custom-modal fade" id="delete_discount" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content">
                <div class="modal-header border-0 justify-content-center pb-0">
                    <div class="form-header modal-header-title text-center mb-0">
                        <h4 class="mb-2">Delete zone</h4>
                        <p>Are you sure want to delete?</p>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="modal-btn delete-action">
                        <div class="row text-center">
                            <div class="col-12">
                                <a href="' . route('delete-brandmodel', ['id' => $data->id]) . '" 
                                    class="btn btn-primary paid-continue-btn">Delete</a>
                                      <a href="#" data-bs-dismiss="modal"
                                    class="btn btn-primary paid-cancel-btn">Cancel</a>
                            </div>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
                                                                ';
                    }
                    return $html;
                })

                ->escapeColumns([])

                ->make(true);
        }
    }

    public function editbrandmodel(Request $request)
    {
        $res = BrandVehicle::where('id', $request->id)
            ->update([
                'vehicle_type' => $request->vehicle_type,
                'brand' => $request->brand,
                'model_name' => $request->model_name,
                'min_passengers' => $request->min_passengers,
                'max_passengers' => $request->max_passengers,
                // 'base_fare'=>$request->base_fare,
                // 'fare_per_km'=>$request->fare_per_km ,
            ]);

        if ($res == 1)
            return redirect()->back()->with('success', 'Model updated successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function deletebrandmodel(Request $request)
    {

        $res = BrandVehicle::where('id', $request->id)->delete();
        if ($res == 1)
            return redirect()->back()->with('success', 'Data deleted successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }


    public function updatesettings(Request $request)
    {
        $res = Settings::where('id', $request->id)
            ->update([
                'tax' => $request->tax,
                'additional_km' => $request->additional_km,
                'platform_fee' => $request->platform_fee,
                'privacy_policy' => $request->privacy_policy,
                'terms_and_condition' => $request->terms_and_condition,
                'contact_us' => $request->contact_us,
                'email' => $request->email,
                'phone' => $request->phone,
                'razor_key_id' => $request->razor_key_id,
                'razor_key_secret' => $request->razor_key_secret,

            ]);
        if ($res == 1)
            return redirect()->back()->with('success', 'Settings updated successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    //*********************************** Banner section start *****************************/

    public function addbanners(Request $request)
    {
        $image = '';

        if ($request->photo) {
            $rand = rand(100, 999);
            $image = time() . '.' . $request->photo->extension();
            $imageOriginalName = $request->photo->getClientOriginalName();
            $request->photo->move(public_path('uploads/banner/'), $image);
        }
        $res = Banners::insert([
            'link' => $request->link,
            'photo' => $image
        ]);
        if ($res == 1)
            return redirect()->back()->with('success', 'Banner added successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function getbanners(Request $request)
    {
        if ($request->ajax()) {
            $data = Banners::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('link', function ($data) {
                    return  '<a href="' . $data->link . '" target="_blank"> ' . $data->link . '</a>';
                })
                ->addColumn('banner', function ($data) {
                    return   '<img src="' . asset("uploads/banner/" . $data->photo) . '" alt="" class="img-fluid" width="100px" height="100px">';
                })

                ->addColumn('action', function ($data) {

                    if (auth()->user()->can('delete-banners')) {
                        return   '         
                                                                <a href="#" class="btn btn-light-danger icon-btn b-r-4 delete-btn" data-bs-toggle="modal" data-bs-target="#delete_discount"><i class="ti ti-trash"></i></a>
                                                                 
                                                                                           

       <div class="modal custom-modal fade" id="delete_discount" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content">
                <div class="modal-header border-0 justify-content-center pb-0">
                    <div class="form-header modal-header-title text-center mb-0">
                        <h4 class="mb-2">Delete Banner</h4>
                        <p>Are you sure want to delete?</p>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="modal-btn delete-action">
                        <div class="row text-center">
                            <div class="col-12">
                                <a href="' . route('delete-banners', ['id' => $data->id]) . '" 
                                    class="btn btn-primary paid-continue-btn">Delete</a>
                                      <a href="#" data-bs-dismiss="modal"
                                    class="btn btn-primary paid-cancel-btn">Cancel</a>
                            </div>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
                                                                ';
                    }
                })

                ->escapeColumns([])

                ->make(true);
        }
    }


    public function deletebanners(Request $request)
    {
        $data = Banners::where('id', $request->id)->first();
        if ((file_exists(public_path('uploads/banner/' . $data->image))) && ($data->image != NULL)) {
            unlink("uploads/banner/" . $data->image);
        }
        $res = Banners::where('id', $request->id)->delete();
        if ($res == 1)
            return redirect()->back()->with('success', 'Banner deleted successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    //*********************************** Banner section end*****************************/

    public function saveFAQ(Request $request)
    {

        $res = FAQ::insert([
            'role' => $request->role,
            'question' => $request->question,
            'answer' => $request->answer
        ]);

        // return response()->json(['success' => true]);
        if ($res == 1)
            return redirect()->back()->with('success', 'FAQ added successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function updateFAQ(Request $request)
    {

        $res = FAQ::where('id', $request->id)->update([
            'role' => $request->role,
            'question' => $request->question,
            'answer' => $request->answer
        ]);

        // return response()->json(['success' => true]);
        if ($res == 1)
            return redirect()->back()->with('success', 'FAQ added successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function getFAQ(Request $request)
    {
        if ($request->ajax()) {
            $data = FAQ::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('role', function ($data) {
                    return   $data->role;
                })

                ->addColumn('question', function ($data) {
                    return   $data->question;
                })
                ->addColumn('answer', function ($data) {
                    return   $data->answer;
                })
                ->addColumn('action', function ($data) {
                    $html = '';

                    $html .= '           <a href="' . route('edit-faq', ['id' => $data->id]) . '" class="btn btn-light-success icon-btn b-r-4" ><i class="ti ti-edit text-success"></i></a>';

                    $html .= '   <a href="#" class="btn btn-light-danger icon-btn b-r-4 delete-btn" data-bs-toggle="modal" data-bs-target="#delete_discount"><i class="ti ti-trash"></i></a>
                                                                 
            <div class="modal custom-modal fade" id="delete_discount" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content">
                <div class="modal-header border-0 justify-content-center pb-0">
                    <div class="form-header modal-header-title text-center mb-0">
                        <h4 class="mb-2">Delete zone</h4>
                        <p>Are you sure want to delete?</p>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="modal-btn delete-action">
                        <div class="row text-center">
                            <div class="col-12">
                                <a href="' . route('delete-faq', ['id' => $data->id]) . '" 
                                    class="btn btn-primary paid-continue-btn">Delete</a>
                                      <a href="#" data-bs-dismiss="modal"
                                    class="btn btn-primary paid-cancel-btn">Cancel</a>
                            </div>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
                                                                ';

                    return $html;
                })

                ->escapeColumns([])

                ->make(true);
        }
    }
    public function editFAQ(Request $request)
    {

        $data = FAQ::where('id', $request->id)->first();
        return view('edit-faq', ['data' => $data]);
    }
    public function deleteFAQ(Request $request)
    {

        $res = FAQ::where('id', $request->id)->delete();
        if ($res == 1)
            return redirect()->back()->with('success', 'FAQ deleted successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }


    public function getAccountDeleteRequest(Request $request)
    {
        if ($request->ajax()) {
            $data = AccountDeleteRequest::orderBy('id', 'DESC')
                ->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('user', function ($data) {
                    if ($data->role == 'Vendor') {
                        $user = Vendors::where('id', $data->user_id)->first();
                        return  '  <a href="' . route('view-vendor', ['id' => $user->id]) . '" >' . $user->name . '</a>
                                            ';
                    } elseif ($data->role == 'Driver') {
                        $user = Driver::where('id', $data->user_id)->first();
                        return  '  <a href="' . route('view-driver', ['id' => $user->id]) . '" >' . $user->name . '</a>
                                         ';
                    } else {
                        $user = Partner::where('id', $data->user_id)->first();
                        return  '  <a href="' . route('view-partner', ['role' => $user->role, 'id' => $user->id]) . '" >' . $user->name . '</a>
                                          ';
                    }
                })
                ->addColumn('role', function ($data) {
                    return   $data->role;
                })
                ->addColumn('reason', function ($data) {
                    return   $data->reason;
                })
                ->addColumn('date', function ($data) {
                    return    $data->created_at;
                })


                ->addColumn('action', function ($data) {
                    $html = '';
                    $role = strtolower($data->role);
                    $html .= '   <a href="#" class="btn btn-danger   delete-btn" data-bs-toggle="modal" data-bs-target="#delete_discount' . $data->id . '">Delete User </a>
                                                                <div class="modal custom-modal fade" id="delete_discount' . $data->id . '" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content">
                <div class="modal-header border-0 justify-content-center pb-0">
                    <div class="form-header modal-header-title text-center mb-0">
                        <h4 class="mb-2">Delete User</h4>
                        <p>Are you sure want to delete this user? it will delete user details permanently</p>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="modal-btn delete-action">
                        <div class="row text-center">
                            <div class="col-12">
                                <a href="' . route('delete-user', ['deleteid'=>$data->id,'id' => $data->user_id, 'role' => $data->role]) . '" 
                                    class="btn btn-primary paid-continue-btn">Delete</a>
                                      <a href="#" data-bs-dismiss="modal"
                                    class="btn btn-primary paid-cancel-btn">Cancel</a>
                            </div>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>';



                    return $html;
                })

                ->escapeColumns([])

                ->make(true);
        }
    }

    public function deleteUser(Request $request)
    {
      
        if ($request->role == 'Partner' || $request->role == 'Customer') {
          
            $data = Partner::where('id', $request->id)->first();
            if ((file_exists(public_path('uploads/partner/' . $data->image))) && ($data->image != NULL)) {
                unlink("uploads/partner/" . $data->image);
            }

            $res = Partner::where('id', $request->id)->delete();
        }
        if ($request->role == 'Driver') {
            $data = Driver::where('id', $request->id)->first();
            if ((file_exists(public_path('uploads/driver/' . $data->image))) && ($data->image != NULL)) {
                unlink("uploads/driver/" . $data->image);
            }

            $res = Driver::where('id', $request->id)->delete();
        }
        if ($request->role == 'Vendor') {
            $data = Vendors::where('id', $request->id)->first();
            if ((file_exists(public_path('uploads/vendor/' . $data->vendor_image))) && ($data->vendor_image != NULL)) {
                unlink("uploads/vendor/" . $data->vendor_image);
            }

            $res = Vendors::where('id', $request->id)->delete();
        }
         $res2 = AccountDeleteRequest::where('id', $request->deleteid)->delete(); 
        if ($res == 1 && $res2)
            return redirect()->back()->with('success', 'User Deleted successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }
}
