<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use App\Models\Fare;
use App\Models\Zone;
use App\Models\SearchHistory;
use App\Models\VehicleCategory;
use App\Models\BrandVehicle;
use App\Models\Vehicle;
use App\Models\Driver;
use App\Models\Partner;
use App\Models\Settings;
use App\Models\Review;
use App\Models\Vendors;
use App\Models\BookingHistory;
use App\Models\TripLifeCycle;
use Illuminate\Database\QueryException;
use Throwable;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Models\Notifications;

class BookingController extends Controller
{
    public function getBookingDetails(Request $request)
    {
        $gallery_images = [];
        $booking = BookingHistory::select(
            'booking_histories.*',
            'reviews.driver_rating',
            'reviews.car_rating',
            'reviews.comment'
        )
            ->leftJoin('reviews', 'booking_histories.id', '=', 'reviews.booking_id')
            ->where('booking_histories.booking_id', $request->id)
            ->first();
        $booking->makeHidden(['created_at', 'updated_at']);
        // ********** stay location  *********
        $raw = $booking->stay_locations; // The double-encoded JSON string
        $firstDecode = json_decode($raw, true);              // returns a JSON string
        $locationsArray = json_decode($firstDecode, true);   // returns the actual PHP array
        $booking->stay_locations = $locationsArray;
        // ********** stay date end  *********

        // ********** find titile  *********
        $departure = Carbon::parse($booking->departure_date);
        $return = Carbon::parse($booking->return_date);

        // Total days (inclusive)
        $totalDays = $departure->diffInDays($return) + 1; // +1 to include both start and end dates
        $nightCount = $totalDays - 1;

        // Final title
        $tripTitle = "{$nightCount}NIGHTS {$totalDays}DAYS";
        $booking->title = $tripTitle;
        // ********** find titile end  *********

        // ********** stay date  *********
        $raw = $booking->stay_date; // The double-encoded JSON string

        $firstDecode = json_decode($raw, true);              // returns a JSON string
        $locationsArray = json_decode($firstDecode, true);   // returns the actual PHP array

        $booking->stay_date = $locationsArray;
        // ********** stay date end *********
        $vehicle = Vehicle::join('drivers', 'vehicles.driver_id', '=', 'drivers.id')
            ->join('vendors', 'vehicles.vendor_id', '=', 'vendors.id')
            ->leftJoin('reviews', 'vehicles.id', '=', 'reviews.vehicle_id')
            ->leftJoin('booking_histories', 'vehicles.id', '=', 'booking_histories.vehicle_id')
            ->select(
                'vehicles.id',
                'vehicles.plate_number',
                'vehicles.seats',
                'vehicles.fuel_type',
                'vehicles.model',
                'vehicles.vehicle_make',
                'vehicles.image',
                'vendors.name as vendor_name',
                'vendors.vendor_image',
                DB::raw('AVG(reviews.overall_rating) as avg_rating'),
                DB::raw('COUNT(booking_histories.id) as total_trips')
            )
            ->where('vehicles.id', $booking->vehicle_id)
            ->groupBy(
                'vehicles.id',
                'vehicles.plate_number',
                'vehicles.seats',
                'vehicles.fuel_type',
                'vehicles.model',
                'vehicles.vehicle_make',
                'vehicles.image',
                'vendors.name',
                'vendors.vendor_image'
            )
            ->first();
        // $vehicle =  Vehicle::join('vendors', 'vehicles.vendor_id', '=', 'vendors.id')
        //                ->join('drivers', 'drivers.vendor_id', '=', 'vendors.id')
        //                 ->select('vehicles.id','vehicles.seats','vehicles.fuel_type','vehicles.model','vehicles.vehicle_make','vehicles.image', 'vendors.name as vendor_name','vendors.vendor_image') // select vendor fields as needed
        //                 ->where('vehicles.id',$booking->vehicle_id)
        //                 ->first();

        $vehicle->model = BrandVehicle::where('id', $vehicle->model)->pluck('model_name')->first();
        foreach (json_decode($vehicle->image) as $i => $img) {
            if ($i == 3) {
                break; // Stop looping once 3 images collected
            }
            $gallery_images[$i] = asset('uploads/vehicle/' . $img); // or Storage::url($img) if using storage
        }

        if ($vehicle->vendor_image == NULL) {
            $vehicle->vendor_image = asset('assets/images/user.jpg');
        } else {
            $vehicle->vendor_image = asset('uploads/vendor/' . $vehicle->vendor_image);
        }
        $vehicle->image = $gallery_images;
        $vehicle->review_rate = 5;

        $booking->cab_agency_details = $vehicle;
        $driver = Driver::select('name', 'image')->where('id', $booking->driver_id)->first();
        if ($driver != null) {
            if ($driver->image == NULL) {
                $driver->image = asset('assets/images/user.jpg');
            } else {
                $driver->image = asset('uploads/driver/' . $driver->image);
            }
        }

        // trip life cycle
        $res = BookingHistory::where('booking_id', $request->id)->first();

        // Calculate remaining km
        $lastTrip = TripLifeCycle::where('booking_id', $res->id)->orderBy('id', 'DESC')->first();
        $remainingKM = $lastTrip ? $lastTrip->remaining_km : $res->total_km;
        $res->remainingKM = $remainingKM;

        // Fetch all existing trip life cycles for this booking, keyed by date
        $existingLifeCycles = TripLifeCycle::where('booking_id', $res->id)
            ->get()
            ->keyBy(function ($item) {
                return Carbon::parse($item->date)->format('Y-m-d');
            });

        // Pass BOTH variables to the view

 $departureDate = date("Y-m-d", strtotime($booking->departure_date));
      $returnDate = date("Y-m-d", strtotime($booking->return_date));
      $origin = $booking->pick_up;
      // Step 1: Get coordinates of origin
      $originCoords = $this->getCoordinatesFromAddress($origin);

      // Step 2: Find the zone for origin
      $zones = Zone::all();
      $originZone = null;
      foreach ($zones as $zone) {
        $polygon = json_decode($zone->coordinates, true); // ← fix here
        if ($this->isPointInPolygon($originCoords, $polygon)) {
          $originZone = $zone;
          break;
        }
      }
      // echo $originZone->id;
      $availableDrivers = DB::table('drivers as d')
        ->where('d.vendor_id', $booking->vendor_id)
        ->where('d.status', 'ACTIVE')
        //  ->where('d.is_availabile_status', 'False')
        ->where('d.is_availabile_status', 'True')
        ->where('d.zone', $originZone->id)
        ->whereNotExists(function ($query) use ($departureDate, $returnDate) {
          $query->select(DB::raw(1))
            ->from('booking_histories as bh')
            ->whereRaw('bh.driver_id = d.id')
            ->where(function ($q) use ($departureDate, $returnDate) {
              $q->where('bh.departure_date', '<=', $returnDate)
                ->where('bh.return_date', '>=', $departureDate);
            });
        })
       // ->select('d.id', 'd.name', 'd.phone', 'd.image')
           ->select('d.id', 'd.name')
        ->get();

    
        return view('booking.view', [
            'data' => $booking,
            'driver' => $driver,
            'lifecycle' => $res,
            'existingLifeCycles' => $existingLifeCycles,
            'availableDrivers'=>$availableDrivers
        ]);
    }
    public function getBookings(Request $request)
    {
       
        if ($request->ajax()) {
            $data = BookingHistory::orderBy('id', 'DESC');
            if ($request->filled('start_date') && $request->filled('end_date')) {
                $data = $data->whereBetween('created_at', [date('Y-m-d 00:00:00', strtotime($request->start_date)), date('Y-m-d 23:59:59', strtotime($request->end_date))]);
            } elseif ($request->filled('start_date')) {
                $data = $data->where('created_at', '>=', date('Y-m-d 00:00:00', strtotime($request->start_date)));
            } elseif ($request->filled('end_date')) {
                $data = $data->where('created_at', '<=', date('Y-m-d 23:59:59', strtotime($request->end_date)));
            }
            if ($request->filled('status')) {
                $data = $data->where('booking_status', $request->status);
            }
            if ($request->filled('vendor_id')) {
                $data = $data->where('vendor_id', $request->vendor_id);
            }
            if ($request->filled('driver_id')) {
                $data = $data->where('driver_id', $request->driver_id);
            }
            if ($request->filled('vehicle_id')) {
                $data = $data->where('vehicle_id', $request->vehicle_id);
            }
            if ($request->filled('booked_user_id')) {
                $data = $data->where('booked_user_id', $request->booked_user_id);
            }
            $data = $data->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('booking_id', function ($data) {
                    if ($data->booking_status == 'Upcoming') {
                        $class = "success";
                        return         $html = '<a href="' . route('get-booking-details', ['id' => $data->booking_id]) . '" class="position-relative bg-light-' . $class . ' px-2 py-1 b-r-10">
                                    ' . $data->booking_id . '
                                    <span class="position-absolute top-0 start-100 translate-middle p-1 bg-' . $class . ' rounded-circle animate__animated animate__fadeIn animate__infinite animate__fast"></span>
                                </a>';
                    }
                    return  '<a href="' . route('get-booking-details', ['id' => $data->booking_id]) . '" style="color:blue;">' . $data->booking_id . '</a>';
                })
                ->addColumn('location', function ($data) {
                    return  '<p class="text-info f-s-16 mb-0">' . $data->pick_up . '</p> <i class="ph-bold  ph-arrow-down"></i> <p class="text-danger f-s-16 mb-0">' . $data->drop_off . '</p>';
                })
                ->addColumn('date', function ($data) {
                    return  '<p class="text-info f-s-16 mb-0">' . $data->departure_date . ' ' . $data->departure_time . '</p><br> <i class="ph-bold  ph-arrow-down"></i> <br><p class="text-danger f-s-16 mb-0">' . $data->return_date . ' ' . $data->return_time . '</p>';
                })
                ->addColumn('vendor', function ($data) {
                    return '<a href="' . route('view-vendor', ['id' => $data->vendor_id]) . '" class="text-primary">' . Vendors::where('id', $data->vendor_id)->pluck('name')->first() . '</a>';
                })
                ->addColumn('driver', function ($data) {
                    if ($data->driver_id != NULL) {
                        return '<a href="' . route('view-driver', ['id' => $data->driver_id]) . '" class="text-primary">' . Driver::where('id', $data->driver_id)->pluck('name')->first() . '</a>';
                    } else {
                        return '<span class="badge text-light-dark">Not Assigned</span>';
                    }
                })
                ->addColumn('vehicle', function ($data) {
                    $vehicle = Vehicle::where('id', $data->vehicle_id)->pluck('model')->first();
                    return   BrandVehicle::where('id', $vehicle)->pluck('model_name')->first();
                })
                ->addColumn('payment_status', function ($data) {
                   if ($data->payment_status == 'captured')
                        return  '<span class="badge text-light-success">' . $data->payment_status . '</span>';
                    else
                         return '<span class="badge text-light-danger"> ' . $data->payment_status . '</span>';
                })
                ->addColumn('booked_by', function ($data) {
                    if ($data->role == 'Partner') {
                        $class = "success";
                    } else {
                        $class = "danger";
                    }
                    return  '<a href="' . route('view-partner', ['role' => $data->role, 'id' => $data->booked_user_id]) . '">' . Partner::where('id', $data->booked_user_id)->pluck('name')->first() . '<br><p class="text-' . $class . '">(' . $data->role . ')</p></a>';
                })
                ->addColumn('booking_status', function ($data) {
                    if ($data->booking_status == 'Upcoming') {
                        $class = "warning";
                    } elseif ($data->booking_status == 'Confirmed') {
                        $class = "info";
                    } elseif ($data->booking_status == 'Running') {
                        $class = "primary";
                    } elseif ($data->booking_status == 'Completed') {
                        $class = "success";
                    } elseif ($data->booking_status == 'Canceled') {
                        $class = "danger";
                    }

                    if ($data->booking_status == 'Upcoming') {
                        $html = '<a href="#" class="position-relative text-bg-' . $class . ' px-2 py-1 b-r-10">
                                    ' . $data->booking_status . '
                                    <span class="position-absolute top-0 start-100 translate-middle p-1 bg-' . $class . ' rounded-circle animate__animated animate__fadeIn animate__infinite animate__fast"></span>
                                </a>';
                    } else {

                        $html = '<a href="#" class="position-relative text-bg-' . $class . ' px-2 py-1 b-r-10">
                                    ' . $data->booking_status . '</a>';
                    }
                    return $html;
                })
                ->addColumn('total_km', function ($data) {
                    return  $data->total_km;
                })
                ->addColumn('total_fare', function ($data) {
                    return  $data->total_fare;
                })
                ->addColumn('action', function ($data) {
                    if (auth()->user()->can('delete-booking')) {
                        return   ' <a href="#" class="btn btn-light-danger icon-btn b-r-4 delete-btn" data-bs-toggle="modal" data-bs-target="#delete_discount' . $data->id . '"><i class="ti ti-trash"></i></a>
                        <div class="modal custom-modal fade" id="delete_discount' . $data->id . '" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content">
                <div class="modal-header border-0 justify-content-center pb-0">
                    <div class="form-header modal-header-title text-center mb-0">
                        <h4 class="mb-2">Delete Item</h4>
                        <p>Are you sure want to delete?</p>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="modal-btn delete-action">
                        <div class="row text-center">
                            <div class="col-12">
                                <a href="' . route('delete-booking', ['id' => $data->id]) . '" 
                                    class="btn btn-primary paid-continue-btn">Delete</a>
                                      <a href="#" data-bs-dismiss="modal"
                                    class="btn btn-primary paid-cancel-btn">Cancel</a>
                            </div>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>                                            
    ';
                    }
                })

                ->escapeColumns([])

                ->make(true);
        }
    }

    public function deletebooking(Request $request)
    {
        $res = BookingHistory::where('id', $request->id)->delete();
        if ($res == 1)
            return redirect()->back()->with('success', 'Data  deleted successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function deletereviews(Request $request)
    {
        $res = Review::where('id', $request->id)->delete();
        if ($res == 1)
            return redirect()->back()->with('success', 'Review  deleted successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function getreviews(Request $request)
    {
        if ($request->ajax()) {
            $data = Review::orderBy('id', 'DESC');
            if ($request->filled('start_date') && $request->filled('end_date')) {
                $data = $data->whereBetween('created_at', [date('Y-m-d 00:00:00', strtotime($request->start_date)), date('Y-m-d 23:59:59', strtotime($request->end_date))]);
            } elseif ($request->filled('start_date')) {
                $data = $data->where('created_at', '>=', date('Y-m-d 00:00:00', strtotime($request->start_date)));
            } elseif ($request->filled('end_date')) {
                $data = $data->where('created_at', '<=', date('Y-m-d 23:59:59', strtotime($request->end_date)));
            }

            if ($request->filled('driver_id')) {
                $data = $data->where('driver_id', $request->driver_id);
            }
            if ($request->filled('vehicle_id')) {
                $data = $data->where('vehicle_id', $request->vehicle_id);
            }
            $data = $data->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('booking_id', function ($data) {
                    if ($data->booking_status == 'Upcoming') {
                        $class = "success";
                        return         $html = '<a href="' . route('get-booking-details', ['id' => $data->booking_id]) . '" class="position-relative bg-light-' . $class . ' px-2 py-1 b-r-10">
                                    ' . BookingHistory::where('id', $data->booking_id)->pluck('booking_id')->first() . '
                                    <span class="position-absolute top-0 start-100 translate-middle p-1 bg-' . $class . ' rounded-circle animate__animated animate__fadeIn animate__infinite animate__fast"></span>
                                </a>';
                    }
                    return  '<a href="' . route('get-booking-details', ['id' => $data->booking_id]) . '" style="color:blue;">' . BookingHistory::where('id', $data->booking_id)->pluck('booking_id')->first() . '</a>';
                })
                ->addColumn('rate', function ($data) {
                    $html = '<div class="rating ">';
                    for ($i = 1; $i <= $data->driver_rating; $i++) {
                        $html .=  '     <input type="radio" id="star15" name="ratings2" value="15" checked="" disabled="">
                                                <label class="star" for="star15"><span class="ti ti-star-filled f-s-20 text-warning"></span></label>';
                    }
                    for ($i = 1; $i <= 5 - $data->driver_rating; $i++) {
                        $html .=  '            <input type="radio" id="star14" name="ratings2" value="14" disabled="">
                                                    <label class="star" for="star14"><span class="ti ti-star f-s-20 text-warning"></span></label>';
                    }

                    $html .=  '           </div>';
                    return $html;
                })
                ->addColumn('comment', function ($data) {
                    return $data->comment;
                })
                ->addColumn('postedon', function ($data) {
                    return   $data->created_at;
                })

                ->addColumn('user', function ($data) {
                    return   Partner::where('id', $data->user_id)->pluck('name')->first();
                })


                ->addColumn('action', function ($data) {
                    if (auth()->user()->can('delete-review')) {
                        return   ' <a href="#" class="btn btn-light-danger icon-btn b-r-4 delete-btn" data-bs-toggle="modal" data-bs-target="#delete_discount' . $data->id . '"><i class="ti ti-trash"></i></a>
                        <div class="modal custom-modal fade" id="delete_discount' . $data->id . '" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content">
                <div class="modal-header border-0 justify-content-center pb-0">
                    <div class="form-header modal-header-title text-center mb-0">
                        <h4 class="mb-2">Delete Item</h4>
                        <p>Are you sure want to delete?</p>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="modal-btn delete-action">
                        <div class="row text-center">
                            <div class="col-12">
                                <a href="' . route('delete-review', ['id' => $data->id]) . '" 
                                    class="btn btn-primary paid-continue-btn">Delete</a>
                                      <a href="#" data-bs-dismiss="modal"
                                    class="btn btn-primary paid-cancel-btn">Cancel</a>
                            </div>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>                                            
    ';
                    }
                })

                ->escapeColumns([])

                ->make(true);
        }
    }


    public function addtriplifecycle(Request $request)
    {
        
        $res = BookingHistory::where('booking_id', $request->id)->first();

        // Calculate remaining km
        $lastTrip = TripLifeCycle::where('booking_id', $res->id)->orderBy('id', 'DESC')->first();
        $remainingKM = $lastTrip ? $lastTrip->remaining_km : $res->total_km;
        $res->remainingKM = $remainingKM;

        // Fetch all existing trip life cycles for this booking, keyed by date
        $existingLifeCycles = TripLifeCycle::where('booking_id', $res->id)
            ->get()
            ->keyBy(function ($item) {
                return Carbon::parse($item->date)->format('Y-m-d');
            });


        // Pass BOTH variables to the view
        return view('booking.add-lifecycle', [
            'data' => $res,
            'existingLifeCycles' => $existingLifeCycles
        ]);
    }



    public function savetriplifecycle(Request $request)
    {
      
        try {
              
            //     print_r($request->all());die();
            $bookingId = $request->input('bookingid');

            $days = $request->input('day', []);
            $dates = $request->input('trip_date', []);
            $startReadings = $request->input('starting_meter_reading', []);
            $endReadings = $request->input('ending_meter_reading', []);
            $additionalCharges = $request->input('additional_charge_collected', []);
             $amount_collected = $request->input('amount_collected', []);
            $notes = $request->input('note', []);

            // 1️⃣ Insert or update all provided days
            for ($i = 0; $i < count($startReadings); $i++) {
                if ($startReadings[$i] !== null && $startReadings[$i] !== '') {
                    $date = Carbon::parse($dates[$i])->format('Y-m-d');
                    $start = (float)$startReadings[$i];
                    $end = !empty($endReadings[$i]) ? (float)$endReadings[$i] : null;
                    $kmDriven = ($end !== null) ? ($end - $start) : null;

                    TripLifeCycle::updateOrCreate(
                        [
                            'id' => $request->tripid[$i],
                            'booking_id' => $bookingId,
                            'date' => $date
                        ],
                        [
                            'day' => $days[$i],
                            'starting_meter_reading' => $start,
                            'ending_meter_reading' => $end,
                            'km_driven' => $kmDriven,
                            'additional_charge_collected' => $additionalCharges[$i] ?? null,
                             'amount_collected' => $amount_collected[$i] ?? null,
                            'note' => $notes[$i] ?? null,
                        ]
                    );
                }
            }

            // 2️⃣ Recalculate remaining_km for ALL trip days for this booking
            $booking = BookingHistory::find($bookingId);
            if (!$booking) {
                return redirect()->back()->with('error', 'Booking not found.');
            }

            $totalKm = $booking->total_km;

            $tripLifeCycles = TripLifeCycle::where('booking_id', $bookingId)
                ->orderBy('date')
                ->get();

            $cumulativeKm = 0;

            foreach ($tripLifeCycles as $trip) {
                $cumulativeKm += $trip->km_driven ?? 0;
                $remainingKm = $totalKm - $cumulativeKm;

                $trip->remaining_km = $remainingKm;
                $trip->save();
            }

            return redirect()->back()->with('success', 'Trip lifecycle data saved successfully!');
        } catch (\Throwable $e) {
            return redirect()->back()->with('error', 'Error: ' . $e->getMessage());
        }
    }

    public function changebookingstatus(Request $request)
    {
        try {

            $res = BookingHistory::where('id', $request->booking_id)
                ->update(['booking_status' => $request->booking_status]);

            if ($res == 1) {
                $booking = BookingHistory::where('id', $request->booking_id)
                    ->first();

                if ($booking) {

                    $driver = Driver::find($booking->driver_id);
                    $vehicle = Vehicle::find($booking->vehicle_id);
                    $brandModel = $vehicle ? BrandVehicle::find($vehicle->model) : null;

                    $bookingId = $booking->booking_id;
                    $driverName = $driver?->name ?? 'N/A';
                    $driverContact = $driver?->phone ?? 'N/A';
                    $vehicleName = $vehicle?->vehicle_make . ' ' . ($brandModel?->model_name ?? '');
                }
               
                if ($request->booking_status == 'Confirmed') {

                    $curl = curl_init();

                    curl_setopt_array($curl, array(
                        CURLOPT_URL => 'https://api.connectpanels.com/whatsapp-api/v1.0/customer/120180/bot/0d094a19d57e4eaa/template',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'POST',
                        CURLOPT_POSTFIELDS => '{"payload":{"name":"booking_confirmation","components":[{"type":"body","parameters":[{"type":"text","text":"' . $bookingId . '"},{"type":"text","text":"' . $driverName . '"},{"type":"text","text":"NA"},{"type":"text","text":"' . $vehicleName . '('.$vehicle->plate_number.')"}]}],"language":{"code":"en_US","policy":"deterministic"},"namespace":"66cbcb46_a232_4519_a6e7_b69fd50991bf"},"phoneNumber":"' . $booking->client_mobile_number . '"}',
                        CURLOPT_HTTPHEADER => array(
                            'Authorization: Basic c4d8e3eb-4e7c-4f9d-a05c-5ff0bf583d29-Ic1uEZu',
                            'Content-Type: application/json'
                        ),
                    ));

                    $response = curl_exec($curl);

                    curl_close($curl);

                      Notifications::insert([
                        'booking_id' => $bookingId,
                        'vendor_id' => $vehicle->vendor_id,
                        'driver_id' => $vehicle->driver_id,
                        'booked_user_id' => $booking->booked_user_id,
                        'notification_title'=> 'Booking Confirmation',
                        'notification' => "Booking Confirmed for Booking ID: $bookingId , Vehicle $vehicleName ",                       
                    ]);
                }
                if ($request->booking_status == 'Canceled') {

                    $curl = curl_init();

                    curl_setopt_array($curl, array(
                        CURLOPT_URL => 'https://api.connectpanels.com/whatsapp-api/v1.0/customer/120180/bot/0d094a19d57e4eaa/template',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'POST',
                        CURLOPT_POSTFIELDS => '{"payload":{"name":"trip_cancellation","components":[{"type":"body","parameters":[{"type":"text","text":"' . $bookingId . '"}]}],"language":{"code":"en_US","policy":"deterministic"},"namespace":"66cbcb46_a232_4519_a6e7_b69fd50991bf"},"phoneNumber":"' . $booking->client_mobile_number . '"}',
                        CURLOPT_HTTPHEADER => array(
                            'Authorization: Basic c4d8e3eb-4e7c-4f9d-a05c-5ff0bf583d29-Ic1uEZu',
                            'Content-Type: application/json'
                        ),
                    ));

                    $response = curl_exec($curl);

                    curl_close($curl);

                      Notifications::insert([
                        'booking_id' => $bookingId,
                        'vendor_id' => $vehicle->vendor_id,
                        'driver_id' => $vehicle->driver_id,
                        'booked_user_id' =>$booking->booked_user_id,
                        'notification' => "Your Booking Has Been Cancelled. Booking ID: $bookingId. We’re sorry to see you go! If you change your mind, you’re always welcome to book again.",
                        'notification_title'=> 'Trip Cancellation',
                    ]);
                }

                if ($request->booking_status == 'Completed') {

                    $trip = $booking->pick_up . ' (' . $booking->departure_date . ') ➝ ' . $booking->drop_off . ' (' . $booking->return_date . ')';
                   $totalpaidamount = $booking->total_fare + TripLifeCycle::where('booking_id', $booking->id)->sum('additional_charge_collected');
                
                    $curl = curl_init();

                    curl_setopt_array($curl, array(
                        CURLOPT_URL => 'https://api.connectpanels.com/whatsapp-api/v1.0/customer/120180/bot/0d094a19d57e4eaa/template',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'POST',
                        CURLOPT_POSTFIELDS => '{"payload":{"name":"trip_completed_invoice","components":[{"type":"body","parameters":[{"type":"text","text":"' . $bookingId . '"},{"type":"text","text":"' . $trip . '"},{"type":"text","text":"' . $totalpaidamount . '"}]}],"language":{"code":"en_US","policy":"deterministic"},"namespace":"66cbcb46_a232_4519_a6e7_b69fd50991bf"},"phoneNumber":"' . $booking->client_mobile_number . '"}',
                        CURLOPT_HTTPHEADER => array(
                            'Authorization: Basic c4d8e3eb-4e7c-4f9d-a05c-5ff0bf583d29-Ic1uEZu',
                            'Content-Type: application/json'
                        ),
                    ));

                    $response = curl_exec($curl);
                 // print_r($response);die();
                    curl_close($curl);

                    Notifications::insert([
                        'booking_id' => $bookingId,
                        'vendor_id' => $vehicle->vendor_id,
                        'driver_id' => $vehicle->driver_id,
                        'booked_user_id' => $booking->booked_user_id,
                        'notification' => " Trip Completed!. Booking ID: $bookingId. Trip Details: $trip. Final Fare: $totalpaidamount" ,
                        'notification_title'=> 'Trip Completed',
                    ]);
                   
                }
                return redirect()->back()->with('success', 'Update booking status Successfully');
            }
        } catch (QueryException $e) {
            return redirect()->back()->with('error', 'Database error ' . $e);
        } catch (Throwable $e) {
            return redirect()->back()->with('error', 'Something went wrong ' . $e);
        }
    }



    public function downloadInvoice(Request $request)
    {

        $data = BookingHistory::join('vehicles', 'vehicles.id', '=', 'booking_histories.vehicle_id')
            ->join('brand_vehicles', 'vehicles.model', '=', 'brand_vehicles.id')
            ->leftJoin('drivers', 'booking_histories.driver_id', '=', 'drivers.id') // changed to leftJoin
            ->select(
                'booking_histories.*',
                'drivers.name',
                'brand_vehicles.model_name',
                'vehicles.plate_number',
            )
            ->where('booking_histories.booking_id', $request->id)
            ->first();

        // ********** stay location  *********
        $raw = $data->stay_locations; // The double-encoded JSON string
        $firstDecode = json_decode($raw, true);              // returns a JSON string
        $locationsArray = json_decode($firstDecode, true);   // returns the actual PHP array
        $data->stay_locations = $locationsArray;
        // ********** stay date end  *********

        // Sample Data (replace with DB call)
        $invoice = (object)[
            'booking_id' => $data->booking_id,
            'trip_date' =>  $data->departure_date,
            'driver_name' =>  $data->name,
            'vehicle' =>  $data->model_name,
            'vehicle_no' => $data->plate_number,
            'customer_name' => $data->client_name,
            'customer_contact' => $data->client_mobile_number,
            'pickup_address' => $data->pick_up,
            'drop_address' => $data->drop_off,
            'base_fare' => $data->base_fare,
            'tax_percentage' => Settings::pluck('tax')->first(),
            'tax' => $data->tax,
            'total_fare' => $data->total_fare,
            'platform_fee' => $data->platform_fee,
            'paid_amount' => $data->paid_amount,
            'pickup_time' => $data->departure_time,
            'drop_time' => $data->return_time,
            'total_km' => $data->total_km,
            'days' => count($data->stay_locations),
            'payment_mode' => 'UPI',
            'status' => $data->booking_status
        ];
        //  return view('invoice', compact('invoice'));
        $pdf = Pdf::loadView('invoice', compact('invoice'));
        return $pdf->download('invoice_' . $invoice->booking_id . '.pdf');
    }

    
    public function getCoordinatesFromAddress($address)
    {
        try {
            $apiKey = Settings::pluck('google_map_api_key')->first();
            $response = Http::get("https://maps.googleapis.com/maps/api/geocode/json", [
                'address' => $address,
                'key' => $apiKey,
            ]);

            $data = $response->json();
            if ($data['status'] === 'OK') {
                $location = $data['results'][0]['geometry']['location'];
                return ['lat' => $location['lat'], 'lng' => $location['lng']];
            }

            throw new \Exception("Invalid address or failed to fetch coordinates.");
        } catch (QueryException $e) {
            return response()->json(['error' => 'Database error ' . $e], 500);
        } catch (Throwable $e) {
            return response()->json(['error' => 'Something went wrong ' . $e], 500);
        }
    }

     public function isPointInPolygon($point, $polygon)
    {
        try {
            $lat = $point['lat'];
            $lng = $point['lng'];
            $inside = false;
            $j = count($polygon) - 1;

            for ($i = 0; $i < count($polygon); $i++) {
                $xi = $polygon[$i]['lat'];
                $yi = $polygon[$i]['lng'];
                $xj = $polygon[$j]['lat'];
                $yj = $polygon[$j]['lng'];

                $intersect = (($yi > $lng) != ($yj > $lng))
                    && ($lat < ($xj - $xi) * ($lng - $yi) / ($yj - $yi) + $xi);
                if ($intersect) $inside = !$inside;
                $j = $i;
            }

            return $inside;
        } catch (QueryException $e) {
            return response()->json(['error' => 'Database error ' . $e], 500);
        } catch (Throwable $e) {
            return response()->json(['error' => 'Something went wrong ' . $e], 500);
        }
    }
}
