<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Zone;
use App\Models\drivers;
use App\Models\Driver;
use App\Models\Vehicle;
use App\Models\VehicleCategory;
use App\Models\BrandVehicle;
use App\Models\Review;
use App\Models\BookingHistory;
use App\Models\Partner;
use Illuminate\Database\QueryException;
use Throwable;
use App\Models\Vendors;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\Cache;
use App\Models\TripLifeCycle;

class WebDriverController extends Controller
{

    use AuthenticatesUsers;

    public function sendOtp(Request $request)
    {
        $request->validate(['phone' => 'required']);
        $phone = $request->input('phone');
        $phone = preg_replace('/\s+/', '', $phone);
        //    $otp = rand(10000, 99999);
        $otp = '12345';
        // Store OTP temporarily (e.g. 5 minutes)
        Cache::put('otp_' . $phone, $otp, now()->addMinutes(10));
        //    Cache::put('otp_' . $request->phone, $otp, 600);
        //    return redirect()->route('driver.verify-phone', ['phone' => $phone])->with('success', 'Otp send to ' . $phone);
        // Send OTP using SMS provider (Twilio, etc.)
        // e.g. SmsService::send($request->phone, "Your OTP is $otp");
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.connectpanels.com/whatsapp-api/v1.0/customer/120180/bot/0d094a19d57e4eaa/template',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => '{"payload":{"name":"otp","components":[{"type":"body","parameters":[{"type":"text","text":"' . $otp . '"}]},{"type":"button","sub_type":"url","index":0,"parameters":[{"type":"text","text":"' . $otp . '"}]}],"language":{"code":"en_US","policy":"deterministic"},"namespace":"66cbcb46_a232_4519_a6e7_b69fd50991bf"},"phoneNumber":"' . $phone . '"}',
            CURLOPT_HTTPHEADER => array(
                'Authorization: Basic c4d8e3eb-4e7c-4f9d-a05c-5ff0bf583d29-Ic1uEZu',
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);

        // Convert to array
        $responseData = json_decode($response, true);

        // Use the data
        // $messageId = $responseData['responseObject']['message_id'];
        // $statusCode = $responseData['status']['code'];
        $statusDesc = $responseData['status']['desc'];
        curl_close($curl);
        if ($statusDesc == 'SUCCESS') {
            return redirect()->route('driver.verify-phone', ['phone' => $phone])->with('success', 'Otp send to ' . $phone);
            //  return view('web.drivers.otp',['phone'=>$request->phone]);
        }
    }


    public function verifyPhone(Request $request)
    {
        return view('web.drivers.otp', ['phone' => $request->phone]);
    }
    public function verifyOtp(Request $request)
    {
        $request->validate([
            'phone' => 'required',
            'otp' => 'required|digits:5',
        ]);
        $phone = $request->input('phone');
        $phone = preg_replace('/\s+/', '', $phone);
        $storedOtp = Cache::get('otp_' . $phone);

        if ($storedOtp && $storedOtp == $request->otp) {
            // OTP is valid
            // Authenticate or register user logic here

            $user = Driver::where('phone', $phone)->first();

            $user_account = 'exist-user';

            if ($user == null) {
                // Register new user
                $user = Driver::create([
                    'phone' => $phone,
                ]);
                $user_account = 'new-user';
                $user = Driver::where('phone', $phone)->first();
            }
            if ($user->status == 'REQUESTED') {
                if (!empty($user->name) && !empty($user->zone)) {
                    // echo "hi";die();
                    return redirect()->route('driver.not-active');
                } else {
                    Cache::forget('otp_' . $phone);
                    Auth::guard('driver-web')->login($user);
                    return redirect()->route('driver.add-profile', ['phone' => $phone])->with('success', 'OTP verified Successfully ');
                }
            }
            // if (($user->status == 'BLOCKED' || $user->status == 'REQUESTED') && $user_account == 'exist-user') {
            //     return redirect()->route('driver.not-active')->with('error', 'Your account is not active. Please contact support.');
            // }

            Cache::forget('otp_' . $phone);
            Auth::guard('driver-web')->login($user);
            if ($user_account == 'new-user') {
                return redirect()->route('driver.add-profile', ['phone' => $phone])->with('success', 'OTP verified Successfully ');
            }
            return redirect()->route('driver.profile')->with('success', 'OTP verified Successfully. Your are logged in successfully. ');
        }
        return redirect()->back()->with('error', 'Invalid OTP');
    }


    public function addProfile(Request $request)
    {
        $data = Driver::where('phone', $request->phone)->first();
        return view('web.drivers.add-profile', ['data' => $data]);
    }

    public function updateNewDriver(Request $request)
    {
        // print_r($request->all());die();

        if ($request->hasFile('photo')) {
            $data = Driver::where('id', $request->id)->first();

            if ((file_exists(public_path('uploads/driver/' . $data->image))) && ($data->image != NULL)) {
                unlink("uploads/driver/" . $data->image);
            }
            $rand = rand(100, 999);
            $image = time() . '.' . $request->photo->extension();
            $imageOriginalName = $request->photo->getClientOriginalName();
            $request->photo->move(public_path('uploads/driver/'), $image);

            //  $request->photo->move(public_path('uploads/vendor/'), $image);
            $res = Driver::where('id', $request->id)
                ->update(['image' => $image]);
        }

        $exist = Vendors::where('phone', $request->phone)->first();
        if ($exist == null) {
            $vendor = new Vendors();
            $vendor->name = $request->name;
            $vendor->email = $request->email;
            $vendor->phone = $request->phone;
            $vendor->address = $request->address;
            $vendor->vendor_image = $image;
            $vendor->zone = $request->zone_id;
            $vendor->driver_also = 'YES';
            $vendor->save();
            $vendorid = $vendor->id;
        } else {
            $vendorid = $exist->id;
        }
        $res = Driver::where('id', $request->id)
            ->update([
                'vendor_id' => $vendorid,
                'name' => $request->name,
                'email' => $request->email,
                'address' => $request->address,
                'aadhar_no' => $request->aadhar_no,
                'licence_number' => $request->licence_number,
                'licence_validity' => $request->licence_validity,
                'zone' => $request->zone_id,
            ]);


        if ($request->hasFile('licence')) {

            $data = Driver::where('id', $request->id)->first();
            if ((file_exists(public_path('uploads/driver/licence/', $data->licence))) && ($data->licence != NULL)) {
                unlink("uploads/driver/licence/" . $data->licence);
            }
            $rand = rand(100, 999);
            $licence_image = time() . '.' . $request->licence->extension();
            $imageOriginalName = $request->licence->getClientOriginalName();
            $request->licence->move(public_path('uploads/driver/licence/'), $licence_image);
            $res =  Driver::where('id', $request->id)
                ->update([
                    'licence' => $licence_image,
                ]);
        }


        if ($res == 1)
            return redirect()->route('driver.success');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function signout(Request $request)
    {

        Auth::guard('driver-web')->logout();
        //   $request->session()->invalidate();
        $request->session()->forget('key'); // optional
        $request->session()->regenerateToken();

        return redirect()->route('index');
    }

    public function profile(Request $request)
    {
        return view('web.drivers.profile', ['data' => Auth::guard('driver-web')->user()]);
    }
    public function editprofile(Request $request)
    {
        return view('web.drivers.edit-profile', ['data' => Auth::guard('driver-web')->user()]);
    }
    public function updatedriver(Request $request)
    {
        $image = '';
        $licence_image = '';
        if ($request->photo) {
            $rand = rand(100, 999);
            $image = time() . '.' . $request->photo->extension();
            $imageOriginalName = $request->photo->getClientOriginalName();
            $request->photo->move(public_path('uploads/driver/'), $image);
            Driver::where('id', $request->id)->update(['driver_image' => $image]);
        }
        $res = Driver::where('id', $request->id)
            ->update([

                'name' => $request->name,
                'email' => $request->email,
                'phone' => $request->phone,
                'address' => $request->address,
                'district' => $request->district,
                'state' => $request->state,
                'country' => $request->country,
                'postal_code' => $request->postal_code,
            ]);

        if ($res == 1)
            return redirect()->back()->with('success', 'driver  updated successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function getBookings(Request $request)
    {
        //    print_r(Auth::guard('driver-web')->user());die();
        if ($request->ajax()) {
            $data = BookingHistory::where('driver_id', Auth::guard('driver-web')->user()->id)->orderBy('id', 'DESC');
            if ($request->filled('start_date') && $request->filled('end_date')) {
                $data = $data->whereBetween('created_at', [date('Y-m-d 00:00:00', strtotime($request->start_date)), date('Y-m-d 23:59:59', strtotime($request->end_date))]);
            } elseif ($request->filled('start_date')) {
                $data = $data->where('created_at', '>=', date('Y-m-d 00:00:00', strtotime($request->start_date)));
            } elseif ($request->filled('end_date')) {
                $data = $data->where('created_at', '<=', date('Y-m-d 23:59:59', strtotime($request->end_date)));
            }
            if ($request->filled('status')) {
                $data = $data->where('booking_status', $request->status);
            }
            $data = $data->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('booking_id', function ($data) {
                    if ($data->booking_status == 'Upcoming') {
                        $class = "success";
                        return         $html = '<a href="' . route('driver.get-booking-details', ['id' => $data->booking_id]) . '" class="position-relative bg-light-' . $class . ' px-2 py-1 b-r-10">
                                    ' . $data->booking_id . '
                                    <span class="position-absolute top-0 start-100 translate-middle p-1 bg-' . $class . ' rounded-circle animate__animated animate__fadeIn animate__infinite animate__fast"></span>
                                </a>';
                    }
                    return  '<a href="' . route('driver.get-booking-details', ['id' => $data->booking_id]) . '" style="color:blue;">' . $data->booking_id . '</a>';
                })
                ->addColumn('location', function ($data) {
                    return  '<p class="text-info f-s-16 mb-0">' . $data->pick_up . '</p> <i class="ph-bold  ph-arrow-down"></i> <p class="text-danger f-s-16 mb-0">' . $data->drop_off . '</p>';
                })
                ->addColumn('date', function ($data) {
                    return  '<p class="text-info f-s-16 mb-0">' . $data->departure_date . ' ' . $data->departure_time . '</p><br> <i class="ph-bold  ph-arrow-down"></i> <br><p class="text-danger f-s-16 mb-0">' . $data->return_date . ' ' . $data->return_time . '</p>';
                })
                ->addColumn('vendor', function ($data) {
                    return  Vendors::where('id', $data->vendor_id)->pluck('name')->first();
                })
                ->addColumn('vehicle', function ($data) {
                    $vehicle = Vehicle::where('id', $data->vehicle_id)->pluck('model')->first();
                    return   BrandVehicle::where('id', $vehicle)->pluck('model_name')->first();
                })
                ->addColumn('payment_status', function ($data) {
                    if ($data->payment_status == 'Unpaid')
                        return '<span class="badge text-light-danger"> ' . $data->payment_status . '</span>';
                    elseif ($data->payment_status == 'Paid')
                        return  '<span class="badge text-light-success">' . $data->payment_status . '</span>';
                })
                ->addColumn('booked_by', function ($data) {
                    if ($data->role == 'Partner') {
                        $class = "success";
                    } else {
                        $class = "danger";
                    }
                    return   Partner::where('id', $data->booked_user_id)->pluck('name')->first() . '<br><p class="text-' . $class . '">(' . $data->role . ')</p>';
                })
                ->addColumn('booking_status', function ($data) {
                    if ($data->booking_status == 'Upcoming') {
                        $class = "warning";
                    } elseif ($data->booking_status == 'Confirmed') {
                        $class = "info";
                    } elseif ($data->booking_status == 'Running') {
                        $class = "primary";
                    } elseif ($data->booking_status == 'Completed') {
                        $class = "success";
                    } elseif ($data->booking_status == 'Canceled') {
                        $class = "danger";
                    }

                    if ($data->booking_status == 'Upcoming') {
                        $html = '<a href="#" class="position-relative text-bg-' . $class . ' px-2 py-1 b-r-10">
                                    ' . $data->booking_status . '
                                    <span class="position-absolute top-0 start-100 translate-middle p-1 bg-' . $class . ' rounded-circle animate__animated animate__fadeIn animate__infinite animate__fast"></span>
                                </a>';
                    } else {

                        $html = '<a href="#" class="position-relative text-bg-' . $class . ' px-2 py-1 b-r-10">
                                    ' . $data->booking_status . '</a>';
                    }
                    return $html;
                })
                ->addColumn('total_km', function ($data) {
                    return  $data->total_km;
                })
                ->addColumn('total_fare', function ($data) {
                    return  $data->total_fare;
                })

                ->escapeColumns([])

                ->make(true);
        }
    }


    public function getBookingDetails(Request $request)
    {

        $booking = BookingHistory::select(
            'booking_histories.*',
            'reviews.driver_rating',
            'reviews.car_rating',
            'reviews.comment'
        )
            ->leftJoin('reviews', 'booking_histories.id', '=', 'reviews.booking_id')
            ->where('booking_histories.booking_id', $request->id)
            ->first();
        $booking->makeHidden(['created_at', 'updated_at']);
        // ********** stay location  *********
        $raw = $booking->stay_locations; // The double-encoded JSON string
        $firstDecode = json_decode($raw, true);              // returns a JSON string
        $locationsArray = json_decode($firstDecode, true);   // returns the actual PHP array
        $booking->stay_locations = $locationsArray;
        // ********** stay date end  *********

        // ********** find titile  *********
        $departure = Carbon::parse($booking->departure_date);
        $return = Carbon::parse($booking->return_date);

        // Total days (inclusive)
        $totalDays = $departure->diffInDays($return) + 1; // +1 to include both start and end dates
        $nightCount = $totalDays - 1;

        // Final title
        $tripTitle = "{$nightCount}NIGHTS {$totalDays}DAYS";
        $booking->title = $tripTitle;
        // ********** find titile end  *********

        // ********** stay date  *********
        $raw = $booking->stay_date; // The double-encoded JSON string

        $firstDecode = json_decode($raw, true);              // returns a JSON string
        $locationsArray = json_decode($firstDecode, true);   // returns the actual PHP array

        $booking->stay_date = $locationsArray;
        // ********** stay date end *********
        $vehicle = Vehicle::join('drivers', 'vehicles.driver_id', '=', 'drivers.id')
            ->join('vendors', 'vehicles.vendor_id', '=', 'vendors.id')
            ->leftJoin('reviews', 'vehicles.id', '=', 'reviews.vehicle_id')
            ->leftJoin('booking_histories', 'vehicles.id', '=', 'booking_histories.vehicle_id')
            ->select(
                'vehicles.id',
                'vehicles.seats',
                'vehicles.fuel_type',
                'vehicles.model',
                'vehicles.vehicle_make',
                'vehicles.image',
                'vendors.name as vendor_name',
                'vendors.vendor_image',
                DB::raw('AVG(reviews.overall_rating) as avg_rating'),
                DB::raw('COUNT(booking_histories.id) as total_trips')
            )
            ->where('vehicles.id', $booking->vehicle_id)
            ->groupBy(
                'vehicles.id',
                'vehicles.seats',
                'vehicles.fuel_type',
                'vehicles.model',
                'vehicles.vehicle_make',
                'vehicles.image',
                'vendors.name',
                'vendors.vendor_image'
            )
            ->first();
        // $vehicle =  Vehicle::join('vendors', 'vehicles.vendor_id', '=', 'vendors.id')
        //                ->join('drivers', 'drivers.vendor_id', '=', 'vendors.id')
        //                 ->select('vehicles.id','vehicles.seats','vehicles.fuel_type','vehicles.model','vehicles.vehicle_make','vehicles.image', 'vendors.name as vendor_name','vendors.vendor_image') // select vendor fields as needed
        //                 ->where('vehicles.id',$booking->vehicle_id)
        //                 ->first();

        $vehicle->model = BrandVehicle::where('id', $vehicle->model)->pluck('model_name')->first();
        foreach (json_decode($vehicle->image) as $i => $img) {
            if ($i == 3) {
                break; // Stop looping once 3 images collected
            }
            $gallery_images[$i] = asset('uploads/vehicle/' . $img); // or Storage::url($img) if using storage
        }

        if ($vehicle->vendor_image == NULL) {
            $vehicle->vendor_image = asset('assets/images/user.jpg');
        } else {
            $vehicle->vendor_image = asset('uploads/vendor/' . $vehicle->vendor_image);
        }
        $vehicle->image = $gallery_images;
        $vehicle->review_rate = 5;

        $booking->cab_agency_details = $vehicle;
        $driver = Driver::select('name', 'image')->where('id', $booking->driver_id)->first();
        if ($driver != null) {
            if ($driver->image == NULL) {
                $driver->image = asset('assets/images/user.jpg');
            } else {
                $driver->image = asset('uploads/driver/' . $driver->image);
            }
        }

        // trip life cycle
        $res = BookingHistory::where('booking_id', $request->id)->first();

        // Calculate remaining km
        $lastTrip = TripLifeCycle::where('booking_id', $res->id)->orderBy('id', 'DESC')->first();
        $remainingKM = $lastTrip ? $lastTrip->remaining_km : $res->total_km;
        $res->remainingKM = $remainingKM;

        // Fetch all existing trip life cycles for this booking, keyed by date
        $existingLifeCycles = TripLifeCycle::where('booking_id', $res->id)
            ->get()
            ->keyBy(function ($item) {
                return Carbon::parse($item->date)->format('Y-m-d');
            });

        // Pass BOTH variables to the view


        return view('web.drivers.booking-details', [
            'data' => $booking,
            'driver' => $driver,
            'lifecycle' => $res,
            'existingLifeCycles' => $existingLifeCycles
        ]);
    }

    public function addtriplifecycle(Request $request)
    {
        $res = BookingHistory::where('booking_id', $request->id)->first();

        // Calculate remaining km
        $lastTrip = TripLifeCycle::where('booking_id', $res->id)->orderBy('id', 'DESC')->first();
        $remainingKM = $lastTrip ? $lastTrip->remaining_km : $res->total_km;
        $res->remainingKM = $remainingKM;

        // Fetch all existing trip life cycles for this booking, keyed by date
        $existingLifeCycles = TripLifeCycle::where('booking_id', $res->id)
            ->get()
            ->keyBy(function ($item) {
                return Carbon::parse($item->date)->format('Y-m-d');
            });

        // Pass BOTH variables to the view
        return view('web.drivers.add-lifecycle', [
            'data' => $res,
            'existingLifeCycles' => $existingLifeCycles
        ]);
    }
}
