<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\BookingHistory;
use Carbon\Carbon;
use App\Models\BrandVehicle;
use App\Models\Vehicle;
use App\Models\Driver;
use App\Models\Vendors;

class SendTripReminder extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:send-trip-reminder';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $now = Carbon::now();
        $tomorrow = Carbon::now()->addDay()->format('Y-m-d');
        // $tomorrow = Carbon::now()->format('Y-m-d');
        $bookings = BookingHistory::where('departure_date', $tomorrow)
            ->where('booking_status', 'Confirmed')
            ->get();
        foreach ($bookings as $booking) {

            $driver = Driver::find($booking->driver_id);
            $vehicle = Vehicle::find($booking->vehicle_id);
            $brandModel = $vehicle ? BrandVehicle::find($vehicle->model) : null;

            $bookingId = $booking->booking_id;
            $driverName = $driver?->name ?? 'N/A';
            $driverContact = $driver?->phone ?? 'N/A';
            $vehicleName = $vehicle?->vehicle_make . ' ' . ($brandModel?->model_name ?? '');

            $vendorcontact= Vendors::where('id',$booking->vendor_id)->pluck('phone')->first();

            $vehicleCategoryName = Vehicle::join('vehicle_categories', 'vehicles.vehicle_type', '=', 'vehicle_categories.id')
                ->where('vehicles.id', $booking->vehicle_id)
                ->value('vehicle_categories.name');

            $datetime = $booking->departure_date . ' ' . $booking->departure_time;
            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://api.connectpanels.com/whatsapp-api/v1.0/customer/120180/bot/0d094a19d57e4eaa/template',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => '{"payload":{"name":"trip_reminder_01","components":[{"type":"body","parameters":[{"type":"text","text":"' . $booking->booking_id . '"},{"type":"text","text":"' . $booking->departure_date . '"},{"type":"text","text":"' . $driverName . '"},{"type":"text","text":"' . $driverContact . '"},{"type":"text","text":"' . $vehicleName . '"}]}],"language":{"code":"en_US","policy":"deterministic"},"namespace":"66cbcb46_a232_4519_a6e7_b69fd50991bf"},"phoneNumber":"+919188360241"}',
                CURLOPT_HTTPHEADER => array(
                    'Authorization: Basic c4d8e3eb-4e7c-4f9d-a05c-5ff0bf583d29-Ic1uEZu',
                    'Content-Type: application/json'
                ),
            ));

            $response = curl_exec($curl);

            curl_close($curl);

            // *********** trip remainder for vendor


            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://api.connectpanels.com/whatsapp-api/v1.0/customer/120180/bot/0d094a19d57e4eaa/template',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => '{"payload":{"name":"vendor_trip_alert","components":[{"type":"body","parameters":[{"type":"text","text":"' . $booking->booking_id . '"},{"type":"text","text":"' . $booking->client_name . '"},{"type":"text","text":"' . $booking->client_mobile_number . '"},{"type":"text","text":"' . $driverName . '"},{"type":"text","text":"' . $driverContact . '"},{"type":"text","text":"' . $vehicleCategoryName . '"},{"type":"text","text":"' . $datetime . '"},{"type":"text","text":"' . $booking->pick_up . '"}]}],"language":{"code":"en_US","policy":"deterministic"},"namespace":"66cbcb46_a232_4519_a6e7_b69fd50991bf"},"phoneNumber":"'.$vendorcontact.'"}',
                CURLOPT_HTTPHEADER => array(
                    'Authorization: Basic c4d8e3eb-4e7c-4f9d-a05c-5ff0bf583d29-Ic1uEZu',
                    'Content-Type: application/json'
                ),
            ));

            $response = curl_exec($curl);

            curl_close($curl);
        }
        return Command::SUCCESS;
    }
}
