<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\CategoryController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\SubCategoryController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\BannerController;
use App\Http\Controllers\CouponController;
use App\Http\Controllers\StockController;

Route::get('/', function () {
    return view('auth.login');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // Room routes

    Route::get('/room', function () {
        return view('admin.product.room');
    })->name('room.index');
    Route::controller(SettingsController::class)->group(function () {
        Route::get('/get/room', 'getroom')->name('get-room');
        Route::post('/add/room', 'addroom')->name('add-room');
        Route::delete('/delete-room/{id}', 'destroy')->name('delete-room');
        Route::put('/update-room/{id}', 'update')->name('update-room');

        // room routes

    });
   // tag routes

    Route::get('/tags', function () {
        return view('admin.product.tags');
    })->name('tag.index');
    Route::controller(SettingsController::class)->group(function () {
        Route::get('/get/tag', 'gettag')->name('get-tag');
        Route::post('/add/tag', 'addtag')->name('add-tag');
        Route::delete('/delete-tag/{id}', 'destroytag')->name('delete-tag');
        Route::put('/update-tag/{id}', 'updatetag')->name('update-tag');

    });
        // tag routes


    // category routes
    Route::get('/category', function () {
        return view('admin.product.category');
    })->name('category.index');

    // Settings Controller routes
    Route::controller(CategoryController::class)->group(function () {
        Route::get('/get/category', 'getcategory')->name('get-category');
        Route::post('/add/category', 'addcategory')->name('add-category');
        Route::delete('/delete-category/{id}', 'destroy')->name('delete-category');
        Route::put('/update-category/{id}', 'update')->name('update-category');
    });
    // category routes


    // subcategory start 
    // SubCategory Routes
    Route::get('/subcategory', function () {
        return view('admin.product.subcategory');
    })->name('subcategory');

    Route::get('/get-subcategory', [SubCategoryController::class, 'getSubCategory'])->name('get-subcategory');
    Route::post('/add-subcategory', [SubCategoryController::class, 'addSubCategory'])->name('add-subcategory');
    Route::post('/update-subcategory/{id}', [SubCategoryController::class, 'update'])->name('update-subcategory');
    Route::delete('/delete-subcategory/{id}', [SubCategoryController::class, 'destroy'])->name('delete-subcategory');
    Route::post('/toggle-subcategory-status/{id}', [SubCategoryController::class, 'toggleStatus'])->name('toggle-subcategory-status');

    // subcategory end

    //products start
    Route::get('/add-product', function () {
        return view('admin.product.add-product');
    })->name('add-product');
    Route::post('product-store', [ProductController::class, 'store'])->name('product.store');
    Route::get('get-subcategories/{category_id}', function ($category_id) {
        return App\Models\SubCategory::where('category_id', $category_id)->get(['id', 'name']);
    });

    Route::post('/products/step-one', [ProductController::class, 'storeStepOne'])
        ->name('products.step.one');
    Route::post('/products/step-two', [ProductController::class, 'storeStepTwo'])
        ->name('product.step2.store');
    Route::post('/product-images', [ProductController::class, 'storeImages'])
        ->name('product.images.store');
    Route::post('/product/stock', [ProductController::class, 'storeStock'])
        ->name('stocks.store');
    Route::get('product-list', [ProductController::class, 'index'])->name('products');
    Route::get('get-product-list', [ProductController::class, 'getProducts'])->name('get-products');

    Route::get('get-product/{id}', [ProductController::class, 'show'])->name('edit-product');
    Route::delete('delete-product/{id}', [ProductController::class, 'destroy']);
    Route::post(
        'products/step-one/update',
        [ProductController::class, 'stepOneUpdate']
    )->name('products.step.one.update');

    Route::post(
        'products/step-two/update',
        [ProductController::class, 'stepTwoUpdate']
    )->name('products.step.two.update');

    Route::post(
        'products/step-three/update',
        [ProductController::class, 'stepThreeUpdate']
    )->name('products.step.three.update');

    Route::post(
        'products/image/delete',
        [ProductController::class, 'deleteImage']
    )->name('products.image.delete');


    Route::post('product/step-four/update', [ProductController::class, 'updateStock'])
        ->name('products.step.four.update');
    // web.php
    Route::delete('/stocks/{stock}', [ProductController::class, 'destroyStock'])->name('stocks.destroy');


    // banner start
    Route::get('banner', function () {
        return view('admin.banner');
    })->name('banner');
    Route::get('get-banner', [BannerController::class, 'getBanner'])->name('get-banner');
    Route::post('add-banner', [BannerController::class, 'addBanner'])->name('add-banner');
    Route::delete('delete-banner/{id}', [BannerController::class, 'destroy']);
    Route::put('update-banner/{id}', [BannerController::class, 'update']);
    Route::get('banner/get-products/{category_id}', [ProductController::class, 'getProductsByCategory']);
    Route::post('banner/status/{id}', [BannerController::class, 'changeStatus'])->name('banner.status');

    // banner end

    // gift offers



    //coupon
    Route::get('/coupons', [CouponController::class, 'index'])->name('coupons');
    Route::get('/get-coupons', [CouponController::class, 'getCoupons'])->name('get-coupons');
    Route::post('/add-coupon', [CouponController::class, 'store'])->name('add-coupon');
    Route::get('/coupon/edit/{id}', [CouponController::class, 'edit']);
    Route::post('/coupon/update/{id}', [CouponController::class, 'update']);
    Route::delete('/delete-coupon/{id}', [CouponController::class, 'destroy']);
    Route::post('/coupon/status/{id}', [CouponController::class, 'changeStatus']);


    Route::get('/get-products/{category_id}', [CouponController::class, 'getProducts']);


    Route::get('/coupons/{id}/edit', [CouponController::class, 'edit']);
    Route::get('/get-countries-list', [CouponController::class, 'getCountries']); // helper route

    // end coupon
    Route::get('stock-inventory', [StockController::class, 'index'])->name('stock.index');
    Route::get('get-stock', [StockController::class, 'getStock'])->name('stock.list');

    Route::get('/stock-view/{id}', [StockController::class, 'view'])->name('stock.view');
    Route::get('/stock-edit/{id}', [StockController::class, 'edit'])->name('stock.edit');
    Route::get('/stock/{location}', [StockController::class, 'viewStocks'])
        ->name('stock.view.details');


    // locations Routes
    Route::get('/locations', function () {
        return view('admin.stock.locations');
    })->name('locations');

    Route::get('/get-locations', [StockController::class, 'getlocations'])->name('get-locations');
    Route::post('/add-locations', [StockController::class, 'addlocations'])->name('add-locations');
    Route::post('/update-locations/{id}', [StockController::class, 'update'])->name('update-locations');
    Route::delete('/delete-locations/{id}', [StockController::class, 'destroy'])->name('delete-locations');
});

require __DIR__ . '/auth.php';
