@extends('admin.layout.template')
@section('title', 'Stock Details')

@section('content')

<div class="page-content">
    <div class="container-xxl">

        <!-- Header -->
        <div class="card mb-3">
            <div class="card-body d-flex justify-content-between align-items-center">
                <div>
                    <h4 class="mb-0">{{ $location->name }}</h4>
                    <small class="text-muted">{{ $location->type }}</small>
                </div>
                <a  href="{{route('stock.index')}}" class="btn btn-light">
                    ← Back to Stock List
                </a>
            </div>
        </div>

        <!-- Table -->
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover align-middle" id="stockTable">
                        <thead class="bg-light">
                            <tr>
                                <th>#</th>
                                <th>Product</th>
                                <th>Variant</th>
                                <th>Available Qty</th>
                                <th>Reorder Level</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>
<script>
$(function () {
    $('#stockTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ route('stock.view.details', $location->id) }}",
        order: [[1, 'asc']],
        columns: [
            { data: 'DT_RowIndex', orderable: false, searchable: false },
            { data: 'product', name: 'productVariant.product.name' },
            { data: 'variant', name: 'productVariant.name' },
            { data: 'available_qty', name: 'available_qty' },
            { data: 'reorder_level', name: 'reorder_level' },
            { data: 'status', orderable: false, searchable: false }
        ]
    });
});
</script>

@endsection


