@extends('admin.layout.template')
@section('title', 'Sub location')
@section('content')

<div class="page-content">
    <div class="container-xxl">

        <!-- Add Form -->
        <div class="card mb-4">
            <div class="card-header d-flex justify-content-between">
                <h5>Add Sub location</h5>
            </div>
            <div class="card-body">
                <form id="addlocationsForm" enctype="multipart/form-data">
                    @csrf
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label class="form-label">Type</label>
                            <select name="type" class="form-control" required>
                                <option value="">Select Stock type</option>
                              <option value="Warehouse">Warehouse</option>
                              <option value="Franchise">Franchise</option>
                                    <option value="Store">Store</option>    
                            </select>
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">Location name/address</label>
                            <input type="text" name="name" class="form-control" placeholder="Enter locations name" required>
                        </div>

                       

                         <!-- Image Upload -->
            <div class="col-lg-4">
                <div class="text-start mt-3">
                        <button type="submit" class="btn btn-success">Save</button>
                    </div>
            </div>
  
                    </div>
                </form>
            </div>
        </div>

        <!-- DataTable -->
        <div class="card">
            <div class="card-body table-responsive">
                <table class="table table-bordered align-middle text-center">
                    <thead class="table-light">
                        <tr>
                            <th>SL.NO</th>
                            <th>Location</th>
                            <th>Type</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editSubCatModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="editlocationsForm" enctype="multipart/form-data">
                @csrf
                <div class="modal-header">
                    <h5>Edit Sub location</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="id" id="edit_id">
                    <div class="mb-3">
                        <label>Type</label>
                        <select name="type" id="edit_type" class="form-control">
                           <option value="Warehouse">Warehouse</option>
                              <option value="Franchise">Franchise</option>
                                    <option value="Store">Store</option>    
                        </select>
                    </div>
                    <div class="mb-3">
                        <label>Location name/address</label>
                        <input type="text" name="name" id="edit_name" class="form-control">
                    </div>
   

                </div>
                <div class="modal-footer">
                    <button class="btn btn-success" type="submit">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
$(function(){
    var table = $('.table').DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ route('get-locations') }}",
        columns: [
            {data:'DT_RowIndex', name:'DT_RowIndex'},
            {data:'name', name:'name'},
            {data:'type', name:'type'},
            {data:'action', name:'action'},
        ],
    });

    // Add
    $('#addlocationsForm').on('submit', function(e){
        e.preventDefault();
        $.ajax({
            url:"{{ route('add-locations') }}",
            method:"POST",
            data:new FormData(this),
            processData:false,
            contentType:false,
            success:function(res){
                Swal.fire({icon:'success',title:res.success,showConfirmButton:false,timer:1500});
                $('#addlocationsForm')[0].reset();
                table.ajax.reload();
            }
        });
    });

    // Edit open
$(document).on('click', '.editlocation', function () {
    $('#edit_id').val($(this).data('id'));
    $('#edit_name').val($(this).data('name'));
    $('#edit_type').val($(this).data('location'));

    let image = $(this).data('image');
    $('#editSubPreview').attr('src', image);

    $('#editSubCatModal').modal('show');
});


    // Update
    $('#editlocationsForm').on('submit', function(e){
        e.preventDefault();
        var id = $('#edit_id').val();
        $.ajax({
            url:'/update-locations/'+id,
            method:'POST',
            data:new FormData(this),
            processData:false,
            contentType:false,
            success:function(res){
                Swal.fire({icon:'success',title:res.success,showConfirmButton:false,timer:1500});
                $('#editSubCatModal').modal('hide');
                table.ajax.reload();
            }
        });
    });

    // Delete
    $(document).on('click','.deletelocation', function(){
        var id=$(this).data('id');
        Swal.fire({
            title:'Are you sure?',text:'You will not be able to revert this!',icon:'warning',
            showCancelButton:true,confirmButtonColor:'#3085d6',cancelButtonColor:'#d33',
            confirmButtonText:'Yes, delete it!'
        }).then((result)=>{
            if(result.isConfirmed){
                $.ajax({
                    url:'/delete-locations/'+id,
                    method:'DELETE',
                    data:{_token:'{{csrf_token()}}'},
                    success:function(res){
                        Swal.fire({icon:'success',title:res.success,showConfirmButton:false,timer:1500});
                        table.ajax.reload();
                    }
                });
            }
        });
    });


});
</script>

@endsection
