@extends('admin.layout.template')
@section('title', 'Stock & Inventory')

@section('content')

<style>
    .stock-type-filter .btn {
    border-radius: 20px;
    padding: 6px 18px;
    font-weight: 500;
}

.stock-type-filter .btn.active {
    background-color: #4f5dff;
    color: #fff;
    border-color: #4f5dff;
}

</style>
<div class="page-content ">
<div class="container-xxl">
    <!-- DASHBOARD CARDS -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card p-3">
                       <div class="card-body">
                                        <div class="d-flex align-items-center justify-content-between">
                                             <div>
                                                  <h4 class="card-title mb-2 d-flex align-items-center gap-2">Total Items </h4>
                                                  <p class="text-muted fw-medium fs-22 mb-0">{{ $totalItems }} <span class="fs-12">(Items)</span></p>
                                             </div>
                                             <div>
                                                  <div class="avatar-md bg-primary bg-opacity-10 rounded">
                                                       <iconify-icon icon="solar:box-broken" class="fs-32 text-primary avatar-title"></iconify-icon>
                                                  </div>
                                             </div>
                                        </div>
                                   </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card p-3">
                 <div class="card-body">
                                        <div class="d-flex align-items-center justify-content-between">
                                             <div>
                                                  <h4 class="card-title mb-2 d-flex align-items-center gap-2">In Stock  </h4>
                                                  <p class="text-muted fw-medium fs-22 mb-0">{{ $inStock }} <span class="fs-12">(Items)</span></p>
                                             </div>
                                             <div>
                                                  <div class="avatar-md bg-primary bg-opacity-10 rounded">
                                                       <iconify-icon icon="solar:reorder-broken" class="fs-32 text-primary avatar-title"></iconify-icon>
                                                  </div>
                                             </div>
                                        </div>
                                   </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card p-3">
                <div class="card-body">
                                        <div class="d-flex align-items-center justify-content-between">
                                             <div>
                                                  <h4 class="card-title mb-2 d-flex align-items-center gap-2">Out Of Stock </h4>
                                                  <p class="text-muted fw-medium fs-22 mb-0">{{ $outOfStock }} <span class="fs-12">(Items)</span></p>
                                             </div>
                                             <div>
                                                  <div class="avatar-md bg-primary bg-opacity-10 rounded">
                                                       <iconify-icon icon="solar:bag-cross-broken" class="fs-32 text-primary avatar-title"></iconify-icon>
                                                  </div>
                                             </div>
                                        </div>
                                   </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card p-3">
                     <div class="card-body">
                                        <div class="d-flex align-items-center justify-content-between">
                                             <div>
                                                  <h4 class="card-title mb-2 d-flex align-items-center gap-2">Low Stock</h4>
                                                  <p class="text-muted fw-medium fs-22 mb-0">{{ $lowStock }}</p>
                                             </div>
                                             <div>
                                                  <div class="avatar-md bg-primary bg-opacity-10 rounded">
                                                       <iconify-icon icon="solar:users-group-two-rounded-broken" class="fs-32 text-primary avatar-title"></iconify-icon>
                                                  </div>
                                             </div>
                                        </div>
                                   </div>
            
            </div>
        </div>
    </div>

    <!-- FILTER -->
    <div class="card mb-3">
        <div class="card-body">
            <div class="d-flex align-items-center gap-2 mb-3">
    <span class="fw-semibold me-2">Stock Type</span>

    <div class="btn-group stock-type-filter" role="group">
        <button type="button" class="btn btn-outline-primary active" data-type="">
            All
        </button>
        <button type="button" class="btn btn-outline-primary" data-type="Warehouse">
            Warehouse
        </button>
        <button type="button" class="btn btn-outline-primary" data-type="Franchise">
            Franchise
        </button>
        <button type="button" class="btn btn-outline-primary" data-type="Store">
            Store
        </button>
    </div>
</div>


           
        </div>
    </div>

    <!-- TABLE -->
    <div class="card">
        <div class="card-body">
            <table class="table table-hover" id="stockTable">
                <thead>
                    <tr>
            <th>
                <input type="checkbox">
            </th>
            <th>Location</th>
            <th>Type</th>
            <th>Total Items</th>
            <th>In Stock</th>
            <th>Out of Stock</th>
            <th>Total Stock Qty</th>
            <th>Action</th>
        </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
</div>
<script>
        let selectedType = '';

$('.stock-type-filter .btn').on('click', function () {
    $('.stock-type-filter .btn').removeClass('active');
    $(this).addClass('active');

    selectedType = $(this).data('type');

    $('.table').DataTable().ajax.reload();
});
$(function () {
$('.table').DataTable({
    processing: true,
    serverSide: true,
    ajax: {
        url: "{{ route('stock.list') }}",
        data: function (d) {
         //   d.type = $('#stockType').val();
            d.type = selectedType;
        }
    },
    order: [[1, 'asc']],
    columns: [
        { data: 'DT_RowIndex', orderable: false, searchable: false },
        { data: 'location' },
        { data: 'type' },
        { data: 'total_items' },
        { data: 'in_stock', orderable: false },
        { data: 'out_of_stock' },
        { data: 'total_stock_qty' },
        { data: 'action', orderable: false, searchable: false }
    ]
});


    $('#stockType').change(function () {
        table.ajax.reload();
    });



});
</script>
@endsection
