@extends('admin.layout.template')
@section('title', 'Category')
@section('content')

<div class="page-content">
    <div class="container-xxl">

        <!-- Add Category Card -->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title d-flex align-items-center gap-1">
                            <iconify-icon icon="solar:settings-bold-duotone" class="text-primary fs-20"></iconify-icon>
                            Add Category
                        </h4>
                    </div>
                    <div class="card-body">
    <form id="addCategoryForm" enctype="multipart/form-data">
        @csrf

        <div class="row align-items-end">

            <!-- Category Name -->
            <div class="col-lg-5">
                <div class="mb-3">
                    <label class="form-label fw-medium">Category</label>
                    <input type="text"
                           name="name"
                           class="form-control"
                           placeholder="Enter category name"
                           required>
                </div>
            </div>

            <!-- Image Upload -->
            <div class="col-lg-5">
                <div class="mb-3">
                    <label class="form-label fw-medium">Upload Image</label>
                    <input type="file"
                           name="photo"
                           class="form-control image-input"
                           accept="image/*">
                </div>
            </div>

            <!-- Image Preview -->
            <div class="col-lg-2 text-center">
                <label class="form-label fw-medium d-block">Preview</label>

                <div class="preview-box">
                    <img id="previewImage"
                         src="{{ asset('assets/images/default-category.JPG') }}"
                         class="img-fluid shadow-sm"
                         alt="Preview">
                </div>
            </div>

        </div>

        <div class="text-end mt-4">
            <button type="submit" class="btn btn-success px-4">
                Save Change
            </button>
        </div>
    </form>
</div>



                   
                </div>
            </div>
        </div>

        <!-- Category Table -->
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table align-middle mb-0 table-hover table-centered">
                                <thead class="bg-light-subtle">
                                    <tr>
                                        <th>SL.NO</th>
                                        <th>Category</th>
                                        <th>Image</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<script>
    // Pass countries as JSON

    $(document).ready(function() {

        // Initialize DataTable
        var table = $('.table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('get-category') }}",
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                },
                {
                    data: 'name',
                    name: 'name'
                },

                {
                    data: 'image',
                    name: 'image'
                },
                {
                    data: 'action',
                    name: 'action'
                },

            ],
            "select": {
                'style': 'multi',
                'selector': 'td:first-child' //only checkbox can select row 
            },
        });

        // Add Category via AJAX
        $('#addCategoryForm').submit(function(e) {
            e.preventDefault();
            var formData = new FormData(this);
            $.ajax({
                url: "{{ route('add-category') }}",
                type: "POST",
                data: formData,
                contentType: false,
                processData: false,
                success: function(response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Category Added!',
                        text: response.success,
                        timer: 1500,
                        showConfirmButton: false
                    });
                    $('#addCategoryForm')[0].reset();
                    table.ajax.reload();
                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    let errMsg = '';
                    $.each(errors, function(key, val) {
                        errMsg += val + '\n';
                    });
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops!',
                        text: errMsg,
                    });
                }
            });
        });

        // Delete Category
        $(document).on('click', '.deletecategory', function(e) {
            e.preventDefault();
            var id = $(this).data('id');
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel',
                customClass: {
                    popup: 'rounded-3 shadow-lg'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "{{ url('delete-category') }}/" + id,
                        type: 'DELETE',
                        data: {
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(response) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Deleted!',
                                text: response.success,
                                showConfirmButton: false,
                                timer: 1500
                            });
                            table.ajax.reload();
                        }
                    });
                }
            });
        });

        // Cancel inline edit
        $(document).on('click', '.cancelEdit', function() {
            table.ajax.reload();
        });
        // Inline Edit
      $(document).on('click', '.editcategory', function (e) {
    e.preventDefault();

    var row = $(this).closest('tr');
    var id = $(this).data('id');

    var name = row.find('td:eq(1)').text().trim();
    var imgSrc = row.find('td:eq(2) img').attr('src'); // IMAGE COLUMN INDEX

    // Name input
    row.find('td:eq(1)').html(
        '<input type="text" class="form-control form-control-sm edit-name" value="' + name + '">'
    );

    // Image input + preview
    row.find('td:eq(2)').html(`
        <input type="file"
               class="form-control form-control-sm edit-image"
               accept="image/*"
               data-preview="preview-${id}">
        <div class="mt-2 text-center">
            <img src="${imgSrc}"
                 id="preview-${id}"
                 style="height:60px;border-radius:8px;border:1px solid #ddd;">
        </div>
    `);

    // Action buttons
    $(this).replaceWith(`
        <button class="btn btn-sm btn-success savecategory" data-id="${id}">Save</button>
        <button class="btn btn-sm btn-secondary cancelEdit ms-1">Cancel</button>
    `);
});


$(document).on('change', '.edit-image', function () {
    const previewId = $(this).data('preview');
    const file = this.files[0];

    if (file) {
        $('#' + previewId).attr('src', URL.createObjectURL(file));
    }
});



        // Save inline edit
        $(document).on('click', '.savecategory', function() {
            var id = $(this).data('id');
            var row = $(this).closest('tr');
          //  var name = row.find('td:eq(1) input').val();
   //        var photoFile = row.find('td:eq(3) input[type=file]')[0].files[0];
   var name = row.find('.edit-name').val();
            var photoFile = row.find('.edit-image')[0]?.files[0];
            var formData = new FormData();
            formData.append('_token', '{{ csrf_token() }}');
            formData.append('_method', 'PUT');
            formData.append('name', name);

            if (photoFile) {
                formData.append('photo', photoFile);
            }

            $.ajax({
                url: "{{ url('update-category') }}/" + id,
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                success: function(response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Updated!',
                        text: response.success,
                        timer: 1500,
                        showConfirmButton: false
                    });
                    table.ajax.reload();
                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    let errMsg = '';
                    $.each(errors, function(k, v) {
                        errMsg += v + '\n';
                    });
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops!',
                        text: errMsg
                    });
                }
            });
        });


    });
</script>

@endsection