@extends('admin.layout.template')
@section('title','Add Product')
@php
$locations=App\Models\Location::all();
@endphp
@section('content')
<style>
.step-tab.disabled {
    pointer-events: none;
    opacity: 0.5;
}
</style>
<div class="page-content">
    <div class="container-xxl">


        <!-- STEP NAV -->
       <ul class="nav nav-tabs" id="productWizard">
    <li class="nav-item">
        <a class="nav-link active" data-step="0" href="#step1">Step 1: Product</a>
    </li>
    <li class="nav-item">
        <a class="nav-link disabled" data-step="1" href="#step2">Step 2: Variant</a>
    </li>
    <li class="nav-item">
        <a class="nav-link disabled" data-step="2" href="#step3">Step 3: Images</a>
    </li>
    <li class="nav-item">
        <a class="nav-link disabled" data-step="3" href="#step4">Step 4: Stock</a>
    </li>
</ul>



        <div class="tab-content mt-3">

            <div class="tab-pane fade show active" id="step1">
                <!-- STEP 1 -->
                <div class="step step-1" id="step1">
                    <div class="card p-3">
                        <h5>Product Details</h5>
                        <form id="stepOneForm">
                            @csrf
                            <div class="row g-3">
                                <div class="col-lg-6">
                                    <label class="form-label">Category</label>
                                    <select name="category_id" id="categorySelect" class="form-control" required>
                                        <option value="">Select Category</option>
                                        @foreach(App\Models\Category::all() as $cat)
                                        <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-lg-6">
                                    <label class="form-label">Subcategory</label>
                                    <select name="sub_category_id" id="subcategorySelect" class="form-control">
                                        <option value="">Select Subcategory</option>
                                    </select>
                                </div>

                                {{-- Product Name --}}
                                <div class="col-md-6">
                                    <label class="form-label">Product Name *</label>
                                    <input type="text" name="name" class="form-control" required>
                                </div>

                                {{-- Material --}}
                                <!-- <div class="col-md-6">
                            <label class="form-label">Material</label>
                            <input type="text" name="material" class="form-control">
                        </div> -->

                                {{-- Pattern --}}
                                <!-- <div class="col-md-6">
                            <label class="form-label">Pattern</label>
                            <input type="text" name="pattern" class="form-control">
                        </div> -->


                                {{-- Features --}}
                                <div class="col-md-6">
                                    <label class="form-label">Additional Features</label>
                                    <input type="text" name="features" class="form-control"
                                        placeholder="Blackout, Washable">
                                </div>

                                {{-- Warranty --}}
                                <div class="col-md-6">
                                    <label class="form-label">Warranty / Certification</label>
                                    <input type="text" name="warranty_certification" class="form-control"
                                        placeholder="ISO / 1 Year">
                                </div>

                                {{-- Maintenance --}}
                                <div class="col-md-6">
                                    <label class="form-label">Maintenance</label>
                                    <input type="text" name="maintenance" class="form-control"
                                        placeholder="Dry clean / Spot clean">
                                </div>

                                {{-- Rooms (Multiple) --}}
                                <div class="col-md-6">
                                    <label class="form-label">Rooms *</label>
                                    <select name="rooms[]" class="form-control" multiple data-choices required>
                                        @foreach(App\Models\Room::all() as $room)
                                        <option value="{{ $room->id }}">{{ $room->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                {{-- Tags (Multiple) --}}
                                <div class="col-md-6">
                                    <label class="form-label">Tags</label>
                                    <select name="tags[]" class="form-control" multiple data-choices>
                                        @foreach(App\Models\Tags::all() as $tag)
                                        <option value="{{ $tag->id }}">{{ $tag->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                {{-- Measurement --}}
                                <div class="col-md-12">
                                    <label class="form-label">Measurement</label>
                                    <textarea name="measurement" class="form-control" rows="4"></textarea>
                                    <!-- <input type="text" name="measurement" class="form-control"
                                placeholder="120x60 cm / 54 inch"> -->
                                </div>

                                {{-- Description --}}
                                <div class="col-md-12">
                                    <label class="form-label">Description</label>
                                    <textarea name="description" class="form-control" rows="4"></textarea>
                                </div>

                            </div>
                            <div class="text-end mt-4">
                                <button type="submit" class="btn btn-primary">
                                    Save & Continue →
                                </button>
                            </div>

                        </form>
                    </div>
                </div>

                <button class="btn btn-primary next-step">Next</button>
            </div>

            <div class="tab-pane fade" id="step2">
                <!-- Step 2 content -->
                <!-- STEP 2 -->

                <div class="step step-2">
                    <form id="stepTwoForm">
                        @csrf

                        {{-- Product ID from Step 1 --}}
                        <input type="hidden" name="product_id" id="product_id">

                        <div class="card p-3">
                            <h5>Variant / SKU Details</h5>

                            <div class="row g-3">

                                <div class="col-md-4">
                                    <label>SKU *</label>
                                    <input type="text" name="sku" class="form-control" required>
                                </div>

                                <div class="col-md-4">
                                    <label>Batch No</label>
                                    <input type="text" name="batch_no" class="form-control">
                                </div>

                                <div class="col-md-4">
                                    <label>Unit *</label>
                                    <select name="unit" class="form-control" required>
                                        <option value="">Select</option>
                                        <option>cm</option>
                                        <option>inch</option>
                                        <option>mtr</option>
                                        <option>sqft</option>
                                        <option>nos</option>
                                    </select>
                                </div>

                                <div class="col-md-4">
                                    <label>Dimensions</label>
                                    <input type="text" name="dimensions" class="form-control"
                                        placeholder="120x60 cm / 72x36 inch">
                                </div>

                                <div class="col-md-4">
                                    <label>Material / Fabric Composition</label>
                                    <input type="text" name="material_or_fabric_composition" class="form-control"
                                        placeholder="Cotton 60% + Polyester 40%">
                                </div>

                                <div class="col-md-4">
                                    <label>Pattern</label>
                                    <input type="text" name="pattern" class="form-control"
                                        placeholder="Plain / Floral / Geometric">
                                </div>

                                <div class="col-md-3">
                                    <label>Color Name</label>
                                    <input type="text" name="color_name" class="form-control">
                                </div>

                                <div class="col-md-3">
                                    <label>Color Code</label>
                                    <input type="color" name="color_code" class="form-control">
                                </div>

                                <div class="col-md-3">
                                    <label>GSM</label>
                                    <input type="number" step="0.01" name="gsm" class="form-control">
                                </div>

                                <div class="col-md-3">
                                    <label>Weight (kg)</label>
                                    <input type="number" step="0.01" name="weight" class="form-control">
                                </div>

                                <div class="col-md-3">
                                    <label>Rub Count</label>
                                    <input type="number" name="rub_count" class="form-control">
                                </div>

                                <div class="col-md-3">
                                    <label>MOQ</label>
                                    <input type="number" name="moq" class="form-control">
                                </div>

                                <div class="col-md-3">
                                    <label>MRP *</label>
                                    <input type="number" name="mrp" class="form-control" required>
                                </div>

                                <div class="col-md-3">
                                    <label>Offer Price *</label>
                                    <input type="number" name="offer_price" class="form-control" required>
                                </div>

                            </div>
                        </div>

                        <div class="text-end mt-4">
                            <button type="submit" class="btn btn-primary">
                                Save Variant & Continue →
                            </button>
                        </div>
                    </form>
                </div>

                <button class="btn btn-secondary prev-step">Back</button>
                <button class="btn btn-primary next-step">Next</button>
            </div>

            <div class="tab-pane fade" id="step3">
                <!-- Step 3 content -->
                <!-- STEP 3 -->
                <div class="step step-3">
                    <form id="stepThreeForm" enctype="multipart/form-data">
                        @csrf

                        {{-- variant_id from Step 2 --}}
                        <input type="hidden" name="product_variant_id" id="product_variant_id">

                        <div class="card p-3">
                            <h5>Product Images</h5>

                            <input type="file" id="imageInput" class="form-control" multiple accept="image/*">

                            <div class="row mt-3" id="imagePreview"></div>
                        </div>

                        <div class="text-end mt-4">
                            <button type="submit" class="btn btn-primary">
                                Save Images →
                            </button>
                        </div>
                    </form>
                </div>

                <button class="btn btn-secondary prev-step">Back</button>
                <button class="btn btn-primary next-step">Next</button>
            </div>

            <div class="tab-pane fade" id="step4">
                <!-- Step 3 content -->
                <!-- STEP 4 -->
                <div class="step step-4">
                    <form id="stepFourForm">
                        @csrf
                        <input type="hidden" name="product_variant_id" id="variant_id">

                        <div class="card p-3">
                            <h5>Stock Management</h5>

                            <div id="stockRows">
                                <div class="row g-3 stock-row">
                                    <div class="col-md-4">
                                        <label>Location *</label>
                                        <select name="stocks[0][location_id]" class="form-control" required>
                                            <option value="">Select Location</option>
                                            @foreach($locations as $loc)
                                            <option value="{{ $loc->id }}">{{ $loc->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="col-md-3">
                                        <label>Available Qty *</label>
                                        <input type="number" step="0.01" name="stocks[0][available_qty]"
                                            class="form-control" required>
                                    </div>

                                    <div class="col-md-3">
                                        <label>Reorder Level</label>
                                        <input type="number" step="0.01" name="stocks[0][reorder_level]"
                                            class="form-control">
                                    </div>

                                    <div class="col-md-2 d-flex align-items-end">
                                        <button type="button" class="btn btn-danger removeRow d-none">✕</button>
                                    </div>
                                </div>
                            </div>

                            <button type="button" id="addStockRow" class="btn btn-outline-secondary mt-3">
                                + Add Location Stock
                            </button>
                        </div>

                        <div class="text-end mt-4">
                            <button type="submit" class="btn btn-success">
                                Save Stock & Finish →
                            </button>
                        </div>
                    </form>
                </div>

                <button class="btn btn-secondary prev-step">Back</button>
                <button class="btn btn-success">Finish</button>
            </div>
        </div>

        <!-- NAV BUTTONS -->

    </div>
</div>
<script>
    let step = 1;
let completedSteps = {
    0: true,   // Step 1 allowed initially
    1: false,
    2: false,
    3: false
};

    $('.next').click(function() {
        $('.step-' + step).addClass('d-none');
        step++;
        $('.step-' + step).removeClass('d-none');
        if (step == 4) {
            $('.next').hide();
            $('#submitBtn').removeClass('d-none');
        }
    });

    $('.prev').click(function() {
        if (step > 1) {
            $('.step-' + step).addClass('d-none');
            step--;
            $('.step-' + step).removeClass('d-none');
            $('.next').show();
            $('#submitBtn').addClass('d-none');
        }
    });


    $(document).ready(function() {

        // Load subcategories dynamically
        $('#categorySelect').on('change', function() {
            let catId = $(this).val();
            $('#subcategorySelect').html('<option value="">Loading...</option>');
            $.get("{{ url('get-subcategories') }}/" + catId, function(data) {
                let html = '<option value="">Select Subcategory</option>';
                $.each(data, function(i, subcat) {
                    html += `<option value="${subcat.id}">${subcat.name}</option>`;
                });
                $('#subcategorySelect').html(html);
            });
        });


        $('#stepOneForm').on('submit', function(e) {
            e.preventDefault();

            $.ajax({
                url: "{{ route('products.step.one') }}",
                type: "POST",
                data: $(this).serialize(),
                success: function(res) {
                    Swal.fire({
                        icon: 'success',
                        title: res.message,
                        timer: 1500,
                        showConfirmButton: false
                    });

                    // store product_id for step 2
                    $('#product_id').val(res.product_id);
                    
            completedSteps[1] = true;
            $('#productWizard .nav-link').eq(1).removeClass('disabled');

            activateTab(1); // move to Step 2
                },
                error: function(xhr) {
                    let err = xhr.responseJSON?.message || 'Validation error';
                    Swal.fire('Error', err, 'error');
                }
            });
        });

        // Add Product
        $('#addProductForm').submit(function(e) {
            e.preventDefault();
            var formData = new FormData(this);
            $.ajax({
                url: "{{ route('product.store') }}",
                type: "POST",
                data: formData,
                contentType: false,
                processData: false,
                success: function(response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Added!',
                        text: response.success,
                        timer: 1500,
                        showConfirmButton: false
                    });
                    $('#addProductForm')[0].reset();

                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    let errMsg = '';
                    $.each(errors, function(k, v) {
                        errMsg += `• ${v}<br>`;
                        //errMsg += v + '\n';
                    });
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        html: errMsg
                    });
                }
            });
        });





        $('#product_type').on('change', function() {
            let type = $(this).val();
            $('.customFields, .voucherFields').addClass('d-none');
            if (type == 'customized_gift') $('.customFields').removeClass('d-none');
            if (type == 'gift_voucher') $('.voucherFields').removeClass('d-none');
        });
    });

 
      function activateTab(index) {

    // Prevent skipping steps
    if (!completedSteps[index]) {
        Swal.fire('Warning', 'Complete previous step first', 'warning');
        return;
    }

    $('#productWizard .nav-link').removeClass('active');
    $('#productWizard .nav-link').eq(index).addClass('active');

    $('.tab-pane').removeClass('show active');
    $('.tab-pane').eq(index).addClass('show active');
}

$(document).on('click', '#productWizard .nav-link', function (e) {
    if ($(this).hasClass('disabled')) {
        e.preventDefault();
        Swal.fire('Info', 'Complete previous step first', 'info');
    }
});


        // NEXT button
        $(document).on('click', '.next-step', function() {
            let currentIndex = $('#productWizard .nav-link.active').parent().index();
            let nextIndex = currentIndex + 1;

            if ($('#productWizard .nav-link').eq(nextIndex).length) {
                activateTab(nextIndex);
            }
        });

        // BACK button
        $(document).on('click', '.prev-step', function() {
            let currentIndex = $('#productWizard .nav-link.active').parent().index();
            let prevIndex = currentIndex - 1;

            if (prevIndex >= 0) {
                activateTab(prevIndex);
            }
        });

    

    $('#stepTwoForm').on('submit', function(e) {
        e.preventDefault();

        $.ajax({
            url: "{{ route('product.step2.store') }}",
            method: "POST",
            data: $(this).serialize(),
            success: function(res) {
                Swal.fire({
                    icon: 'success',
                    title: 'Saved!',
                    text: res.message,
                    timer: 1500,
                    showConfirmButton: false
                });

                // move to step 3
                // $('.step').addClass('d-none');
                // $('.step-3').removeClass('d-none');
                $('#product_variant_id').val(res.product_variant_id);
                $('#variant_id').val(res.product_variant_id);
              
            completedSteps[2] = true;
            $('#productWizard .nav-link').eq(2).removeClass('disabled');

            activateTab(2); // move to Step 3
            },
            error: function(xhr) {
                let errors = xhr.responseJSON.errors;
                let html = '';
                $.each(errors, function(k, v) {
                    html += v[0] + '<br>';
                });

                Swal.fire({
                    icon: 'error',
                    title: 'Validation Error',
                    html: html
                });
            }
        });
    });

    let selectedImages = [];

    $('#imageInput').on('change', function(e) {
        let files = e.target.files;

        for (let i = 0; i < files.length; i++) {
            selectedImages.push(files[i]);

            let reader = new FileReader();
            reader.onload = function(e) {
                let index = selectedImages.length - 1;

                $('#imagePreview').append(`
                <div class="col-md-2 mb-3 image-box" data-index="${index}">
                    <div class="position-relative">
                        <img src="${e.target.result}" class="img-fluid rounded border">
                        <button type="button"
                            class="btn btn-sm btn-danger position-absolute top-0 end-0 remove-image">
                            ×
                        </button>
                    </div>
                </div>
            `);
            };
            reader.readAsDataURL(files[i]);
        }

        $(this).val('');
    });

    $(document).on('click', '.remove-image', function() {
        let box = $(this).closest('.image-box');
        let index = box.data('index');

        selectedImages.splice(index, 1);
        box.remove();
    });

    // Submit images
    $('#stepThreeForm').submit(function(e) {
        e.preventDefault();

        let formData = new FormData();
        formData.append('_token', '{{ csrf_token() }}');
        formData.append('product_variant_id', $('#product_variant_id').val());

        selectedImages.forEach((file) => {
            formData.append('images[]', file);
        });

        $.ajax({
            url: "{{ route('product.images.store') }}",
            method: "POST",
            data: formData,
            contentType: false,
            processData: false,
            success: function(res) {
                 completedSteps[3] = true;
            $('#productWizard .nav-link').eq(3).removeClass('disabled');

            activateTab(3); // move to Step 4
                Swal.fire('Success', res.message, 'success');
            },
            error: function() {
                Swal.fire('Error', 'Image upload failed', 'error');
            }
        });
    });

    let stockIndex = 1;

    $('#addStockRow').on('click', function() {
        let row = `
    <div class="row g-3 stock-row mt-2">
        <div class="col-md-4">
            <select name="stocks[${stockIndex}][location_id]" class="form-control" required>
                @foreach($locations as $loc)
                    <option value="{{ $loc->id }}">{{ $loc->name }}</option>
                @endforeach
            </select>
        </div>

        <div class="col-md-3">
            <input type="number" step="0.01" name="stocks[${stockIndex}][available_qty]" class="form-control" required>
        </div>

        <div class="col-md-3">
            <input type="number" step="0.01" name="stocks[${stockIndex}][reorder_level]" class="form-control">
        </div>

        <div class="col-md-2">
            <button type="button" class="btn btn-danger removeRow">✕</button>
        </div>
    </div>`;

        $('#stockRows').append(row);
        $('.removeRow').removeClass('d-none');
        stockIndex++;
    });

    $(document).on('click', '.removeRow', function() {
        $(this).closest('.stock-row').remove();
    });

    $('#stepFourForm').submit(function(e) {
        e.preventDefault();

        $.ajax({
            url: "{{ route('stocks.store') }}",
            type: "POST",
            data: $(this).serialize(),
            success: function(res) {
                Swal.fire({
                    icon: 'success',
                    title: 'Completed',
                    text: res.message,
                    timer: 1500,
                    showConfirmButton: false
                });

                // Redirect / reset / show summary
            },
            error: function(xhr) {
                Swal.fire('Error', 'Failed to save stock', 'error');
            }
        });
    });
</script>


@endsection