<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Stock extends Model
{
    protected $fillable = [
        'product_variant_id',
        'location_id',
        'available_qty',
        'reserved_qty',
        'reorder_level',
        'is_available',
    ];
    //protected $fillable = ['product_variant_id', 'location_id', 'available_qty', 'reorder_level'];
    public function location()
    {
        return $this->belongsTo(Location::class);
    }
public function productVariant()
    {
        return $this->belongsTo(ProductVariant::class, 'product_variant_id');
    }
}
