<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductVariant extends Model
{
    protected $fillable = [
        'product_id',
        'sku',
        'batch_no',
        'mrp',
        'offer_price',
        'unit',
        'dimensions',
        'color_name',
        'color_code',
        'material_or_fabric_composition',
        'gsm',
        'weight',
        'rub_count',
        'moq',
        'pattern',
    ];


    public function images()
    {
        return $this->hasMany(ProductImages::class);
    }

    public function stocks()
    {
        return $this->hasMany(Stock::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
