<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    protected $table = 'products';
    protected $fillable = [
        'category_id',
        'subcategory_id',
        'name',
        'description',
        // 'material',
        // 'pattern',
        'features',
        'maintenance',
        'warranty_certification',
        'measurement',
        'is_active'
    ];

    public function rooms()
    {
        // specify table name
        return $this->belongsToMany(Room::class, 'product_rooms', 'product_id', 'room_id');
    }

    public function tags()
    {
        return $this->belongsToMany(Tags::class, 'product_tags', 'product_id', 'tag_id');
    }



    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    // Product.php

    public function subCategory()
    {
        return $this->belongsTo(SubCategory::class, 'subcategory_id'); // match DB column
    }


    public function variants()
    {
        return $this->hasMany(ProductVariant::class);
    }
}
