<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Coupon extends Model
{
    protected $fillable = [
        'code', 'type', 'value', 'country_id', 'category_id', 'product_id',
        'min_purchase', 'max_uses', 'used_count', 'per_user_limit',
        'start_date', 'end_date', 'is_active', 'description'
    ];

   

    public function category() {
        return $this->belongsTo(Category::class);
    }

    public function product() {
        return $this->belongsTo(Product::class);
    }
//     public function orders()
// {
//     return $this->hasMany(Order::class);
// }

}
