<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Banner extends Model
{
    protected $fillable = [
        'title',
        'image',
        'category_id',
        'product_id',
        'status',
        'seasonal_banner',
        'start_date',
        'end_date'
    ];

    protected $appends = ['image_url'];

    public function getImageUrlAttribute()
    {
        if (!$this->image) {
            return null;
        }

        // If full URL already exists
        if (str_starts_with($this->image, 'http')) {
            return $this->image;
        }

        return url($this->image);
    }
    // ✅ Relationship to Category
    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function category()
    {
        return $this->belongsTo(Category::class);
    }
}
