@extends('admin.layout.template')
@section('title', 'Rooms')
@section('content')

<div class="page-content">

    <!-- Start Container Fluid -->
    <div class="container-xxl">

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title d-flex align-items-center gap-1"><iconify-icon icon="solar:settings-bold-duotone" class="text-primary fs-20"></iconify-icon>Add room</h4>
                    </div>
                    <div class="card-body">
                        <form action="{{route('add-room')}}" method="post">
                            @csrf
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="meta-name" class="form-label">room</label>
                                        <input type="text"  name="name" class="form-control" placeholder="Enter room name" required>
                                  </div>
                                </div>
                                   <div class="col-lg-6 mt-3">
                                    <div class="text-start">
                                <button type="submit" class="btn btn-success">Save Change</button>
                            </div>
                                </div>

                            </div>
                           
                        </form>
                    </div>
                </div>


                 <div class="row">
                              <div class="col-xl-12">
                                   <div class="card">
                                      
                                        <div class="card-body p-0">
                                             <div class="table-responsive">
                                                  <table class="table align-middle mb-0 table-hover table-centered">
                                                       <thead class="bg-light-subtle">
                                                            <tr>
                                                                <th>SL.NO</th>
                                                                 <th>room Name</th>
                                                                <th>Action</th>
                                                            </tr>
                                                       </thead>
                                                     <tbody></tbody>
                                                  </table>
                                             </div>
                                             <!-- end table-responsive -->
                                        </div>
                                      
                                   </div>
                              </div>

                         </div>


            </div>
        </div>
    </div>
</div>


<script>
    $(function() {

        $('.table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('get-room') }}",
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                },
                {
                    data: 'name',
                    name: 'name'
                },
              

                {
                    data: 'action',
                    name: 'action'
                },

            ],
            "select": {
                'style': 'multi',
                'selector': 'td:first-child' //only checkbox can select row 
            },
        });

         // SweetAlert Delete Confirmation
        $(document).on('click', '.deleteroom', function(e) {
            e.preventDefault(); // 🔥 stop page reload or navigation
            var id = $(this).data('id');

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel',
                customClass: {
                    popup: 'rounded-3 shadow-lg'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "{{ url('delete-room') }}/" + id,
                        type: 'DELETE',
                        data: {
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(response) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Deleted!',
                                text: response.success,
                                showConfirmButton: false,
                                timer: 1500
                            });
                            $('.table').DataTable().ajax.reload();
                        },
                        error: function() {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error!',
                                text: 'Something went wrong while deleting.',
                            });
                        }
                    });
                }
            });
        });

        
    // EDIT (inline)
   $(document).on('click', '.editroom', function (e) {
    e.preventDefault();

    var row = $(this).closest('tr');
    var id = $(this).data('id');
    var name = row.find('td:eq(1)').text().trim();

    row.find('td:eq(1)').html(
        '<input type="text" class="form-control form-control-sm edit-name" value="' + name + '">'
    );

    $(this).replaceWith(`
        <button class="btn btn-sm btn-success saveroom" data-id="${id}">Save</button>
        <button class="btn btn-sm btn-secondary cancelEdit ms-1">Cancel</button>
    `);
});


    // CANCEL edit
  $(document).on('click', '.cancelEdit', function (e) {
    e.preventDefault();
    $('.table').DataTable().ajax.reload();
});


    // SAVE (update via AJAX)
   $(document).on('click', '.saveroom', function (e) {
    e.preventDefault();

    var id = $(this).data('id');
    var row = $(this).closest('tr');
    var name = row.find('.edit-name').val();

    $.ajax({
        url: "{{ url('update-room') }}/" + id,
        type: 'POST',
        data: {
            _token: '{{ csrf_token() }}',
            _method: 'PUT',
            name: name
        },
        success: function (response) {
            Swal.fire({
                icon: 'success',
                title: 'Updated!',
                text: response.success,
                timer: 1500,
                showConfirmButton: false
            });
            $('.table').DataTable().ajax.reload();
        },
        error: function () {
            Swal.fire({
                icon: 'error',
                title: 'Error!',
                text: 'Failed to update room.'
            });
        }
    });
});


    });


</script>


@endsection