@extends('admin.layout.template')
@section('title','Edit Product')
@php
$locations=App\Models\Location::all();
@endphp
@section('content')
<style>
    .step-tab.disabled {
        pointer-events: none;
        opacity: 0.5;
    }

    .image-box img {
        height: 130px;
        width: 100%;
        object-fit: cover;
    }

    .image-box button {
        border-radius: 50%;
        line-height: 1;
    }
</style>
<div class="page-content">
    <div class="container-xxl">


        <!-- STEP NAV -->
        <ul class="nav nav-tabs" id="productWizard">
            <li class="nav-item">
                <a class="nav-link active" data-index="0" href="javascript:void(0)">Step 1: Product</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" data-index="1" href="javascript:void(0)">Step 2: Variant</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" data-index="2" href="javascript:void(0)">Step 3: Images</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" data-index="3" href="javascript:void(0)">Step 4: Stock</a>
            </li>
        </ul>



        <div class="tab-content mt-3">

            <div class="tab-pane fade show active" id="step1">
                <!-- STEP 1 -->
                <div class="step step-1" id="step1">
                    <div class="card p-3">
                        <h5>Product Details</h5>
                        <form id="stepOneForm" class="needs-validation" novalidate>
                            @csrf
                            <div class="row g-3">
                                <div class="col-lg-6">
                                    <label class="form-label">Category</label>
                                    <input type="hidden" name="id" value="{{$product->id}}">
                                    <select name="category_id" id="categorySelect" class="form-control" required>
                                        @foreach(App\Models\Category::all() as $cat)
                                        <option value="{{ $cat->id }}" {{ $product->category_id == $cat->id ? 'selected' : '' }}>
                                            {{ $cat->name }}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-lg-6">
                                    <label class="form-label">Subcategory</label>
                                    <select name="sub_category_id" id="subcategorySelect" class="form-control">
                                        @foreach(App\Models\SubCategory::where('category_id', $product->category_id)->get() as $subcat)
                                        <option value="{{ $subcat->id }}" {{ $product->sub_category_id == $subcat->id ? 'selected' : '' }}>
                                            {{ $subcat->name }}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>

                                {{-- Product Name --}}
                                <div class="col-md-6">
                                    <label class="form-label">Product Name *</label>
                                    <input type="text" name="name" value="{{ $product->name }}" class="form-control" required>
                                </div>

                                {{-- Material --}}
                                <!-- <div class="col-md-6">
                            <label class="form-label">Material</label>
                            <input type="text" name="material" class="form-control">
                        </div> -->

                                {{-- Pattern --}}
                                <!-- <div class="col-md-6">
                            <label class="form-label">Pattern</label>
                            <input type="text" name="pattern" class="form-control">
                        </div> -->


                                {{-- Features --}}
                                <div class="col-md-6">
                                    <label class="form-label">Additional Features</label>
                                    <input type="text" name="features" value="{{$product->features}}" class="form-control"
                                        placeholder="Blackout, Washable">
                                </div>

                                {{-- Warranty --}}
                                <div class="col-md-6">
                                    <label class="form-label">Warranty / Certification</label>
                                    <input type="text" name="warranty_certification" value="{{$product->warranty_certification}}" class="form-control"
                                        placeholder="ISO / 1 Year">
                                </div>

                                {{-- Maintenance --}}
                                <div class="col-md-6">
                                    <label class="form-label">Maintenance</label>
                                    <input type="text" name="maintenance" value="{{$product->maintenance}}" class="form-control"
                                        placeholder="Dry clean / Spot clean">
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">
                                        Master Catalogue Name <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" value="{{$product->master_catalogue_name}}"
                                        name="master_catalogue_name"
                                        class="form-control"
                                        required>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">
                                        Master Catalogue Code <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" value="{{$product->master_catalogue_code}}"
                                        name="master_catalogue_code"
                                        class="form-control"
                                        required>
                                </div>
                                {{-- Rooms (Multiple) --}}
                                <div class="col-md-6">
                                    <label class="form-label">Rooms *</label>

                                    <select name="rooms[]" class="form-control" multiple data-choices>
                                        @foreach(App\Models\Room::all() as $room)
                                        <option value="{{ $room->id }}"
                                            {{ $product->rooms->contains($room->id) ? 'selected' : '' }}>
                                            {{ $room->name }}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>


                                {{-- Tags (Multiple) --}}
                                <div class="col-md-6">
                                    <label class="form-label">Tags</label>

                                    <select name="tags[]" class="form-control" multiple data-choices>
                                        @foreach(App\Models\Tags::all() as $tag)
                                        <option value="{{ $tag->id }}"
                                            {{ $product->tags->contains($tag->id) ? 'selected' : '' }}>
                                            {{ $tag->name }}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>


                                {{-- Measurement --}}
                                @php
                                // Split measurement string safely
                                $measurements = $product->measurement
                                ? array_map('trim', explode('x', $product->measurement))
                                : [];

                                $length = $measurements[0] ?? '';
                                $width = $measurements[1] ?? '';
                                $height = $measurements[2] ?? '';
                                @endphp

                                <div class="col-md-12">
                                    <label class="form-label">Measurement</label>

                                    <div class="row">
                                        <div class="col-md-4">
                                            <input type="number"
                                                step="0.01"
                                                name="length"
                                                class="form-control"
                                                placeholder="Length"
                                                value="{{ $length }}">
                                        </div>

                                        <div class="col-md-4">
                                            <input type="number"
                                                step="0.01"
                                                name="width"
                                                class="form-control"
                                                placeholder="Width"
                                                value="{{ $width }}">
                                        </div>

                                        <div class="col-md-4">
                                            <input type="number"
                                                step="0.01"
                                                name="height"
                                                class="form-control"
                                                placeholder="Height"
                                                value="{{ $height }}">
                                        </div>
                                    </div>

                                    <small class="text-muted">Example: 120 x 60 x 45 cm</small>
                                </div>
                                <div class="row g-3">

                                    <!-- Visibility -->
                                    <div class="col-md-6">
                                        <label class="form-label">Visibility *</label>
                                        <select name="visibility" class="form-control" required>
                                            <option value="All" {{ $product->visibility == 'All' ? 'selected' : '' }}>All</option>
                                            <option value="B2C" {{ $product->visibility == 'B2C' ? 'selected' : '' }}>B2C</option>
                                            <option value="B2B" {{ $product->visibility == 'B2B' ? 'selected' : '' }}>B2B</option>
                                            <option value="Franchise" {{ $product->visibility == 'Franchise' ? 'selected' : '' }}>Franchise</option>
                                        </select>
                                    </div>

                                    <!-- GST Percent -->
                                    <div class="col-md-6">
                                        <label class="form-label">GST (%)</label>
                                        <input type="number" step="0.01" name="gst_percent" class="form-control" value="{{ $product->gst_percent }}">
                                    </div>

                                    <!-- GST Inclusive -->
                                    <div class="col-md-6 mt-2">
                                        <label class="form-label">Price Includes GST?</label>
                                        <select name="gst_inclusive" class="form-control">
                                            <option value="1" {{ $product->gst_inclusive ? 'selected' : '' }}>Yes</option>
                                            <option value="0" {{ !$product->gst_inclusive ? 'selected' : '' }}>No</option>
                                        </select>
                                    </div>

                                    <!-- Featured Product -->
                                    <div class="col-md-6 mt-2">
                                        <label class="form-label">Featured Product</label>
                                        <select name="is_featured" class="form-control">
                                            <option value="0" {{ !$product->is_featured ? 'selected' : '' }}>No</option>
                                            <option value="1" {{ $product->is_featured ? 'selected' : '' }}>Yes</option>
                                        </select>
                                    </div>

                                    <!-- Related Products -->
                                    <div class="col-md-12 mt-2">
                                        <label class="form-label">Related Products</label>
                                        <select name="related_products[]" class="form-control" multiple data-choices>
                                            @foreach(App\Models\Product::all() as $p)
                                            <option value="{{ $p->id }}" {{ in_array($p->id, $product->related_products ?? []) ? 'selected' : '' }}>
                                                {{ $p->name }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <!-- Cross-Sell Products -->
                                    <div class="col-md-12 mt-2">
                                        <label class="form-label">Cross-Sell Products</label>
                                        <select name="cross_sell_products[]" class="form-control" multiple data-choices>
                                            @foreach(App\Models\Product::all() as $p)
                                            <option value="{{ $p->id }}" {{ in_array($p->id, $product->cross_sell_products ?? []) ? 'selected' : '' }}>
                                                {{ $p->name }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <!-- Upsell Products -->
                                    <div class="col-md-12 mt-2">
                                        <label class="form-label">Upsell Products</label>
                                        <select name="upsell_products[]" class="form-control" multiple data-choices>
                                            @foreach(App\Models\Product::all() as $p)
                                            <option value="{{ $p->id }}" {{ in_array($p->id, $product->upsell_products ?? []) ? 'selected' : '' }}>
                                                {{ $p->name }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <!-- SEO Title -->
                                    <div class="col-md-12 mt-2">
                                        <label class="form-label">SEO Title</label>
                                        <input type="text" name="seo_title" class="form-control" value="{{ $product->seo_title }}">
                                    </div>

                                    <!-- SEO Description -->
                                    <div class="col-md-12 mt-2">
                                        <label class="form-label">SEO Description</label>
                                        <textarea name="seo_description" class="form-control" rows="2">{{ $product->seo_description }}</textarea>
                                    </div>

                                    <!-- Search Keywords -->
                                    <div class="col-md-12 mt-2">
                                        <label class="form-label">Search Keywords</label>
                                        <input type="text" name="search_keywords" class="form-control" value="{{ $product->search_keywords }}">
                                    </div>

                                    <!-- Care Instructions -->
                                    <div class="col-md-12 mt-2">
                                        <label class="form-label">Care Instructions</label>
                                        <textarea name="care_instructions" class="form-control" rows="2">{{ $product->care_instructions }}</textarea>
                                    </div>

                                    <!-- Fast / Slow Moving -->
                                    <div class="col-md-6 mt-2">
                                        <label class="form-label">Fast Moving</label>
                                        <select name="fast_moving" class="form-control">
                                            <option value="0" {{ !$product->fast_moving ? 'selected' : '' }}>No</option>
                                            <option value="1" {{ $product->fast_moving ? 'selected' : '' }}>Yes</option>
                                        </select>
                                    </div>

                                    <div class="col-md-6 mt-2">
                                        <label class="form-label">Slow Moving</label>
                                        <select name="slow_moving" class="form-control">
                                            <option value="0" {{ !$product->slow_moving ? 'selected' : '' }}>No</option>
                                            <option value="1" {{ $product->slow_moving ? 'selected' : '' }}>Yes</option>
                                        </select>
                                    </div>

                                </div>


                                {{-- Description --}}
                                <div class="col-md-12">
                                    <label class="form-label">Description</label>
                                    <textarea name="description" class="form-control" rows="4">{{$product->description}}</textarea>
                                </div>

                            </div>
                            <div class="text-end mt-4">
                                <button type="submit" class="btn btn-primary">
                                    Update & Continue →
                                </button>
                            </div>

                        </form>
                    </div>
                </div>

                <button class="btn btn-primary next-step">Next</button>
            </div>

            @php
            $variant = $product->variants->first();
            @endphp

            <div class="tab-pane fade" id="step2">

                <div class="step step-2">
                    <form id="stepTwoForm" class="needs-validation" novalidate>
                        @csrf

                        {{-- Product & Variant --}}
                        <input type="hidden" name="product_id" value="{{ $product->id }}">
                        <input type="hidden" name="variant_id" value="{{ $variant?->id }}">

                        <div class="card p-3">
                            <h5>Variant / SKU Details</h5>

                            <div class="row g-3">

                                <div class="col-md-4">
                                    <label>SKU *</label>
                                    <input type="text" name="sku"
                                        value="{{ $variant?->sku }}"
                                        class="form-control" required>
                                </div>

                                <div class="col-md-4">
                                    <label>Batch No</label>
                                    <input type="text" name="batch_no"
                                        value="{{ $variant?->batch_no }}"
                                        class="form-control">
                                </div>

                                <div class="col-md-4">
                                    <label>Unit *</label>
                                    <select name="unit" class="form-control" required>
                                        <option value="">Select</option>
                                        @foreach(['cm','inch','mtr','sqft','nos'] as $unit)
                                        <option value="{{ $unit }}"
                                            {{ $variant?->unit === $unit ? 'selected' : '' }}>
                                            {{ $unit }}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-4">
                                    <label>Dimensions</label>
                                    <input type="text" name="dimensions"
                                        value="{{ $variant?->dimensions }}"
                                        class="form-control">
                                </div>

                                <div class="col-md-4">
                                    <label>Material / Fabric</label>
                                    <input type="text" name="material_or_fabric_composition"
                                        value="{{ $variant?->material_or_fabric_composition }}"
                                        class="form-control">
                                </div>

                                <div class="col-md-4">
                                    <label>Pattern</label>
                                    <input type="text" name="pattern"
                                        value="{{ $variant?->pattern }}"
                                        class="form-control">
                                </div>

                                <div class="col-md-3">
                                    <label>Color Name</label>
                                    <input type="text" name="color_name"
                                        value="{{ $variant?->color_name }}"
                                        class="form-control">
                                </div>

                                <div class="col-md-3">
                                    <label>Color Code</label>
                                    <input type="color" name="color_code"
                                        value="{{ $variant?->color_code ?? '#000000' }}"
                                        class="form-control">
                                </div>

                                <div class="col-md-3">
                                    <label>GSM</label>
                                    <input type="number" step="0.01" name="gsm"
                                        value="{{ $variant?->gsm }}"
                                        class="form-control">
                                </div>

                                <div class="col-md-3">
                                    <label>Weight (kg)</label>
                                    <input type="number" step="0.01" name="weight"
                                        value="{{ $variant?->weight }}"
                                        class="form-control">
                                </div>

                                <div class="col-md-3">
                                    <label>Rub Count</label>
                                    <input type="number" name="rub_count"
                                        value="{{ $variant?->rub_count }}"
                                        class="form-control">
                                </div>

                                <div class="col-md-3">
                                    <label>MOQ</label>
                                    <input type="number" name="moq"
                                        value="{{ $variant?->moq }}"
                                        class="form-control">
                                </div>

                                <div class="col-md-3">
                                    <label>MRP *</label>
                                    <input type="number" name="mrp"
                                        value="{{ $variant?->mrp }}"
                                        class="form-control" required>
                                </div>

                                <div class="col-md-3">
                                    <label>Offer Price *</label>
                                    <input type="number" name="offer_price"
                                        value="{{ $variant?->offer_price }}"
                                        class="form-control" required>
                                </div>

                            </div>
                        </div>

                        <div class="text-end mt-4">
                            <button type="submit" class="btn btn-primary">
                                Update Variant & Continue →
                            </button>
                        </div>
                    </form>
                </div>

                <button class="btn btn-secondary prev-step">Back</button>
                <button class="btn btn-primary next-step">Next</button>
            </div>


            <div class="tab-pane fade" id="step3">
                <!-- Step 3 content -->
                <!-- STEP 3 -->
                @php
                $variant = $product->variants->first();
                @endphp

                <div class="step step-3">
                    <form id="stepThreeForm" enctype="multipart/form-data" class="needs-validation" novalidate>
                        @csrf

                        <input type="hidden" name="product_variant_id"
                            value="{{ $variant?->id }}" id="product_variant_id">

                        <div class="card p-3">
                            <h5>Product Images</h5>

                            <input type="file" id="imageInput" class="form-control" multiple accept="image/*">

                            <div class="row mt-3" id="imagePreview">

                                {{-- EXISTING IMAGES --}}
                                @if($variant && $variant->images->count())
                                @foreach($variant->images as $img)
                                <div class="col-md-2 mb-3 image-box">
                                    <div class="position-relative">
                                        <img src="{{ asset($img->image_path) }}"
                                            class="img-fluid rounded border">

                                        <button type="button"
                                            class="btn btn-sm btn-danger position-absolute top-0 end-0 delete-existing-image"
                                            data-id="{{ $img->id }}">
                                            ×
                                        </button>
                                    </div>
                                </div>
                                @endforeach
                                @else
                                <p class="text-muted">No images uploaded</p>
                                @endif

                            </div>
                        </div>

                        <div class="text-end mt-4">
                            <button type="submit" class="btn btn-primary">
                                Update Images →
                            </button>
                        </div>
                    </form>
                </div>


                <button class="btn btn-secondary prev-step">Back</button>
                <button class="btn btn-primary next-step">Next</button>
            </div>

            <div class="tab-pane fade" id="step4">
                @php
                $variant = $product->variants->first();
                $existingStocks = $variant ? $variant->stocks : collect();
                @endphp

                <div class="step step-4">
                    <form id="stepFourForm" class="needs-validation" novalidate>
                        @csrf

                        <input type="hidden"
                            name="product_variant_id"
                            id="variant_id"
                            value="{{ $variant?->id }}">

                        <div class="card p-3">
                            <h5>Stock Management</h5>

                            <div id="stockRows">
                                @forelse($existingStocks as $index => $stock)
                                <div class="row g-3 stock-row mt-2">

                                    {{-- stock id (for update) --}}
                                    <input type="hidden"
                                        name="stocks[{{ $index }}][id]"
                                        value="{{ $stock->id }}">

                                    {{-- Location --}}
                                    <div class="col-md-2">
                                        <label>Location *</label>
                                        <select name="stocks[{{ $index }}][location_id]"
                                            class="form-control"
                                            required>
                                            <option value="">Select Location</option>
                                            @foreach($locations as $loc)
                                            <option value="{{ $loc->id }}"
                                                {{ $loc->id == $stock->location_id ? 'selected' : '' }}>
                                                {{ $loc->name }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>

                                    {{-- Available Qty --}}
                                    <div class="col-md-2">
                                        <label>Available Qty *</label>
                                        <input type="number" step="0.01"
                                            name="stocks[{{ $index }}][available_qty]"
                                            class="form-control"
                                            value="{{ $stock->available_qty }}"
                                            required>
                                    </div>

                                    {{-- Opening Qty --}}
                                    <div class="col-md-2">
                                        <label>Opening Qty</label>
                                        <input type="number" step="0.01"
                                            name="stocks[{{ $index }}][opening_qty]"
                                            class="form-control"
                                            value="{{ $stock->opening_qty }}">
                                    </div>

                                    {{-- Received Qty --}}
                                    <div class="col-md-2">
                                        <label>Received Qty</label>
                                        <input type="number" step="0.01"
                                            name="stocks[{{ $index }}][received_qty]"
                                            class="form-control"
                                            value="{{ $stock->received_qty }}">
                                    </div>

                                    {{-- Damaged Qty --}}
                                    <div class="col-md-2">
                                        <label>Damaged</label>
                                        <input type="number" step="0.01"
                                            name="stocks[{{ $index }}][damaged_qty]"
                                            class="form-control"
                                            value="{{ $stock->damaged_qty }}">
                                    </div>

                                    {{-- Returned Qty --}}
                                    <div class="col-md-2">
                                        <label>Returned</label>
                                        <input type="number" step="0.01"
                                            name="stocks[{{ $index }}][returned_qty]"
                                            class="form-control"
                                            value="{{ $stock->returned_qty }}">
                                    </div>

                                    {{-- Remove --}}
                                    <div class="col-md-1 d-flex align-items-end">
                                        <button type="button"
                                            class="btn btn-danger removeRow">
                                            ✕
                                        </button>
                                    </div>

                                </div>
                                @empty
                                {{-- If no stock exists yet --}}
                                <div class="text-muted">
                                    No stock records found. Please add stock.
                                </div>
                                @endforelse
                            </div>

                            <button type="button"
                                id="addStockRow"
                                class="btn btn-outline-secondary mt-3">
                                + Add Location Stock
                            </button>
                        </div>

                        <div class="text-end mt-4">
                            <button type="submit" class="btn btn-success">
                                Update Stock & Finish →
                            </button>
                        </div>
                    </form>
                </div>

                <button class="btn btn-secondary prev-step">Back</button>
            </div>

        </div>

        <!-- NAV BUTTONS -->

    </div>
</div>
<script>
    let step = 1;

    $('.next').click(function() {
        $('.step-' + step).addClass('d-none');
        step++;
        $('.step-' + step).removeClass('d-none');
        if (step == 4) {
            $('.next').hide();
            $('#submitBtn').removeClass('d-none');
        }
    });

    $('.prev').click(function() {
        if (step > 1) {
            $('.step-' + step).addClass('d-none');
            step--;
            $('.step-' + step).removeClass('d-none');
            $('.next').show();
            $('#submitBtn').addClass('d-none');
        }
    });


    $(document).ready(function() {

        // Load subcategories dynamically
        $('#categorySelect').on('change', function() {
            let catId = $(this).val();
            $('#subcategorySelect').html('<option value="">Loading...</option>');
            $.get("{{ url('get-subcategories') }}/" + catId, function(data) {
                let html = '<option value="">Select Subcategory</option>';
                $.each(data, function(i, subcat) {
                    html += `<option value="${subcat.id}">${subcat.name}</option>`;
                });
                $('#subcategorySelect').html(html);
            });
        });


        $('#stepOneForm').on('submit', function(e) {
            e.preventDefault();

            $.ajax({
                url: "{{ route('products.step.one.update') }}", // EDIT route
                type: "POST",
                data: $(this).serialize(),
                success: function(res) {

                    Swal.fire({
                        icon: 'success',
                        title: 'Updated',
                        timer: 1200,
                        showConfirmButton: false
                    });

                    // Auto move to Step 2
                    activateTab(1);
                },
                error: function(xhr) {
                    Swal.fire('Error', 'Update failed', 'error');
                }
            });
        });


        // Add Product
        $('#addProductForm').submit(function(e) {
            e.preventDefault();
            var formData = new FormData(this);
            $.ajax({
                url: "{{ route('product.store') }}",
                type: "POST",
                data: formData,
                contentType: false,
                processData: false,
                success: function(response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Added!',
                        text: response.success,
                        timer: 1500,
                        showConfirmButton: false
                    });
                    $('#addProductForm')[0].reset();

                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    let errMsg = '';
                    $.each(errors, function(k, v) {
                        errMsg += `• ${v}<br>`;
                        //errMsg += v + '\n';
                    });
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        html: errMsg
                    });
                }
            });
        });





        $('#product_type').on('change', function() {
            let type = $(this).val();
            $('.customFields, .voucherFields').addClass('d-none');
            if (type == 'customized_gift') $('.customFields').removeClass('d-none');
            if (type == 'gift_voucher') $('.voucherFields').removeClass('d-none');
        });
    });

    function activateTab(index) {
        $('#productWizard .nav-link').removeClass('active');
        $('#productWizard .nav-link').eq(index).addClass('active');

        $('.tab-pane').removeClass('show active');
        $('.tab-pane').eq(index).addClass('show active');
    }
    $('#productWizard .nav-link').on('click', function() {
        let index = $(this).parent().index();
        activateTab(index);
    });


    // NEXT button
    $(document).on('click', '.next-step', function() {
        let currentIndex = $('#productWizard .nav-link.active').parent().index();
        let nextIndex = currentIndex + 1;

        if ($('#productWizard .nav-link').eq(nextIndex).length) {
            activateTab(nextIndex);
        }
    });

    // BACK button
    $(document).on('click', '.prev-step', function() {
        let currentIndex = $('#productWizard .nav-link.active').parent().index();
        let prevIndex = currentIndex - 1;

        if (prevIndex >= 0) {
            activateTab(prevIndex);
        }
    });



    $('#stepTwoForm').on('submit', function(e) {
        e.preventDefault();

        $.ajax({
            url: "{{ route('products.step.two.update') }}",
            type: "POST",
            data: $(this).serialize(),
            success: function(res) {

                Swal.fire({
                    icon: 'success',
                    title: 'Variant updated',
                    timer: 1200,
                    showConfirmButton: false
                });

                // Move to Step 3 (Images)
                activateTab(2);
            },
            error: function(xhr) {
                let msg = xhr.responseJSON?.message || 'Update failed';
                Swal.fire('Error', msg, 'error');
            }
        });
    });

    let selectedImages = [];

    $('#imageInput').on('change', function(e) {
        let files = Array.from(e.target.files);

        files.forEach((file) => {

            selectedImages.push(file);
            let index = selectedImages.length - 1;

            let reader = new FileReader();
            reader.onload = function(ev) {

                $('#imagePreview').append(`
                <div class="col-md-2 mb-3 image-box" data-index="${index}" data-type="new">
                    <div class="position-relative">
                        <img src="${ev.target.result}"
                             class="img-fluid rounded border">

                        <button type="button"
                            class="btn btn-danger btn-sm position-absolute top-0 end-0 remove-new-image">
                            ×
                        </button>
                    </div>
                </div>
            `);
            };
            reader.readAsDataURL(file);
        });

        // reset input so same file can be re-selected
        $(this).val('');
    });

    $(document).on('click', '.remove-new-image', function() {

        let box = $(this).closest('.image-box');
        let index = box.data('index');

        selectedImages.splice(index, 1);
        box.fadeOut(200, function() {
            $(this).remove();
        });
    });


    $(document).on('click', '.delete-existing-image', function() {

        let imageId = $(this).data('id');
        let box = $(this).closest('.image-box');

        Swal.fire({
            title: 'Delete Image?',
            text: 'This image will be permanently deleted.',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, delete',
            cancelButtonText: 'Cancel'
        }).then((result) => {

            if (result.isConfirmed) {

                $.ajax({
                    url: "{{ route('products.image.delete') }}",
                    type: "POST",
                    data: {
                        _token: "{{ csrf_token() }}",
                        image_id: imageId
                    },
                    success: function(res) {

                        box.fadeOut(300, function() {
                            $(this).remove();
                        });

                        Swal.fire({
                            icon: 'success',
                            title: 'Deleted!',
                            text: res.message ?? 'Image deleted successfully',
                            timer: 1200,
                            showConfirmButton: false
                        });
                    },
                    error: function() {
                        Swal.fire(
                            'Error',
                            'Unable to delete image. Please try again.',
                            'error'
                        );
                    }
                });
            }
        });
    });


    // Submit images
    $('#stepThreeForm').submit(function(e) {
        e.preventDefault();

        let formData = new FormData();
        formData.append('_token', '{{ csrf_token() }}');
        formData.append('product_variant_id', $('#product_variant_id').val());

        selectedImages.forEach((file) => {
            formData.append('images[]', file);
        });

        $.ajax({
            url: "{{ route('product.images.store') }}",
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,
            success: function(res) {
                Swal.fire('Success', res.message, 'success');
                selectedImages = [];
            }
        });
    });
    let stockIndex = 1;

    $('#addStockRow').on('click', function() {
        let row = `
    <div class="row g-3 stock-row mt-2">
        <div class="col-md-2">
         <label>Location *</label>
            <select name="stocks[${stockIndex}][location_id]" class="form-control" required>
                @foreach($locations as $loc)
                    <option value="{{ $loc->id }}">{{ $loc->name }}</option>
                @endforeach
            </select>
        </div>

        <div class="col-md-2">
         <label>Available Qty *</label>
            <input type="number" step="0.01" name="stocks[${stockIndex}][available_qty]" class="form-control" required>
        </div>

        <div class="col-md-2">
           <label>Opening Qty</label>
            <input type="number" step="0.01" name="stocks[${stockIndex}][opening_qty]" class="form-control">
        </div>

        <div class="col-md-2">
         <label>Received Qty</label>
            <input type="number" step="0.01" name="stocks[${stockIndex}][received_qty]" class="form-control">
        </div>

        <div class="col-md-2">
        <label>Damaged Qty</label>
            <input type="number" step="0.01" name="stocks[${stockIndex}][damaged_qty]" class="form-control">
        </div>

        <div class="col-md-2">
         <label>Returned Qty</label>
            <input type="number" step="0.01" name="stocks[${stockIndex}][returned_qty]" class="form-control">
        </div>

        <div class="col-md-1">
            <button type="button" class="btn btn-danger removeRow">✕</button>
        </div>
    </div><hr>`;
        $('#stockRows').append(row);
        $('.removeRow').removeClass('d-none');
        stockIndex++;
    });
    $(document).on('click', '.removeRow', function() {

        let row = $(this).closest('.stock-row');
        let stockId = row.find('input[name*="[id]"]').val();

        Swal.fire({
            title: 'Are you sure?',
            text: "This stock entry will be permanently removed.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, delete it',
            cancelButtonText: 'Cancel'
        }).then((result) => {

            if (!result.isConfirmed) return;

            // 🔹 Existing stock (delete from DB)
            if (stockId) {

                $.ajax({
                    url: '/stocks/' + stockId, // DELETE route
                    type: 'DELETE',
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    success: function() {
                        row.remove();

                        Swal.fire(
                            'Deleted!',
                            'Stock entry removed successfully.',
                            'success'
                        );
                    },
                    error: function() {
                        Swal.fire(
                            'Error!',
                            'Failed to delete stock. Please try again.',
                            'error'
                        );
                    }
                });

            }
            // 🔹 New row (not saved yet)
            else {
                row.remove();

                Swal.fire(
                    'Removed!',
                    'Stock row removed.',
                    'success'
                );
            }
        });
    });



    $('#stepFourForm').submit(function(e) {
        e.preventDefault();

        $.ajax({
            url: "{{ route('products.step.four.update') }}",
            type: "POST",
            data: $(this).serialize(),
            success: function(res) {
                Swal.fire('Success', res.message, 'success');
            },
            error: function(xhr) {
                Swal.fire('Error', 'Failed to save stock', 'error');
            }
        });
    });
</script>


@endsection