@extends('admin.layout.template')
@section('title', 'Coupons')
@section('content')

<div class="page-content">
    <div class="container-xxl">

        <!-- Add Coupon -->
        <div class="card mb-4">
            <div class="card-header">
                <h4>Add Coupon</h4>
            </div>
            <div class="card-body">
                <form id="addCouponForm">
                    @csrf
                    <div class="row">
                        <div class="col-lg-3 mb-3">
                            <label>Coupon Code</label>
                            <input type="text" name="code" class="form-control" placeholder="e.g. SAVE10">
                        </div>
                        <div class="col-lg-3 mb-3">
                            <label>Type</label>
                            <select name="type" class="form-control">
                                <option value="percentage">Percentage</option>
                                <option value="fixed">Fixed</option>
                            </select>
                        </div>
                        <div class="col-lg-3 mb-3">
                            <label>Value</label>
                            <input type="number" name="value" class="form-control" placeholder="10 or 100">
                        </div>

                        <div class="col-lg-3 mb-3">
                            <label>Category</label>
                            <select id="category_id" name="category_id" class="form-control">
                                <option value="">-- Select Category --</option>
                                @foreach(App\Models\Category::all() as $cat)
                                <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                                @endforeach
                            </select>
                            </select>
                        </div>
                        <div class="col-lg-3 mb-3">
                            <label>Product</label>
                            <select id="product_id" name="product_id" class="form-control">
                                <option value="">-- Select Product --</option>
                            </select>
                        </div>
                        <div class="col-lg-3 mb-3">
                            <label>Min Purchase</label>
                            <input type="number" name="min_purchase" class="form-control">
                        </div>
                        <div class="col-lg-3 mb-3">
                            <label>Max Uses</label>
                            <input type="number" name="max_uses" class="form-control">
                        </div>
                        <div class="col-lg-3 mb-3">
                            <label>Per User Limit</label>
                            <input type="number" name="per_user_limit" class="form-control">
                        </div>
                        <div class="col-lg-3 mb-3">
                            <label>Start Date</label>
                            <input type="date" name="start_date" class="form-control">
                        </div>
                        <div class="col-lg-3 mb-3">
                            <label>End Date</label>
                            <input type="date" name="end_date" class="form-control">
                        </div>
                        <div class="col-lg-3 mb-3">
                            <label>Description</label>
                            <input type="text" name="description" class="form-control">
                        </div>
                        <div class="col-lg-3 mb-3">
                            <label>Max Discount Cap (₹)</label>
                            <input type="number" name="max_discount_amount" class="form-control" placeholder="Eg: 1000">
                        </div>

                        <div class="col-lg-4 mb-3">
                            <label>Allowed User Roles</label>
                            <select name="allowed_roles[]" class="form-control" multiple data-choices>
                                <option value="B2C">B2C Customer</option>
                                <option value="B2B">B2B Dealer</option>
                                <option value="Franchise">Franchise</option>
                                <option value="Architect">Architect</option>
                            </select>
                            <small class="text-muted">Leave empty for all users</small>
                        </div>
                        <div class="col-lg-3 mb-3">
                            <label>Referral Coupon</label>
                            <select name="is_referral" class="form-control">
                                <option value="0">No</option>
                                <option value="1">Yes</option>
                            </select>
                        </div>
                        <div class="col-lg-2 mb-3 d-flex align-items-end">
                            <div class="form-check">
                                <input type="checkbox" name="first_time_user_only" value="1" class="form-check-input">
                                <label class="form-check-label">First-time users only</label>
                            </div>
                        </div>
                        <div class="col-lg-3 mb-3 d-flex align-items-end">
                            <div class="form-check me-3">
                                <input type="checkbox" name="is_stackable" value="1" class="form-check-input">
                                <label class="form-check-label">Stackable</label>
                            </div>

                            <div class="form-check">
                                <input type="checkbox" name="auto_apply" value="1" class="form-check-input">
                                <label class="form-check-label">Auto Apply</label>
                            </div>
                        </div>


                    </div>
                    <div class="text-end mt-3">
                        <button type="submit" class="btn btn-success">Save Coupon</button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Coupon Table -->
        <div class="card">
            <div class="card-body">
                <table class="table align-middle table-hover">
                    <thead class="bg-light">
                        <tr>
                            <th>#</th>
                            <th>Code</th>
                            <th>Type/Value</th>
                            <th>Category</th>
                            <th>Product</th>
                            <th>Date Range</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>

        <!-- Edit Modal -->
       <div class="modal fade" id="editCouponModal" tabindex="-1">
    <div class="modal-dialog modal-xl modal-dialog-scrollable">
        <div class="modal-content">

            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title">Edit Coupon</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">
                <form id="editCouponForm">@csrf
                    <input type="hidden" id="edit_coupon_id">

                <div class="row g-3">

    <div class="col-md-4">
        <label>Code</label>
        <input type="text" id="edit_code" name="code" class="form-control">
    </div>

    <div class="col-md-4">
        <label>Type</label>
        <select id="edit_type" name="type" class="form-select">
            <option value="percentage">Percentage</option>
            <option value="fixed">Fixed</option>
        </select>
    </div>

    <div class="col-md-4">
        <label>Value</label>
        <input type="number" id="edit_value" name="value" class="form-control">
    </div>

    <div class="col-md-4">
        <label>Category</label>
        <select id="edit_category_id" name="category_id" class="form-select">
             @foreach(App\Models\Category::all() as $cat)
                                <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                                @endforeach
        </select>
    </div>

    <div class="col-md-4">
        <label>Product</label>
        <select id="edit_product_id" name="product_id" class="form-select"></select>
    </div>

    <div class="col-md-4">
        <label>Max Discount Cap</label>
        <input type="number" id="edit_max_discount_amount"
               name="max_discount_amount"
               class="form-control">
    </div>

    <div class="col-md-4">
        <label>Start Date</label>
        <input type="date" id="edit_start_date" name="start_date" class="form-control">
    </div>

    <div class="col-md-4">
        <label>End Date</label>
        <input type="date" id="edit_end_date" name="end_date" class="form-control">
    </div>

    <div class="col-md-4">
        <label>Allowed Roles</label>
       <select id="edit_allowed_roles" name="allowed_roles[]" class="form-select" multiple data-choices>
    <option value="B2C">B2C</option>
    <option value="B2B">B2B</option>
    <option value="Franchise">Franchise</option>
    <option value="Architect">Architect</option>
</select>

    </div>

    <!-- ✔ Active -->
    <div class="col-md-3">
        <div class="form-check mt-4">
            <input type="hidden" name="is_active" value="0">
            <input class="form-check-input"
                   type="checkbox"
                   id="edit_is_active"
                   name="is_active"
                   value="1">
            <label class="form-check-label">Active</label>
        </div>
    </div>

    <!-- ✔ First Time -->
    <div class="col-md-3">
        <div class="form-check mt-4">
            <input type="hidden" name="first_time_user_only" value="0">
            <input class="form-check-input"
                   type="checkbox"
                   id="edit_first_time_user_only"
                   name="first_time_user_only"
                   value="1">
            <label class="form-check-label">First Time User Only</label>
        </div>
    </div>

    <!-- ✔ Stackable -->
    <div class="col-md-3">
        <div class="form-check mt-4">
            <input type="hidden" name="is_stackable" value="0">
            <input class="form-check-input"
                   type="checkbox"
                   id="edit_is_stackable"
                   name="is_stackable"
                   value="1">
            <label class="form-check-label">Stackable</label>
        </div>
    </div>

    <!-- ✔ Auto Apply -->
    <div class="col-md-3">
        <div class="form-check mt-4">
            <input type="hidden" name="auto_apply" value="0">
            <input class="form-check-input"
                   type="checkbox"
                   id="edit_auto_apply"
                   name="auto_apply"
                   value="1">
            <label class="form-check-label">Auto Apply</label>
        </div>
    </div>

</div>


                    <div class="text-end mt-4">
                        <button type="submit" class="btn btn-success px-5">
                            Update Coupon
                        </button>
                    </div>
                </form>
            </div>

        </div>
    </div>
</div>


    </div>
</div>


<script>
    $(function() {
        var table = $('.table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('get-coupons') }}",
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'code',
                    name: 'code'
                },
                {
                    data: 'type_value',
                    name: 'type_value'
                },

                {
                    data: 'category',
                    name: 'category'
                },
                {
                    data: 'product',
                    name: 'product'
                },
                {
                    data: 'date_range',
                    name: 'date_range'
                },
                {
                    data: 'status',
                    name: 'status',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                },
            ]
        });

        // Add coupon
        $('#addCouponForm').submit(function(e) {
            e.preventDefault();
            $.ajax({
                url: "{{ route('add-coupon') }}",
                method: "POST",
                data: new FormData(this),
                processData: false,
                contentType: false,
                success: function(res) {
                    Swal.fire('Success', res.success, 'success');
                    $('#addCouponForm')[0].reset();
                    table.ajax.reload();
                },
                error: function(xhr) {
                    Swal.fire('Error', xhr.responseJSON?.message || 'Validation error', 'error');
                }
            });
        });

        // Delete coupon
        $(document).on('click', '.deleteCoupon', function() {
            var id = $(this).data('id');
            Swal.fire({
                    title: 'Delete?',
                    text: 'Remove this coupon?',
                    icon: 'warning',
                    showCancelButton: true
                })
                .then(result => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: '/delete-coupon/' + id,
                            type: 'DELETE',
                            data: {
                                _token: '{{csrf_token()}}'
                            },
                            success: res => {
                                Swal.fire('Deleted', res.success, 'success');
                                table.ajax.reload();
                            }
                        });
                    }
                });
        });

        // Toggle status
        $(document).on('click', '.toggleStatusBtn', function() {
            var id = $(this).data('id');
            var btn = $(this);
            $.post('/coupon/status/' + id, {
                _token: '{{csrf_token()}}'
            }, function(res) {
                if (res.status) {
                    btn.text('Active').removeClass('btn-danger').addClass('btn-success');
                } else {
                    btn.text('Inactive').removeClass('btn-success').addClass('btn-danger');
                }
            });
        });


        // Update coupon
        $('#editCouponForm').submit(function(e) {
            e.preventDefault();
            let id = $('#edit_coupon_id').val();
            $.post('/coupon/update/' + id, $(this).serialize(), function(res) {
                Swal.fire('Updated', res.message, 'success');
                $('#editCouponModal').modal('hide');
                table.ajax.reload();
            }).fail(function(xhr) {
                Swal.fire('Error', xhr.responseJSON?.message || 'Error updating coupon', 'error');
            });
        });
    });

    $(document).ready(function() {


        // When Category Changes
        $('#category_id').on('change', function() {
            var categoryId = $(this).val();
            $('#product_id').html('<option value="">Loading...</option>');

            if (categoryId) {
                $.ajax({
                    url: '/get-products/' + categoryId,
                    type: 'GET',
                    success: function(data) {
                        $('#product_id').html('<option value="">-- Select Product --</option>');
                        $.each(data, function(key, product) {
                            $('#product_id').append('<option value="' + product.id + '">' + product.name + '</option>');
                        });
                    }
                });
            } else {
                $('#product_id').html('<option value="">-- Select Product --</option>');
            }
        });

function loadCategories(selectedId = null) {
    return $.get('/categories/list', function (categories) {
        let html = '<option value="">-- Select Category --</option>';
        $.each(categories, function (_, cat) {
            html += `<option value="${cat.id}">${cat.name}</option>`;
        });
        $('#edit_category_id').html(html);

        if (selectedId) {
            $('#edit_category_id').val(selectedId).trigger('change');
        }
    });
}

        // 🟢 1️⃣ When clicking "Edit" button — open modal & load data
      $(document).on('click', '.editCouponBtn', function () {

    let id = $(this).data('id');

    $.get('/coupons/' + id + '/edit', function (res) {

        let c = res.data;

        /* ---------------- BASIC FIELDS ---------------- */
        $('#edit_coupon_id').val(c.id);
        $('#edit_code').val(c.code);
        $('#edit_type').val(c.type);
        $('#edit_value').val(c.value);
        $('#edit_start_date').val(c.start_date);
        $('#edit_end_date').val(c.end_date);
        $('#edit_max_discount_amount').val(c.max_discount_amount);

        /* ---------------- CHECKBOXES ---------------- */
        $('#edit_is_active').prop('checked', !!c.is_active);
        $('#edit_first_time_user_only').prop('checked', !!c.first_time_user_only);
        $('#edit_is_stackable').prop('checked', !!c.is_stackable);
        $('#edit_auto_apply').prop('checked', !!c.auto_apply);

        /* ---------------- ALLOWED ROLES (FIXED) ---------------- */
        if (c.allowed_roles && c.allowed_roles.length > 0) {

            let roles = Array.isArray(c.allowed_roles)
                ? c.allowed_roles
                : JSON.parse(c.allowed_roles);

            // Normalize values to string
            roles = roles.map(String);

            // Clear + set
            $('#edit_allowed_roles')
                .val(null)
                .val(roles)
                .trigger('change');   // works for normal select + choices + select2
        }

        /* ---------------- CATEGORY ---------------- */
        $('#edit_category_id')
            .val(String(c.category_id))
            .trigger('change');

        /* ---------------- PRODUCT (DEPENDENT) ---------------- */
        $('#edit_product_id').html('<option value="">-- Select Product --</option>');

        if (c.category_id) {
            $.get('/get-products/' + c.category_id, function (products) {

                $.each(products, function (i, prod) {
                    $('#edit_product_id').append(
                        `<option value="${prod.id}">${prod.name}</option>`
                    );
                });

                // set selected product AFTER options load
                $('#edit_product_id')
                    .val(String(c.product_id))
                    .trigger('change');
            });
        }

        /* ---------------- SHOW MODAL ---------------- */
        $('#editCouponModal').modal('show');
    });
});





        // 🟢 3️⃣ When category changes inside edit modal
        $('#edit_category_id').on('change', function() {
            let categoryId = $(this).val();
            $('#edit_product_id').html('<option>Loading...</option>');

            if (categoryId) {
                $.get('/get-products/' + categoryId, function(data) {
                    $('#edit_product_id').html('<option value="">-- Select Product --</option>');
                    $.each(data, function(i, prod) {
                        $('#edit_product_id').append('<option value="' + prod.id + '">' + prod.name + '</option>');
                    });
                });
            }
        });


    });
</script>
@endsection