@extends('admin.layout.template')
@section('title', 'Banner')
@section('content')

<div class="page-content">
    <div class="container-xxl">

        <!-- Add Banner -->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Add Banner</h4>
                    </div>
                    <div class="card-body">
                        <form id="addBannerForm" enctype="multipart/form-data">
                            @csrf
                            <div class="row">

                                {{-- Title --}}
                                <div class="col-lg-3 mb-3">
                                    <label class="form-label">Title</label>
                                    <input type="text" name="title" class="form-control">
                                </div>

                                {{-- Banner Type --}}
                                <div class="col-lg-3 mb-3">
                                    <label class="form-label">Banner Type *</label>
                                    <select name="banner_type" class="form-control" required>
                                        <option value="">-- Select --</option>
                                        <option value="home_main">Home Main</option>
                                        <option value="offer">Offer</option>
                                        <option value="new_launch">New Launch</option>
                                        <option value="festival">Festival / Seasonal</option>
                                        <option value="announcement">Announcement</option>
                                    </select>
                                </div>

                                {{-- Placement --}}
                                <div class="col-lg-3 mb-3">
                                    <label class="form-label">Placement</label>
                                    <select name="placement" class="form-control">
                                        <option value="home">Home</option>
                                        <option value="category">Category</option>
                                        <option value="product">Product</option>
                                        <option value="dashboard">Dashboard</option>
                                    </select>
                                </div>

                                {{-- Audience --}}
                                <div class="col-lg-3 mb-3">
                                    <label class="form-label">Audience</label>
                                    <select name="audience" class="form-control">
                                        <option value="all">All</option>
                                        <option value="b2c">B2C</option>
                                        <option value="b2b">B2B</option>
                                        <option value="dealer">Dealer</option>
                                        <option value="franchise">Franchise</option>
                                        <option value="architect">Architect</option>
                                    </select>
                                </div>

                                {{-- Platform --}}
                                <div class="col-lg-3 mb-3">
                                    <label class="form-label">Platform</label>
                                    <select name="platform" class="form-control">
                                        <option value="all">All</option>
                                        <option value="website">Website</option>
                                        <option value="b2c_app">B2C App</option>
                                        <option value="b2b_app">B2B App</option>
                                    </select>
                                </div>

                                {{-- Category --}}
                                <div class="col-lg-3 mb-3">
                                    <label class="form-label">Category</label>
                                    <select name="category_id" id="category_id" class="form-control">
                                        <option value="">-- Select --</option>
                                        @foreach(App\Models\Category::all() as $cat)
                                        <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                {{-- Product --}}
                                <div class="col-lg-3 mb-3">
                                    <label class="form-label">Product</label>
                                    <select name="product_id" id="product_id" class="form-control">
                                        <option value="">-- Select --</option>
                                    </select>
                                </div>

                                {{-- Priority --}}
                                <div class="col-lg-3 mb-3">
                                    <label class="form-label">Priority</label>
                                    <input type="number" name="priority" class="form-control" value="0">
                                    <small class="text-muted">1 = Top Banner</small>
                                </div>

                                {{-- Auto Sort --}}
                                <div class="col-lg-3 mb-3">
                                    <label class="form-label">Auto Sort</label>
                                    <select name="auto_sort" class="form-control">
                                        <option value="0">Manual</option>
                                        <option value="1">Auto (By Clicks)</option>
                                    </select>
                                </div>

                                {{-- Start Date --}}
                                <div class="col-lg-3 mb-3">
                                    <label class="form-label">Start Date</label>
                                    <input type="date" name="start_date" class="form-control">
                                </div>

                                {{-- End Date --}}
                                <div class="col-lg-3 mb-3">
                                    <label class="form-label">End Date</label>
                                    <input type="date" name="end_date" class="form-control">
                                </div>

                                {{-- Image --}}
                                <div class="col-lg-3 mb-3">
                                    <label class="form-label">Image *</label>
                                    <input type="file" name="image" class="form-control" required>
                                </div>



                            </div>
                            <div class="text-end mt-3">
                                <button type="submit" class="btn btn-success">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Banner Table -->
        <div class="row mt-4">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table align-middle table-hover table-centered">
                                <thead class="bg-light-subtle">
                                    <tr>
                                        <th>#</th>
                                        <th>Title</th>
                                        <th>Type</th>
                                        <th>Audience</th>
                                        <th>Platform</th>
                                        <th>Priority</th>
                                        <th>Views</th>
                                        <th>Clicks</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<!-- 🔥 Edit Modal -->
<!-- <div class="modal fade" id="editBannerModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="editBannerForm" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="banner_id" id="edit_banner_id">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Banner</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <div class="row">
                        <div class="col-lg-3 mb-3">
                            <label>Title</label>
                            <input type="text" name="title" id="edit_title" class="form-control">
                        </div>
                        <div class="col-lg-3">
                            <label>Category</label>
                            <select name="category_id" id="edit_category_id" class="form-control edit-category">
                                @foreach(App\Models\Category::all() as $cat)
                                <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-lg-3">
                            <label>Product</label>
                            <select name="product_id" id="edit_product_id" class="form-control edit-product"></select>
                        </div>
                        <div class="col-lg-3">
                            <label>Image</label>
                            <input type="file" name="image" class="form-control">
                            <img id="current_image" class="mt-2" style="height:60px;">
                        </div>

                        <div class="col-lg-4">
                            <label>Seasonal Banner</label>
                            <div class="form-check form-switch">
                                <input class="form-check-input" name="seasonal_banner" value="1" type="checkbox" id="edit_seasonal">
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <label>Start Date</label>
                            <input type="date" name="start_date" id="edit_start_date" class="form-control">
                        </div>
                        <div class="col-lg-4">
                            <label>End Date</label>
                            <input type="date" name="end_date" id="edit_end_date" class="form-control">
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-purple">Update</button>
                </div>
            </form>
        </div>
    </div>
</div> -->
<div class="modal fade" id="editBannerModal" tabindex="-1">
    <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title">Edit Banner</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <form id="editBannerForm" enctype="multipart/form-data" class="needs-validation" novalidate>
                @csrf
                <input type="hidden" name="id" id="edit_id">

                <div class="modal-body">
                    <div class="row g-3">

                        <!-- Title -->
                        <div class="col-md-4">
                            <label class="form-label">Banner Title</label>
                            <input type="text" class="form-control" name="title" id="edit_title">
                        </div>

                        <!-- Banner Type -->
                        <div class="col-md-4">
                            <label class="form-label">Banner Type</label>
                            <select class="form-select" name="banner_type" id="edit_banner_type" required>
                                <option value="">Select</option>
                                <option value="home_main">Home Main</option>
                                <option value="offer">Offer</option>
                                <option value="new_launch">New Launch</option>
                                <option value="festival">Festival / Seasonal</option>
                                <option value="announcement">Announcement</option>
                            </select>
                        </div>
                        <!-- Banner Type -->
                        <div class="col-md-4">
                            <label class="form-label">Placement</label>
                            <select class="form-select" name="placement" id="edit_placement" required>
                                <option value="">Select</option>
                                <option value="home">Home</option>
                                <option value="category">Category</option>
                                <option value="product">Product</option>
                                <option value="dashboard">Dashboard</option>
                            </select>
                        </div>
                        <!-- Audience -->
                        <div class="col-md-4">
                            <label class="form-label">Visible For</label>
                            <select class="form-select" name="audience" id="edit_audience" required>
                                <option value="all">All</option>
                                <option value="all">All</option>
                                <option value="b2c">B2C</option>
                                <option value="b2b">B2B</option>
                                <option value="dealer">Dealer</option>
                                <option value="franchise">Franchise</option>
                                <option value="architect">Architect</option>
                            </select>
                        </div>

                        <!-- Platform -->
                        <div class="col-md-4">
                            <label class="form-label">Platform</label>
                            <select class="form-select" name="platform" id="edit_platform" required>
                                <option value="all">All</option>
                                <option value="website">Website</option>
                                <option value="b2c_app">B2C App</option>
                                <option value="b2b_app">B2B App</option>
                            </select>
                        </div>

                        <!-- Category -->
                        <div class="col-md-4">
                            <label class="form-label">Category</label>
                            <select class="form-control edit-category" name="category_id" id="edit_category_id">
                                <option value="">Select</option>
                                @foreach(App\Models\Category::all() as $cat)
                                <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Product -->
                        <div class="col-md-4">
                            <label class="form-label">Product</label>
                            <select class="form-control edit-product" name="product_id" id="edit_product_id">
                                <option value="">Select</option>
                            </select>
                        </div>

                        <!-- Auto Sort -->
                        <div class="col-md-4">
                            <label class="form-label">Sorting Mode</label>
                            <select class="form-select" name="auto_sort" id="edit_auto_sort">
                                <option value="1">Auto Sort</option>
                                <option value="0">Manual Sort</option>
                            </select>
                        </div>

                        <!-- Priority -->
                        <div class="col-md-4">
                            <label class="form-label">Priority</label>
                            <input type="number" class="form-control" name="priority" id="edit_priority" placeholder="1 = Top">
                        </div>




                        <!-- Start Date -->
                        <div class="col-md-4">
                            <label class="form-label">Start Date</label>
                            <input type="date" class="form-control" name="start_date" id="edit_start_date">
                        </div>

                        <!-- End Date -->
                        <div class="col-md-4">
                            <label class="form-label">End Date</label>
                            <input type="date" class="form-control" name="end_date" id="edit_end_date">
                        </div>

                        <!-- Image -->
                        <div class="col-md-4">
                            <label class="form-label">Banner Image</label>
                            <input type="file" class="form-control" name="image" >
                            <img id="preview_image" class="img-fluid mt-2 rounded" style="max-height:120px;">
                        </div>

                    </div>
                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Update Banner</button>
                </div>

            </form>
        </div>
    </div>
</div>
<script>
    $(function() {
        var table = $('.table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('get-banner') }}",
            columns: [{
                    data: 'DT_RowIndex'
                },
                {
                    data: 'title'
                },
                {
                    data: 'banner_type'
                },
                {
                    data: 'audience'
                },
                {
                    data: 'platform'
                },
                {
                    data: 'priority'
                },
                {
                    data: 'views'
                },
                {
                    data: 'clicks'
                },
                {
                    data: 'status'
                },
                {
                    data: 'action'
                }
            ]

        });

        // ADD BANNER
        $('#addBannerForm').submit(function(e) {
            e.preventDefault();
            var formData = new FormData(this);
            $.ajax({
                url: "{{ route('add-banner') }}",
                type: "POST",
                data: formData,
                contentType: false,
                processData: false,
                success: function(res) {
                    Swal.fire('Success', res.success, 'success');
                    $('#addBannerForm')[0].reset();
                    table.ajax.reload();
                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    let errMsg = '';
                    $.each(errors, function(k, v) {
                        errMsg += `• ${v}<br>`;
                        //errMsg += v + '\n';
                    });
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        html: errMsg
                    });
                }
            });
        });

        // OPEN MODAL FOR EDIT
    $(document).on('click', '.editbanner', function () {

    let b = $(this).data();

    // Hidden ID
    $('#edit_id').val(b.id);

    // Inputs
    $('#edit_title').val(b.title);
    $('#edit_banner_type').val(b.banner_type);
    $('#edit_placement').val(b.placement);
    $('#edit_audience').val(b.audience);
    $('#edit_platform').val(b.platform);
    $('#edit_auto_sort').val(b.auto_sort);
    $('#edit_priority').val(b.priority);

    // Dates
    $('#edit_start_date').val(b.start_date);
    $('#edit_end_date').val(b.end_date);

    // ✅ CATEGORY
    $('#edit_category_id').val(String(b.category_id)).trigger('change');

    // ✅ LOAD PRODUCTS & SELECT CURRENT
    if (b.category_id) {
        $.get('/banner/get-products/' + b.category_id, function (res) {

            let productSelect = $('#edit_product_id');
            productSelect.empty().append('<option value="">Select</option>');

            $.each(res, function (i, p) {
                productSelect.append(
                    `<option value="${p.id}">${p.name}</option>`
                );
            });

            productSelect.val(String(b.product_id));
        });
    } else {
        $('#edit_product_id').val('');
    }

    // ✅ IMAGE PREVIEW
    if (b.image) {
        $('#preview_image').attr('src', b.image).show();
    } else {
        $('#preview_image').hide();
    }

    $('#editBannerModal').modal('show');
});



        // UPDATE BANNER
        $('#editBannerForm').submit(function(e) {
            e.preventDefault();

            let id = $('#edit_id').val(); // 👈 hidden input value

            let formData = new FormData(this);
            formData.append('_method', 'PUT');

            $.ajax({
                url: '/update-banner/' + id, // ✅ IMPORTANT
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                success: function(res) {
                    Swal.fire('Success', res.success, 'success');
                    $('#editBannerModal').modal('hide');
                    $('.table').DataTable().ajax.reload();
                },
                error: function(xhr) {
                    console.log(xhr.responseText);
                }
            });
        });


        // STATUS TOGGLE
        $(document).on('click', '.toggleStatusBtn', function() {
            var bannerId = $(this).data('id');
            var btn = $(this);
            $.post("banner/status/" + bannerId, {
                _token: '{{csrf_token()}}'
            }, function(res) {
                btn.toggleClass('btn-success btn-danger').text(res.status ? 'Active' : 'Inactive');
            });
        });

        // PRODUCT CHANGE IN ADD
        $(document).on('change', '#category_id', function() {
            $.get("banner/get-products/" + $(this).val(), function(data) {
                $('#product_id').html('<option value="">-- Select --</option>');
                $.each(data, function(i, p) {
                    $('#product_id').append('<option value="' + p.id + '">' + p.name + '</option>');
                });
            })
        });

        // SEASONAL TOGGLE
        $('#seasonal').change(function() {
            $('#start_date, #end_date').prop('disabled', !$(this).is(':checked'));
        });
        $('#edit_seasonal').change(function() {
            $('#edit_start_date, #edit_end_date').prop('disabled', !$(this).is(':checked'));
        });


        // 🔄 Load products dynamically when category changes inside edit row
        // 🔄 Load products dynamically in edit modal
        $(document).on('change', '.edit-category', function() {
            var categoryId = $(this).val();
            var productSelect = $('#edit_product_id'); // 🔥 use modal ID

            if (categoryId) {
                $.ajax({
                    url: 'banner/get-products/' + categoryId,
                    type: 'GET',
                    success: function(data) {
                        productSelect.empty();
                        productSelect.append('<option value="">-- Select Product --</option>');
                        $.each(data, function(key, product) {
                            productSelect.append('<option value="' + product.id + '">' + product.name + '</option>');
                        });
                    }
                });
            } else {
                productSelect.empty().append('<option value="">-- Select Product --</option>');
            }
        });


        // Cancel Edit
        $(document).on('click', '.cancelEdit', function() {
            table.ajax.reload();
        });
    });

    $(document).on('click', '.deletebanner', function(e) {
        e.preventDefault();
        var id = $(this).data('id');
        Swal.fire({
            title: 'Delete?',
            text: "This will permanently delete the banner!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "{{ url('delete-banner') }}/" + id,
                    type: 'DELETE',
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Deleted!',
                            text: response.success,
                            timer: 1500,
                            showConfirmButton: false
                        });
                        table.ajax.reload();
                    }
                });
                table.ajax.reload();
            }
        });
    });
</script>

@endsection