@extends('admin.layout.template')

@section('content')

<body class="h-100">
     <div class="d-flex flex-column h-100 ">
          <div class="d-flex flex-column flex-grow-1">
               <div class="row h-100">
                    <div class="col-xxl-6">
                         <div class="row justify-content-center h-100">
                              <div class="col-lg-6 py-lg-5">
                                   <div class="d-flex flex-column h-100 justify-content-center">
                                        <div class="auth-logo mb-4">
                                             <a href="{{ url('/') }}" class="logo-dark">
                                                  <img src="{{ asset('assets/images/logo-dark.png') }}" height="84" alt="logo dark">
                                             </a>
                                             <a href="{{ url('/') }}" class="logo-light">
                                                  <img src="{{ asset('assets/images/logo-light.png') }}" height="84" alt="logo light">
                                             </a>
                                        </div>

                                        <h2 class="fw-bold fs-24">Sign In</h2>
                                        <p class="text-muted mt-1 mb-4">Enter your email address and password to access admin panel.</p>

                                        <div class="mb-5">
                                             <form method="POST" action="{{ route('login') }}" class="authentication-form">
                                                  @csrf

                                                  {{-- Show validation errors --}}
                                                  @if ($errors->any())
                                                       <div class="alert alert-danger">
                                                            <ul class="mb-0">
                                                                 @foreach ($errors->all() as $error)
                                                                      <li>{{ $error }}</li>
                                                                 @endforeach
                                                            </ul>
                                                       </div>
                                                  @endif

                                                  <!-- Email -->
                                                  <div class="mb-3">
                                                       <label class="form-label" for="email">Email</label>
                                                       <input type="email" id="email"
                                                              class="form-control"
                                                              name="email"
                                                              value="{{ old('email') }}"
                                                              required autofocus
                                                              placeholder="Enter your email">
                                                  </div>

                                                  <!-- Password -->
                                                  <div class="mb-3">
                                                       <label class="form-label" for="password">Password</label>
                                                       <input type="password" id="password"
                                                              class="form-control"
                                                              name="password"
                                                              required autocomplete="current-password"
                                                              placeholder="Enter your password">
                                                  </div>

                                                  <!-- Remember Me -->
                                                  <div class="mb-3">
                                                       <div class="form-check">
                                                            <input type="checkbox" class="form-check-input" id="remember" name="remember">
                                                            <label class="form-check-label" for="remember">Remember me</label>
                                                       </div>
                                                  </div>

                                                  <!-- Submit Button -->
                                                  <div class="mb-1 text-center d-grid">
                                                       <button class="btn btn-soft-primary" type="submit">Sign In</button>
                                                  </div>
                                             </form>
                                        </div>

                                        @if (Route::has('password.request'))
                                             <a class="text-danger text-center" href="{{ route('password.request') }}">
                                                  Forgot your password?
                                             </a>
                                        @endif
                                   </div>
                              </div>
                         </div>
                    </div>

                    <!-- Right Side Image -->
                    <div class="col-xxl-6 d-none d-xxl-flex">
                         <div class="card h-100 mb-0 overflow-hidden">
                              <div class="d-flex flex-column h-100">
                                   <img src="{{ asset('assets/images/login-bg.png') }}" alt="" class="w-100 h-100">
                              </div>
                         </div>
                    </div>
               </div>
          </div>
     </div>
@endsection
