<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('stocks', function (Blueprint $table) {
            // Stock Breakup
            $table->decimal('opening_qty', 10, 2)->nullable()->after('available_qty');
            $table->decimal('received_qty', 10, 2)->default(0)->after('opening_qty');
            $table->decimal('sold_qty', 10, 2)->default(0)->after('received_qty');
            $table->decimal('damaged_qty', 10, 2)->default(0)->after('sold_qty');
            $table->decimal('returned_qty', 10, 2)->default(0)->after('damaged_qty');

            // Optional: reorder intelligence
            $table->decimal('suggested_reorder_qty', 10, 2)->nullable()->after('reorder_level');
            $table->date('last_purchase_date')->nullable()->after('suggested_reorder_qty');

            // Optional: Fast/Slow Moving and Dead stock indicators
            $table->boolean('fast_moving')->default(false)->after('is_available');
            $table->boolean('slow_moving')->default(false)->after('fast_moving');
            $table->integer('days_no_movement')->nullable()->after('slow_moving');
        });
    }

    public function down(): void
    {
        Schema::table('stocks', function (Blueprint $table) {
            $table->dropColumn([
                'opening_qty',
                'received_qty',
                'sold_qty',
                'damaged_qty',
                'returned_qty',
                'suggested_reorder_qty',
                'last_purchase_date',
                'fast_moving',
                'slow_moving',
                'days_no_movement',
            ]);
        });
    }
};
