<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Schema::create('banners', function (Blueprint $table) {
        //     $table->id();
        //     $table->string('title')->nullable(); // Optional title for banner
        //     $table->string('image'); // Banner image path
        //     $table->foreignId('category_id')->nullable()->constrained('categories')->onDelete('set null');
        //     $table->foreignId('product_id')->nullable()->constrained('products')->onDelete('set null');
        //     $table->boolean('status')->default(1); // 1 = Active, 0 = Inactive
        //     $table->timestamp('created_at')->useCurrent();
        //     $table->timestamp('updated_at')->nullable()->useCurrentOnUpdate();
        // });

        Schema::create('banners', function (Blueprint $table) {
            $table->id();

            // Basic
            $table->string('title')->nullable();
            $table->string('image'); // banner image path

            // Banner Type / Purpose
            $table->enum('banner_type', [
                'home_main',
                'offer',
                'new_launch',
                'festival',
                'announcement'
            ]);

            // Show on which page / section
            $table->enum('placement', [
                'home',
                'category',
                'product',
                'dashboard'
            ])->default('home');

            // Target Audience
            $table->enum('audience', [
                'b2c',
                'b2b',
                'franchise',
                'architect',
                'dealer',
                'all'
            ])->default('all');

            // Platform Visibility
            $table->enum('platform', [
                'b2c_app',
                'b2b_app',
                'website',
                'all'
            ])->default('all');

            // Relations (optional)
            $table->foreignId('category_id')->nullable()
                ->constrained('categories')->nullOnDelete();

            $table->foreignId('product_id')->nullable()
                ->constrained('products')->nullOnDelete();

            // Priority & Sorting
            $table->integer('priority')->default(0);
            // 1 = Top banner

            $table->boolean('auto_sort')->default(false);

            // Schedule (IMPORTANT for seasonal / festival)
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();

            // Analytics
            $table->unsignedBigInteger('views')->default(0);
            $table->unsignedBigInteger('clicks')->default(0);

            // Status
            $table->boolean('status')->default(true);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('banners');
    }
};
