<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Stock extends Model
{
   protected $fillable = [
        'product_variant_id',
        'location_id',

        // Stock breakup
        'opening_qty',
        'received_qty',
        'sold_qty',
        'damaged_qty',
        'returned_qty',

        // Final stock & control
        'available_qty',
        'reserved_qty',
        'reorder_level',
        'suggested_reorder_qty',
        'last_purchase_date',

        // Movement indicators
        'fast_moving',
        'slow_moving',
        'days_no_movement',

        // Status
        'is_available',
    ];
    //protected $fillable = ['product_variant_id', 'location_id', 'available_qty', 'reorder_level'];
    public function location()
    {
        return $this->belongsTo(Location::class);
    }
public function productVariant()
    {
        return $this->belongsTo(ProductVariant::class, 'product_variant_id');
    }
}
