<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    protected $fillable = [
        'name',
        'slug',
        'image',
    ];
    
    // Override image attribute to return full URL
    protected $appends = ['image_full'];

   

    // App\Models\Category.php

public function subCategories()
{
    return $this->hasMany(SubCategory::class);
}

    // This creates image_full field
    public function getImageFullAttribute()
    {
        if (!$this->image) {
            return null;
        }

        // If image already has http or https avoid duplicating
        if (str_starts_with($this->image, 'http')) {
            return $this->image;
        }

        return url($this->image);
    }

    // OPTIONAL — replace "image" in response with full URL
    protected $hidden = ['image','pivot'];

    protected $casts = [
        'image_full' => 'string'
    ];
}
