<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Room;
use App\Models\Tags;
use Yajra\DataTables\Facades\DataTables;

class SettingsController extends Controller
{
    public function addRoom(Request $request)
    {
        $res = Room::insert([
            'name' => $request->input('name')
        ]);


        if ($res == 1)
            return redirect()->back()->with('success', 'Room added successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function getRoom()
    {
        $users = Room::orderBy('id', 'DESC')->get();

        return DataTables::of($users)
            ->addIndexColumn()
            ->addColumn('name', function ($data) {
                return   $data->name;
            })
            
            ->addColumn('action', function ($row) {
                return '<a href="" class="btn btn-sm btn-purple editroom" data-id="'.$row->id.'">Edit</a>
                <a href="" class="btn btn-sm btn-danger deleteroom" data-id="' . $row->id . '">Delete</a>';
            })
            ->escapeColumns([])
            ->make(true);
    }

    
    // Delete Room (AJAX)
    public function destroy($id)
    {
        $Room = Room::findOrFail($id);
        $Room->delete();
        return response()->json(['success' => 'Room deleted successfully.']);
    }

    public function update(Request $request, $id)
{
    $request->validate([
        'name' => 'required|string|max:100',
    ]);

    //$Room = Room::findOrFail($id);
    Room::where('id',$id)->update([
        'name' => $request->name,
    ]);

    return response()->json(['success' => 'Room updated successfully.']);
}


//**tags *************/

 public function addtag(Request $request)
    {
        $res = Tags::insert([
            'name' => $request->input('name')
        ]);


        if ($res == 1)
            return redirect()->back()->with('success', 'tag added successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function gettag()
    {
        $users = Tags::orderBy('id', 'DESC')->get();

        return DataTables::of($users)
            ->addIndexColumn()
            ->addColumn('name', function ($data) {
                return   $data->name;
            })
            
            ->addColumn('action', function ($row) {
                return '<a href="" class="btn btn-sm btn-purple edittag" data-id="'.$row->id.'">Edit</a>
                <a href="" class="btn btn-sm btn-danger deletetag" data-id="' . $row->id . '">Delete</a>';
            })
            ->escapeColumns([])
            ->make(true);
    }

    
    // Delete tag (AJAX)
    public function destroytag($id)
    {
        $tag = Tags::findOrFail($id);
        $tag->delete();
        return response()->json(['success' => 'tag deleted successfully.']);
    }

    public function updatetag(Request $request, $id)
{
    $request->validate([
        'name' => 'required|string|max:100',
    ]);

    //$tag = Tags::findOrFail($id);
    Tags::where('id',$id)->update([
        'name' => $request->name,
    ]);

    return response()->json(['success' => 'tag updated successfully.']);
}

}
